/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.graphview.core.access;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.openstreetmap.josm.plugins.graphview.core.access.AccessEvaluator;
import org.openstreetmap.josm.plugins.graphview.core.access.AccessParameters;
import org.openstreetmap.josm.plugins.graphview.core.access.AccessRuleset;
import org.openstreetmap.josm.plugins.graphview.core.access.AccessType;
import org.openstreetmap.josm.plugins.graphview.core.access.Implication;
import org.openstreetmap.josm.plugins.graphview.core.data.DataSource;
import org.openstreetmap.josm.plugins.graphview.core.data.MapBasedTagGroup;
import org.openstreetmap.josm.plugins.graphview.core.data.Tag;
import org.openstreetmap.josm.plugins.graphview.core.data.TagGroup;
import org.openstreetmap.josm.plugins.graphview.core.property.RoadPropertyType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RulesetAccessEvaluator<N, W, R>
implements AccessEvaluator<N, W> {
    private final DataSource<N, W, R> dataSource;
    private final AccessRuleset ruleset;
    private final AccessParameters parameters;

    public RulesetAccessEvaluator(DataSource<N, W, R> dataSource, AccessRuleset ruleset, AccessParameters parameters) {
        assert (dataSource != null && ruleset != null && parameters != null);
        this.dataSource = dataSource;
        this.ruleset = ruleset;
        this.parameters = parameters;
    }

    @Override
    public boolean wayUsable(W way, boolean forward, Map<RoadPropertyType<?>, Object> segmentPropertyValues) {
        TagGroup wayTags = this.dataSource.getTagsW(way);
        TagGroup wayTagsWithImplications = new MapBasedTagGroup(wayTags);
        for (Implication implication : this.ruleset.getImplications()) {
            wayTagsWithImplications = implication.apply(wayTagsWithImplications);
        }
        boolean usableWay = false;
        for (Tag tag : this.ruleset.getBaseTags()) {
            if (!wayTags.contains(tag)) continue;
            usableWay = true;
            break;
        }
        if (!usableWay) {
            return false;
        }
        String onewayValue = wayTagsWithImplications.getValue("oneway");
        if (forward && "-1".equals(onewayValue) && !"foot".equals(this.parameters.getAccessClass())) {
            return false;
        }
        if (!forward && ("1".equals(onewayValue) || "yes".equals(onewayValue) || "true".equals(onewayValue)) && !"foot".equals(this.parameters.getAccessClass())) {
            return false;
        }
        return this.objectUsable(segmentPropertyValues, wayTags);
    }

    @Override
    public boolean nodeUsable(N node, Map<RoadPropertyType<?>, Object> roadPropertyValues) {
        TagGroup nodeTags = this.dataSource.getTagsN(node);
        return this.objectUsable(roadPropertyValues, nodeTags);
    }

    private boolean objectUsable(Map<RoadPropertyType<?>, Object> roadPropertyValues, TagGroup tags) {
        AccessType accessType;
        block2: {
            String accessClass;
            for (RoadPropertyType<?> property : roadPropertyValues.keySet()) {
                if (property.isUsable(roadPropertyValues.get(property), this.parameters)) continue;
                return false;
            }
            accessType = AccessType.UNDEFINED;
            if (tags.size() <= 0) break block2;
            Map<String, AccessType> accessTypePerClass = this.createAccessTypePerClassMap(tags, this.ruleset.getAccessHierarchyAncestors(this.parameters.getAccessClass()));
            Iterator<String> i$ = this.ruleset.getAccessHierarchyAncestors(this.parameters.getAccessClass()).iterator();
            while (i$.hasNext() && (accessType = accessTypePerClass.get(accessClass = i$.next())) == AccessType.UNDEFINED) {
            }
        }
        return this.parameters.getAccessTypeUsable(accessType);
    }

    private Map<String, AccessType> createAccessTypePerClassMap(TagGroup wayTags, Collection<String> accessClasses) {
        HashMap<String, AccessType> accessTypePerClass = new HashMap<String, AccessType>();
        for (String accessClass : accessClasses) {
            accessTypePerClass.put(accessClass, AccessType.UNDEFINED);
        }
        Tag baseTag = null;
        for (Tag tag : wayTags) {
            if (!this.ruleset.getBaseTags().contains(tag)) continue;
            baseTag = tag;
            break;
        }
        if (baseTag != null) {
            TagGroup tagsWithBaseImplications = new MapBasedTagGroup(baseTag);
            for (Implication implication : this.ruleset.getImplications()) {
                tagsWithBaseImplications = implication.apply(tagsWithBaseImplications);
            }
            this.setAccessTypesFromTags(accessTypePerClass, tagsWithBaseImplications);
        }
        HashMap<String, String> tagMap = new HashMap<String, String>();
        for (Tag tag : wayTags) {
            if (tag.equals(baseTag)) continue;
            tagMap.put(tag.key, tag.value);
        }
        TagGroup tagsWithOtherImplications = new MapBasedTagGroup(tagMap);
        for (Implication implication : this.ruleset.getImplications()) {
            tagsWithOtherImplications = implication.apply(tagsWithOtherImplications);
        }
        this.setAccessTypesFromTags(accessTypePerClass, tagsWithOtherImplications);
        for (String key : this.ruleset.getAccessHierarchyAncestors(this.parameters.getAccessClass())) {
            String value = wayTags.getValue(key);
            if (value == null) continue;
            AccessType accessType = AccessType.getAccessType(value);
            accessTypePerClass.put(key, accessType);
        }
        return accessTypePerClass;
    }

    private void setAccessTypesFromTags(Map<String, AccessType> accessTypePerClass, TagGroup tags) {
        for (String accessClass : accessTypePerClass.keySet()) {
            String value = tags.getValue(accessClass);
            if (value == null) continue;
            AccessType accessType = AccessType.getAccessType(value);
            accessTypePerClass.put(accessClass, accessType);
        }
    }
}

