/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.slippymap;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.slippymap.SlippyMapKey;
import org.openstreetmap.josm.plugins.slippymap.SlippyMapPreferences;
import org.openstreetmap.josm.plugins.slippymap.SlippyMapTile;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class SlippyMapLayer
extends Layer
implements ImageObserver,
Preferences.PreferenceChangedListener {
    public int currentZoomLevel = SlippyMapPreferences.getMinZoomLvl();
    private Hashtable<SlippyMapKey, SlippyMapTile> tileStorage = null;
    Point[][] pixelpos = new Point[21][21];
    LatLon lastTopLeft;
    LatLon lastBotRight;
    private Image bufferImage;
    private SlippyMapTile clickedTile;
    private boolean needRedraw;
    private JPopupMenu tileOptionMenu;
    long lastCheck = 0L;
    LinkedList<SlippyMapTile> downloadQueue = new LinkedList();
    LinkedList<Image> downloadList = new LinkedList();
    int simultaneousTileDownloads = 5;
    int maxQueueSize = 50;
    Image lastScaledImage = null;
    Double lastImageScale = null;
    private static int nr_loaded = 0;
    private static int at_zoom = -1;

    static void debug(String msg) {
    }

    public SlippyMapLayer() {
        super(I18n.tr((String)"Slippy Map"));
        this.background = true;
        this.clearTileStorage();
        this.tileOptionMenu = new JPopupMenu();
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr((String)"Load Tile")){

            public void actionPerformed(ActionEvent ae) {
                if (SlippyMapLayer.this.clickedTile != null) {
                    SlippyMapLayer.this.loadSingleTile(SlippyMapLayer.this.clickedTile);
                    SlippyMapLayer.this.needRedraw = true;
                    Main.map.repaint();
                }
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr((String)"Show Tile Status")){

            public void actionPerformed(ActionEvent ae) {
                if (SlippyMapLayer.this.clickedTile != null) {
                    SlippyMapLayer.this.clickedTile.loadMetadata();
                    SlippyMapLayer.this.needRedraw = true;
                    Main.map.repaint();
                }
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr((String)"Request Update")){

            public void actionPerformed(ActionEvent ae) {
                if (SlippyMapLayer.this.clickedTile != null) {
                    SlippyMapLayer.this.clickedTile.requestUpdate();
                    SlippyMapLayer.this.needRedraw = true;
                    Main.map.repaint();
                }
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr((String)"Load All Tiles")){

            public void actionPerformed(ActionEvent ae) {
                SlippyMapLayer.this.loadAllTiles();
                SlippyMapLayer.this.needRedraw = true;
                Main.map.repaint();
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr((String)"Increase zoom")){

            public void actionPerformed(ActionEvent ae) {
                SlippyMapLayer.this.increaseZoomLevel();
                SlippyMapLayer.this.needRedraw = true;
                Main.map.repaint();
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr((String)"Decrease zoom")){

            public void actionPerformed(ActionEvent ae) {
                SlippyMapLayer.this.decreaseZoomLevel();
                Main.map.repaint();
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr((String)"Flush Tile Cache")){

            public void actionPerformed(ActionEvent ae) {
                System.out.print("flushing all tiles...");
                for (SlippyMapTile t : SlippyMapLayer.this.tileStorage.values()) {
                    t.dropImage();
                }
                System.out.println("done");
                SlippyMapLayer.this.shrinkTileStorage(0);
            }
        }));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Main.map.mapView.addMouseListener((MouseListener)new MouseAdapter(){

                    public void mouseClicked(MouseEvent e) {
                        if (e.getButton() != 3) {
                            return;
                        }
                        SlippyMapLayer.this.clickedTile = SlippyMapLayer.this.getTileForPixelpos(e.getX(), e.getY());
                        SlippyMapLayer.this.tileOptionMenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                });
                Layer.listeners.add(new Layer.LayerChangeListener(){

                    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
                    }

                    public void layerAdded(Layer newLayer) {
                    }

                    public void layerRemoved(Layer oldLayer) {
                        Main.pref.listener.remove(SlippyMapLayer.this);
                    }
                });
            }
        });
        Main.pref.listener.add(this);
    }

    public boolean zoomIncreaseAllowed() {
        boolean zia = this.currentZoomLevel < SlippyMapPreferences.getMaxZoomLvl();
        SlippyMapLayer.debug("zoomIncreaseAllowed(): " + zia + " " + this.currentZoomLevel + " vs. " + SlippyMapPreferences.getMaxZoomLvl());
        return zia;
    }

    public boolean increaseZoomLevel() {
        this.lastImageScale = null;
        if (this.zoomIncreaseAllowed()) {
            ++this.currentZoomLevel;
        } else {
            System.err.println("current zoom lvl (" + this.currentZoomLevel + ") couldnt be increased. " + "MaxZoomLvl (" + SlippyMapPreferences.getMaxZoomLvl() + ") reached.");
            return false;
        }
        SlippyMapLayer.debug("increasing zoom level to: " + this.currentZoomLevel);
        this.needRedraw = true;
        return true;
    }

    public boolean zoomDecreaseAllowed() {
        return this.currentZoomLevel > SlippyMapPreferences.getMinZoomLvl();
    }

    public boolean decreaseZoomLevel() {
        int minZoom = SlippyMapPreferences.getMinZoomLvl();
        this.lastImageScale = null;
        if (this.zoomDecreaseAllowed()) {
            SlippyMapLayer.debug("decreasing zoom level to: " + this.currentZoomLevel);
            --this.currentZoomLevel;
        } else {
            System.err.println("current zoom lvl couldnt be decreased. MinZoomLvl(" + minZoom + ") reached.");
            return false;
        }
        this.needRedraw = true;
        return true;
    }

    public void clearTileStorage() {
        int maxZoom = SlippyMapPreferences.getMaxZoomLvl();
        this.tileStorage = new Hashtable();
        this.checkTileStorage();
    }

    public void shrinkTileStorage(int maxNrTiles) {
        TreeSet<SlippyMapTile> tiles = new TreeSet<SlippyMapTile>(new TileTimeComp());
        tiles.addAll(this.tileStorage.values());
        int nr_to_drop = tiles.size() - maxNrTiles;
        if (nr_to_drop <= 0) {
            SlippyMapLayer.debug("total of " + tiles.size() + " loaded tiles, size OK (< " + maxNrTiles + ")");
            return;
        }
        SlippyMapLayer.debug("total of " + tiles.size() + " tiles, need to flush " + nr_to_drop + " tiles");
        for (SlippyMapTile t : tiles) {
            if (nr_to_drop <= 0) break;
            t.dropImage();
            --nr_to_drop;
        }
    }

    public void checkTileStorage() {
        long now = System.currentTimeMillis();
        if (now - this.lastCheck < 1000L) {
            return;
        }
        this.lastCheck = now;
        this.shrinkTileStorage(200);
    }

    synchronized void markDone(Image i) {
        boolean inList = this.downloadList.remove(i);
        if (!inList) {
            Main.debug((String)"ERROR: downloaded image was not queued");
            return;
        }
        if (this.downloadQueue.size() > 0) {
            this.loadSingleTile(this.downloadQueue.getLast());
        }
    }

    synchronized void loadSingleTile(SlippyMapTile tile) {
        if (this.downloadQueue.contains(tile)) {
            this.downloadQueue.remove(tile);
        }
        this.downloadQueue.addLast(tile);
        while (this.downloadQueue.size() > this.maxQueueSize) {
            this.downloadQueue.removeFirst();
        }
        if (this.downloadList.size() > this.simultaneousTileDownloads) {
            return;
        }
        while (!this.downloadQueue.isEmpty()) {
            tile = this.downloadQueue.removeLast();
            Image img = tile.loadImage();
            if (this.imageLoaded(img)) continue;
            Toolkit.getDefaultToolkit().prepareImage(img, -1, -1, this);
            this.downloadList.add(img);
            break;
        }
    }

    synchronized SlippyMapTile getTile(int x, int y, int zoom) {
        SlippyMapKey key = new SlippyMapKey(x, y, zoom);
        if (!key.valid) {
            return null;
        }
        return this.tileStorage.get(key);
    }

    synchronized SlippyMapTile putTile(SlippyMapTile tile, int x, int y, int zoom) {
        SlippyMapKey key = new SlippyMapKey(x, y, zoom);
        if (!key.valid) {
            return null;
        }
        return this.tileStorage.put(key, tile);
    }

    synchronized SlippyMapTile getOrCreateTile(int x, int y, int zoom) {
        SlippyMapTile tile = this.getTile(x, y, zoom);
        if (tile != null) {
            return tile;
        }
        tile = new SlippyMapTile(x, y, zoom);
        this.putTile(tile, x, y, zoom);
        return tile;
    }

    void loadAllTiles() {
        LatLon botRight;
        MapView mv = Main.map.mapView;
        LatLon topLeft = mv.getLatLon(0, 0);
        TileSet ts = new TileSet(topLeft, botRight = mv.getLatLon(mv.getWidth(), mv.getHeight()), this.currentZoomLevel);
        if (ts.tilesSpanned() > 324.0) {
            System.out.println("Not downloading all tiles because there is more than 18 tiles on an axis!");
            return;
        }
        for (Tile t : ts.allTiles()) {
            SlippyMapTile tile = this.getOrCreateTile(t.x, t.y, this.currentZoomLevel);
            if (tile.getImage() != null) continue;
            this.loadSingleTile(tile);
        }
    }

    double getImageScaling(Image img, Point p0, Point p1) {
        int realWidth = -1;
        int realHeight = -1;
        if (img != null) {
            realWidth = img.getHeight(this);
            realWidth = img.getWidth(this);
        }
        if (realWidth == -1 || realHeight == -1) {
            if (this.lastScaledImage != null) {
                return this.getImageScaling(this.lastScaledImage, p0, p1);
            }
            realWidth = 256;
            realHeight = 256;
        } else {
            this.lastScaledImage = img;
        }
        double drawWidth = p1.x - p0.x;
        double drawHeight = p1.x - p0.x;
        double drawArea = drawWidth * drawHeight;
        double realArea = realWidth * realHeight;
        return drawArea / realArea;
    }

    boolean imageLoaded(Image i) {
        if (i == null) {
            return false;
        }
        int status = Toolkit.getDefaultToolkit().checkImage(i, -1, -1, this);
        return (status & 0x20) != 0;
    }

    int paintTileImages(Graphics g, TileSet ts, int zoom) {
        int paintedTiles = 0;
        boolean imageScaleRecorded = false;
        Image img = null;
        for (Tile t : ts.allTiles()) {
            float fadeBackground;
            SlippyMapTile tile = this.getTile(t.x, t.y, zoom);
            if (tile == null) {
                if (zoom != this.currentZoomLevel) continue;
                tile = this.getOrCreateTile(t.x, t.y, zoom);
                if (SlippyMapPreferences.getAutoloadTiles()) {
                    this.loadSingleTile(tile);
                }
            }
            if ((img = tile.getImage()) == null || zoom != this.currentZoomLevel && !tile.isDownloaded()) continue;
            Point p = t.pixelPos(zoom);
            Tile t2 = new Tile(t.x + 1, t.y + 1);
            Point p2 = t2.pixelPos(zoom);
            if (this.imageLoaded(img)) {
                g.drawImage(img, p.x, p.y, p2.x - p.x, p2.y - p.y, this);
                ++paintedTiles;
            }
            if (img == null) continue;
            if (!imageScaleRecorded && zoom == this.currentZoomLevel) {
                this.lastImageScale = new Double(this.getImageScaling(img, p, p2));
                imageScaleRecorded = true;
            }
            if ((fadeBackground = SlippyMapPreferences.getFadeBackground()) == 0.0f) continue;
            g.setColor(new Color(1.0f, 1.0f, 1.0f, fadeBackground));
            g.fillRect(p.x, p.y, p2.x - p.x, p2.y - p.y);
        }
        return paintedTiles;
    }

    void paintTileText(TileSet ts, Graphics g, MapView mv, int zoom, Tile t) {
        String md;
        int fontHeight = g.getFontMetrics().getHeight();
        SlippyMapTile tile = this.getTile(t.x, t.y, zoom);
        if (tile == null) {
            return;
        }
        if (tile.getImage() == null) {
            this.loadSingleTile(tile);
        }
        Point p = t.pixelPos(zoom);
        int texty = p.y + 2 + fontHeight;
        if (SlippyMapPreferences.getDrawDebug()) {
            g.drawString("x=" + t.x + " y=" + t.y + " z=" + zoom + "", p.x + 2, texty);
            texty += 1 + fontHeight;
            if (t.x % 32 == 0 && t.y % 32 == 0) {
                g.drawString("x=" + t.x / 32 + " y=" + t.y / 32 + " z=7", p.x + 2, texty);
                texty += 1 + fontHeight;
            }
        }
        if ((md = tile.getMetadata()) != null) {
            g.drawString(md, p.x + 2, texty);
            texty += 1 + fontHeight;
        }
        String tileStatus = tile.getStatus();
        Image tileImage = tile.getImage();
        if (!this.imageLoaded(tileImage)) {
            g.drawString(I18n.tr((String)("image " + tileStatus)), p.x + 2, texty);
            texty += 1 + fontHeight;
        }
        if (!this.imageLoaded(tileImage)) {
            this.needRedraw = true;
            Main.map.repaint(100L);
        }
        if (SlippyMapPreferences.getDrawDebug() && ts.leftTile(t)) {
            if (t.y % 32 == 31) {
                g.fillRect(0, p.y - 1, mv.getWidth(), 3);
            } else {
                g.drawLine(0, p.y, mv.getWidth(), p.y);
            }
        }
    }

    public void paint(Graphics g, MapView mv) {
        int[] otherZooms;
        long start = System.currentTimeMillis();
        LatLon topLeft = mv.getLatLon(0, 0);
        LatLon botRight = mv.getLatLon(mv.getWidth(), mv.getHeight());
        Graphics oldg = g;
        if (botRight.lon() == 0.0 || botRight.lat() == 0.0) {
            Main.debug((String)"still initializing??");
            return;
        }
        if (this.lastTopLeft != null && this.lastBotRight != null && topLeft.equalsEpsilon(this.lastTopLeft) && botRight.equalsEpsilon(this.lastBotRight) && this.bufferImage != null && mv.getWidth() == this.bufferImage.getWidth(null) && mv.getHeight() == this.bufferImage.getHeight(null) && !this.needRedraw) {
            SlippyMapLayer.debug("drawing buffered image");
            g.drawImage(this.bufferImage, 0, 0, null);
            return;
        }
        this.needRedraw = false;
        this.lastTopLeft = topLeft;
        this.lastBotRight = botRight;
        this.bufferImage = mv.createImage(mv.getWidth(), mv.getHeight());
        g = this.bufferImage.getGraphics();
        TileSet ts = new TileSet(topLeft, botRight, this.currentZoomLevel);
        int zoom = this.currentZoomLevel;
        if (this.zoomDecreaseAllowed() && ts.tilesSpanned() > 18.0) {
            SlippyMapLayer.debug("too many tiles, decreasing zoom from " + this.currentZoomLevel);
            if (this.decreaseZoomLevel()) {
                this.paint(oldg, mv);
            }
            return;
        }
        if (this.zoomIncreaseAllowed() && ts.tilesSpanned() < 1.0) {
            SlippyMapLayer.debug("doesn't even cover one tile (" + ts.tilesSpanned() + "), increasing zoom from " + this.currentZoomLevel);
            if (this.increaseZoomLevel()) {
                this.paint(oldg, mv);
            }
            return;
        }
        if (ts.tilesSpanned() <= 0.0) {
            System.out.println("doesn't even cover one tile, increasing zoom from " + this.currentZoomLevel);
            if (this.increaseZoomLevel()) {
                this.paint(oldg, mv);
            }
            return;
        }
        int fontHeight = g.getFontMetrics().getHeight();
        g.setColor(Color.DARK_GRAY);
        for (int zoomOff : otherZooms = new int[]{-5, -4, -3, 2, -2, 1, -1}) {
            int zoom2 = this.currentZoomLevel + zoomOff;
            if (zoom2 < SlippyMapPreferences.getMinZoomLvl() || zoom2 > SlippyMapPreferences.getMaxZoomLvl()) continue;
            TileSet ts2 = new TileSet(topLeft, botRight, zoom2);
            int painted = this.paintTileImages(g, ts2, zoom2);
        }
        this.paintTileImages(g, ts, this.currentZoomLevel);
        g.setColor(Color.red);
        for (Tile t : ts.allTiles()) {
            if (ts.topTile(t)) {
                Point p = t.pixelPos(this.currentZoomLevel);
                if (SlippyMapPreferences.getDrawDebug()) {
                    if (t.x % 32 == 0) {
                        g.fillRect(p.x - 1, 0, 3, mv.getHeight());
                    } else {
                        g.drawLine(p.x, 0, p.x, mv.getHeight());
                    }
                }
            }
            this.paintTileText(ts, g, mv, this.currentZoomLevel, t);
        }
        float fadeBackground = SlippyMapPreferences.getFadeBackground();
        oldg.drawImage(this.bufferImage, 0, 0, null);
        if (this.lastImageScale != null) {
            if (this.lastImageScale > 3.0 && this.zoomIncreaseAllowed()) {
                if (SlippyMapPreferences.getAutozoom()) {
                    SlippyMapLayer.debug("autozoom increase: scale: " + this.lastImageScale);
                    this.increaseZoomLevel();
                }
                this.paint(oldg, mv);
            } else if (this.lastImageScale < 0.45 && this.lastImageScale > 0.0 && this.zoomDecreaseAllowed()) {
                if (SlippyMapPreferences.getAutozoom()) {
                    SlippyMapLayer.debug("autozoom decrease: scale: " + this.lastImageScale);
                    this.decreaseZoomLevel();
                }
                this.paint(oldg, mv);
            }
        }
        g.setColor(Color.black);
        g.drawString("currentZoomLevel=" + this.currentZoomLevel, 120, 120);
    }

    SlippyMapTile getTileForPixelpos(int px, int py) {
        MapView mv = Main.map.mapView;
        Point clicked = new Point(px, py);
        LatLon topLeft = mv.getLatLon(0, 0);
        LatLon botRight = mv.getLatLon(mv.getWidth(), mv.getHeight());
        TileSet ts = new TileSet(topLeft, botRight, this.currentZoomLevel);
        int z = this.currentZoomLevel;
        Tile clickedTile = null;
        Point p1 = null;
        Point p2 = null;
        for (Tile t1 : ts.allTiles()) {
            Tile t2 = new Tile(t1.x + 1, t1.y + 1);
            p1 = t1.pixelPos(z);
            p2 = t2.pixelPos(z);
            Rectangle r = new Rectangle(p1, new Dimension(p2.x, p2.y));
            if (!r.contains(clicked)) continue;
            clickedTile = t1;
            break;
        }
        if (clickedTile == null) {
            return null;
        }
        System.out.println("clicked on tile: " + clickedTile.x + " " + clickedTile.y + " scale: " + this.lastImageScale + " currentZoomLevel: " + this.currentZoomLevel);
        SlippyMapTile tile = this.getOrCreateTile(clickedTile.x, clickedTile.y, this.currentZoomLevel);
        this.checkTileStorage();
        return tile;
    }

    public Icon getIcon() {
        return ImageProvider.get((String)"slippymap");
    }

    public Object getInfoComponent() {
        return null;
    }

    public Component[] getMenuEntries() {
        return new Component[]{new JMenuItem((Action)new LayerListDialog.ShowHideLayerAction((Layer)this)), new JMenuItem((Action)new LayerListDialog.DeleteLayerAction((Layer)this)), new JSeparator(), new JMenuItem((Action)new RenameLayerAction(this.getAssociatedFile(), (Layer)this)), new JSeparator(), new JMenuItem((Action)new LayerListPopup.InfoAction((Layer)this))};
    }

    public String getToolTipText() {
        return null;
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void mergeFrom(Layer from) {
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
    }

    private int latToTileY(double lat, int zoom) {
        double l = lat / 180.0 * Math.PI;
        double pf = Math.log(Math.tan(l) + 1.0 / Math.cos(l));
        return (int)(Math.pow(2.0, zoom - 1) * (Math.PI - pf) / Math.PI);
    }

    private int lonToTileX(double lon, int zoom) {
        return (int)(Math.pow(2.0, zoom - 3) * (lon + 180.0) / 45.0);
    }

    private double tileYToLat(int y, int zoom) {
        return Math.atan(Math.sinh(Math.PI - Math.PI * (double)y / Math.pow(2.0, zoom - 1))) * 180.0 / Math.PI;
    }

    private double tileXToLon(int x, int zoom) {
        return (double)x * 45.0 / Math.pow(2.0, zoom - 3) - 180.0;
    }

    private SlippyMapTile imgToTile(Image img) {
        Enumeration<SlippyMapTile> e = this.tileStorage.elements();
        while (e.hasMoreElements()) {
            SlippyMapTile t = e.nextElement();
            if (t.getImageNoTimestamp() != img) continue;
            return t;
        }
        return null;
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        boolean error = (infoflags & 0x40) != 0;
        boolean done = (infoflags & 0x70) != 0;
        boolean success = (infoflags & 0x20) != 0;
        SlippyMapTile imageTile = this.imgToTile(img);
        if (success || error) {
            SlippyMapLayer.debug("tile done loading: " + imageTile);
            this.markDone(img);
        }
        if (imageTile == null) {
            System.err.println("no tile for image");
            return false;
        }
        if ((infoflags & 0x40) != 0) {
            String url = imageTile.getImageURL().toString();
            System.err.println("imageUpdate(" + img + ") error " + url + ")");
        }
        if ((infoflags & 0x20) != 0) {
            int z = imageTile.getZoom();
            if (z == at_zoom) {
                ++nr_loaded;
            } else {
                nr_loaded = 0;
                at_zoom = z;
            }
        }
        if ((infoflags & 8) != 0) {
            // empty if block
        }
        this.needRedraw = true;
        Main.map.repaint(done ? 0L : 100L);
        return !done;
    }

    public void preferenceChanged(String key, String newValue) {
        if (key.startsWith("slippymap") && !key.equals("slippymap.fade_background")) {
            this.clearTileStorage();
        }
    }

    public void destroy() {
        Main.pref.listener.remove(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TileSet {
        int z12x0;
        int z12x1;
        int z12y0;
        int z12y1;
        int zoom;
        int tileMax = -1;

        TileSet(LatLon topLeft, LatLon botRight, int zoom) {
            int tmp;
            this.zoom = zoom;
            this.z12x0 = SlippyMapLayer.this.lonToTileX(topLeft.lon(), zoom) - 1;
            this.z12y0 = SlippyMapLayer.this.latToTileY(topLeft.lat(), zoom) - 1;
            this.z12x1 = SlippyMapLayer.this.lonToTileX(botRight.lon(), zoom) + 1;
            this.z12y1 = SlippyMapLayer.this.latToTileY(botRight.lat(), zoom) + 1;
            if (this.z12x0 > this.z12x1) {
                tmp = this.z12x0;
                this.z12x0 = this.z12x1;
                this.z12x1 = tmp;
            }
            if (this.z12y0 > this.z12y1) {
                tmp = this.z12y0;
                this.z12y0 = this.z12y1;
                this.z12y1 = tmp;
            }
            this.tileMax = (int)Math.pow(2.0, zoom);
            if (this.z12x0 < 0) {
                this.z12x0 = 0;
            }
            if (this.z12y0 < 0) {
                this.z12y0 = 0;
            }
            if (this.z12x1 > this.tileMax) {
                this.z12x1 = this.tileMax;
            }
            if (this.z12y1 > this.tileMax) {
                this.z12y1 = this.tileMax;
            }
        }

        double tilesSpanned() {
            int x_span = this.z12x1 - this.z12x0;
            int y_span = this.z12y1 - this.z12y0;
            return Math.sqrt(1.0 * (double)x_span * (double)y_span);
        }

        List<Tile> allTiles() {
            ArrayList<Tile> ret = new ArrayList<Tile>();
            for (int x = this.z12x0; x <= this.z12x1; ++x) {
                for (int y = this.z12y0; y <= this.z12y1; ++y) {
                    Tile t = new Tile(x % this.tileMax, y % this.tileMax);
                    ret.add(t);
                }
            }
            return ret;
        }

        boolean topTile(Tile t) {
            return t.y == this.z12y0;
        }

        boolean leftTile(Tile t) {
            return t.x == this.z12x0;
        }
    }

    private class Tile {
        public int x;
        public int y;

        Tile(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public Point pixelPos(int zoom) {
            double lon = SlippyMapLayer.this.tileXToLon(this.x, zoom);
            LatLon tmpLL = new LatLon(SlippyMapLayer.this.tileYToLat(this.y, zoom), lon);
            MapView mv = Main.map.mapView;
            return mv.getPoint(tmpLL);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TileTimeComp
    implements Comparator<SlippyMapTile> {
        TileTimeComp() {
        }

        @Override
        public int compare(SlippyMapTile s1, SlippyMapTile s2) {
            long t1 = s1.access_time();
            long t2 = s2.access_time();
            if (s1 == s2) {
                return 0;
            }
            if (t1 == t2) {
                t1 = s1.hashCode();
                t2 = s2.hashCode();
            }
            if (t1 < t2) {
                return -1;
            }
            return 1;
        }
    }
}

