/*
 * Decompiled with CFR 0.152.
 */
package winstone.cluster;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import winstone.Cluster;
import winstone.HostConfiguration;
import winstone.HostGroup;
import winstone.Logger;
import winstone.WebAppConfiguration;
import winstone.WinstoneResourceBundle;
import winstone.WinstoneSession;
import winstone.cluster.ClusterSessionSearch;

public class SimpleCluster
implements Runnable,
Cluster {
    final int SESSION_CHECK_TIMEOUT = 100;
    final int HEARTBEAT_PERIOD = 5000;
    final int MAX_NO_OF_MISSING_HEARTBEATS = 3;
    final byte NODELIST_DOWNLOAD_TYPE = (byte)50;
    final byte NODE_HEARTBEAT_TYPE = (byte)51;
    public static final WinstoneResourceBundle CLUSTER_RESOURCES = new WinstoneResourceBundle("winstone.cluster.LocalStrings");
    private int controlPort;
    private String initialClusterNodes;
    private Map clusterAddresses = new Hashtable();
    private boolean interrupted = false;

    public SimpleCluster(Map args, Integer controlPort) {
        if (controlPort != null) {
            this.controlPort = controlPort;
        }
        this.initialClusterNodes = (String)args.get("clusterNodes");
        Thread thread = new Thread((Runnable)this, CLUSTER_RESOURCES.getString("SimpleCluster.ThreadName"));
        thread.setDaemon(true);
        thread.setPriority(1);
        thread.start();
    }

    public void destroy() {
        this.interrupted = true;
    }

    public void run() {
        if (this.initialClusterNodes != null) {
            StringTokenizer st = new StringTokenizer(this.initialClusterNodes, ",");
            while (st.hasMoreTokens() && !this.interrupted) {
                this.askClusterNodeForNodeList(st.nextToken());
            }
        }
        Logger.log(Logger.DEBUG, CLUSTER_RESOURCES, "SimpleCluster.InitNodes", "" + this.clusterAddresses.size());
        while (!this.interrupted) {
            try {
                HashSet addresses = new HashSet(this.clusterAddresses.keySet());
                Date noHeartbeatDate = new Date(System.currentTimeMillis() - 15000L);
                Iterator i = addresses.iterator();
                while (i.hasNext()) {
                    String ipPort = (String)i.next();
                    Date lastHeartBeat = (Date)this.clusterAddresses.get(ipPort);
                    if (lastHeartBeat.before(noHeartbeatDate)) {
                        this.clusterAddresses.remove(ipPort);
                        Logger.log(Logger.FULL_DEBUG, CLUSTER_RESOURCES, "SimpleCluster.RemovingNode", ipPort);
                        continue;
                    }
                    this.sendHeartbeat(ipPort);
                }
                Thread.sleep(5000L);
            }
            catch (Throwable err) {
                Logger.log(Logger.ERROR, CLUSTER_RESOURCES, "SimpleCluster.ErrorMonitorThread", err);
            }
        }
        Logger.log(Logger.FULL_DEBUG, CLUSTER_RESOURCES, "SimpleCluster.FinishedMonitorThread");
    }

    public WinstoneSession askClusterForSession(String sessionId, WebAppConfiguration webAppConfig) {
        ArrayList addresses = new ArrayList(this.clusterAddresses.keySet());
        ArrayList<ClusterSessionSearch> searchThreads = new ArrayList<ClusterSessionSearch>();
        Iterator i = addresses.iterator();
        while (i.hasNext()) {
            String ipPort = (String)i.next();
            ClusterSessionSearch search = new ClusterSessionSearch(webAppConfig.getContextPath(), webAppConfig.getOwnerHostname(), sessionId, ipPort, this.controlPort);
            searchThreads.add(search);
        }
        WinstoneSession answer = null;
        String senderThread = null;
        boolean finished = false;
        while (!finished) {
            ArrayList<ClusterSessionSearch> finishedThreads = new ArrayList<ClusterSessionSearch>();
            Iterator i2 = searchThreads.iterator();
            while (i2.hasNext()) {
                ClusterSessionSearch searchThread = (ClusterSessionSearch)i2.next();
                if (!searchThread.isFinished()) continue;
                if (searchThread.getResult() == null) {
                    finishedThreads.add(searchThread);
                    continue;
                }
                answer = searchThread.getResult();
                senderThread = searchThread.getAddressPort();
            }
            i2 = finishedThreads.iterator();
            while (i2.hasNext()) {
                searchThreads.remove(i2.next());
            }
            if (searchThreads.isEmpty() || answer != null) {
                finished = true;
                continue;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException err) {}
        }
        Iterator i3 = searchThreads.iterator();
        while (i3.hasNext()) {
            ClusterSessionSearch searchThread = (ClusterSessionSearch)i3.next();
            searchThread.destroy();
        }
        if (answer != null) {
            answer.activate(webAppConfig);
            Logger.log(Logger.DEBUG, CLUSTER_RESOURCES, "SimpleCluster.SessionTransferredFrom", senderThread);
        }
        return answer;
    }

    private void askClusterNodeForNodeList(String address) {
        try {
            int colonPos = address.indexOf(58);
            String ipAddress = address.substring(0, colonPos);
            String port = address.substring(colonPos + 1);
            Socket clusterListSocket = new Socket(ipAddress, Integer.parseInt(port));
            this.clusterAddresses.put(clusterListSocket.getInetAddress().getHostAddress() + ":" + port, new Date());
            InputStream in = clusterListSocket.getInputStream();
            OutputStream out = clusterListSocket.getOutputStream();
            out.write(50);
            out.flush();
            ObjectOutputStream outControl = new ObjectOutputStream(out);
            outControl.writeInt(this.controlPort);
            outControl.flush();
            ObjectInputStream inData = new ObjectInputStream(in);
            int nodeCount = inData.readInt();
            for (int n = 0; n < nodeCount; ++n) {
                this.clusterAddresses.put(inData.readUTF(), new Date());
            }
            inData.close();
            outControl.close();
            out.close();
            in.close();
            clusterListSocket.close();
        }
        catch (ConnectException err) {
            Logger.log(Logger.DEBUG, CLUSTER_RESOURCES, "SimpleCluster.NoNodeListResponse", address);
        }
        catch (Throwable err) {
            Logger.log(Logger.ERROR, CLUSTER_RESOURCES, "SimpleCluster.ErrorGetNodeList", address, err);
        }
    }

    private void sendHeartbeat(String address) {
        try {
            int colonPos = address.indexOf(58);
            String ipAddress = address.substring(0, colonPos);
            String port = address.substring(colonPos + 1);
            Socket heartbeatSocket = new Socket(ipAddress, Integer.parseInt(port));
            OutputStream out = heartbeatSocket.getOutputStream();
            out.write(51);
            out.flush();
            ObjectOutputStream outData = new ObjectOutputStream(out);
            outData.writeInt(this.controlPort);
            outData.close();
            heartbeatSocket.close();
            Logger.log(Logger.FULL_DEBUG, CLUSTER_RESOURCES, "SimpleCluster.HeartbeatSent", address);
        }
        catch (ConnectException err) {
        }
        catch (Throwable err) {
            Logger.log(Logger.ERROR, CLUSTER_RESOURCES, "SimpleCluster.HeartbeatError", address, err);
        }
    }

    public void clusterRequest(byte requestType, InputStream in, OutputStream out, Socket socket, HostGroup hostGroup) throws IOException {
        if (requestType == 49) {
            this.handleClusterSessionRequest(socket, in, out, hostGroup);
        } else if (requestType == 50) {
            this.handleNodeListDownloadRequest(socket, in, out);
        } else if (requestType == 51) {
            this.handleNodeHeartBeatRequest(socket, in);
        } else {
            Logger.log(Logger.ERROR, CLUSTER_RESOURCES, "SimpleCluster.UnknownRequest", "" + (char)requestType);
        }
    }

    public void handleClusterSessionRequest(Socket socket, InputStream in, OutputStream out, HostGroup hostGroup) throws IOException {
        ObjectInputStream inControl = new ObjectInputStream(in);
        int port = inControl.readInt();
        String ipPortSender = socket.getInetAddress().getHostAddress() + ":" + port;
        String sessionId = inControl.readUTF();
        String hostname = inControl.readUTF();
        HostConfiguration hostConfig = hostGroup.getHostByName(hostname);
        String webAppPrefix = inControl.readUTF();
        WebAppConfiguration webAppConfig = hostConfig.getWebAppByURI(webAppPrefix);
        ObjectOutputStream outData = new ObjectOutputStream(out);
        if (webAppConfig == null) {
            outData.writeUTF("NOTFOUND");
        } else {
            WinstoneSession session = webAppConfig.getSessionById(sessionId, true);
            if (session != null) {
                outData.writeUTF("FOUND");
                outData.writeObject(session);
                outData.flush();
                if (inControl.readUTF().equals("OK")) {
                    session.passivate();
                }
                Logger.log(Logger.DEBUG, CLUSTER_RESOURCES, "SimpleCluster.SessionTransferredTo", ipPortSender);
            } else {
                outData.writeUTF("NOTFOUND");
            }
        }
        outData.close();
        inControl.close();
    }

    public void handleNodeListDownloadRequest(Socket socket, InputStream in, OutputStream out) throws IOException {
        ObjectInputStream inControl = new ObjectInputStream(in);
        int port = inControl.readInt();
        String ipPortSender = socket.getInetAddress().getHostAddress() + ":" + port;
        ArrayList allClusterNodes = new ArrayList(this.clusterAddresses.keySet());
        ArrayList<String> relevantClusterNodes = new ArrayList<String>();
        Iterator i = allClusterNodes.iterator();
        while (i.hasNext()) {
            String node = (String)i.next();
            if (node.equals(ipPortSender)) continue;
            relevantClusterNodes.add(node);
        }
        ObjectOutputStream outData = new ObjectOutputStream(out);
        outData.writeInt(relevantClusterNodes.size());
        outData.flush();
        Iterator i2 = relevantClusterNodes.iterator();
        while (i2.hasNext()) {
            String ipPort = (String)i2.next();
            if (!ipPort.equals(ipPortSender)) {
                outData.writeUTF(ipPort);
            }
            outData.flush();
        }
        outData.close();
        inControl.close();
    }

    public void handleNodeHeartBeatRequest(Socket socket, InputStream in) throws IOException {
        ObjectInputStream inData = new ObjectInputStream(in);
        int remoteControlPort = inData.readInt();
        inData.close();
        String ipPort = socket.getInetAddress().getHostAddress() + ":" + remoteControlPort;
        this.clusterAddresses.put(ipPort, new Date());
        Logger.log(Logger.FULL_DEBUG, CLUSTER_RESOURCES, "SimpleCluster.HeartbeatReceived", ipPort);
    }
}

