/*
 * Decompiled with CFR 0.152.
 */
package winstone.classLoader;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import winstone.Logger;
import winstone.WebAppConfiguration;
import winstone.WinstoneResourceBundle;
import winstone.classLoader.WebappClassLoader;

public class ReloadingClassLoader
extends WebappClassLoader
implements ServletContextListener,
Runnable {
    private static final int RELOAD_SEARCH_SLEEP = 10;
    private static final WinstoneResourceBundle CL_RESOURCES = new WinstoneResourceBundle("winstone.classLoader.LocalStrings");
    private boolean interrupted;
    private WebAppConfiguration webAppConfig;
    private Set loadedClasses = new HashSet();
    private File[] classPaths;
    private int classPathsLength;

    public ReloadingClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
        if (urls != null) {
            this.classPaths = new File[urls.length];
            for (int n = 0; n < urls.length; ++n) {
                this.classPaths[this.classPathsLength++] = new File(urls[n].getFile());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addURL(URL url) {
        super.addURL(url);
        Set set = this.loadedClasses;
        synchronized (set) {
            if (this.classPaths == null) {
                this.classPaths = new File[10];
                this.classPathsLength = 0;
            } else if (this.classPathsLength == this.classPaths.length - 1) {
                File[] temp = this.classPaths;
                this.classPaths = new File[(int)((double)this.classPathsLength * 1.75)];
                System.arraycopy(temp, 0, this.classPaths, 0, this.classPathsLength);
            }
            this.classPaths[this.classPathsLength++] = new File(url.getFile());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent sce) {
        this.webAppConfig = (WebAppConfiguration)sce.getServletContext();
        this.interrupted = false;
        ReloadingClassLoader reloadingClassLoader = this;
        synchronized (reloadingClassLoader) {
            this.loadedClasses.clear();
        }
        Thread thread = new Thread((Runnable)this, CL_RESOURCES.getString("ReloadingClassLoader.ThreadName"));
        thread.setDaemon(true);
        thread.setPriority(1);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextDestroyed(ServletContextEvent sce) {
        this.interrupted = true;
        this.webAppConfig = null;
        ReloadingClassLoader reloadingClassLoader = this;
        synchronized (reloadingClassLoader) {
            this.loadedClasses.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Logger.log(Logger.FULL_DEBUG, CL_RESOURCES, "ReloadingClassLoader.MaintenanceThreadStarted");
        HashMap<String, Long> classDateTable = new HashMap<String, Long>();
        HashMap<String, File> classLocationTable = new HashMap<String, File>();
        HashSet<String> lostClasses = new HashSet<String>();
        while (!this.interrupted) {
            try {
                String[] loadedClassesCopy = null;
                ReloadingClassLoader reloadingClassLoader = this;
                synchronized (reloadingClassLoader) {
                    loadedClassesCopy = this.loadedClasses.toArray(new String[0]);
                }
                for (int n = 0; n < loadedClassesCopy.length && !this.interrupted; ++n) {
                    Long oldClassDate;
                    Thread.sleep(10L);
                    String className = ReloadingClassLoader.transformToFileFormat(loadedClassesCopy[n]);
                    File location = (File)classLocationTable.get(className);
                    Long classDate = null;
                    if (location == null || !location.exists()) {
                        for (int j = 0; j < this.classPaths.length && classDate == null; ++j) {
                            File path = this.classPaths[j];
                            if (!path.exists()) continue;
                            if (path.isDirectory()) {
                                File classLocation = new File(path, className);
                                if (!classLocation.exists()) continue;
                                classDate = new Long(classLocation.lastModified());
                                classLocationTable.put(className, classLocation);
                                continue;
                            }
                            if (!path.isFile() || (classDate = this.searchJarPath(className, path)) == null) continue;
                            classLocationTable.put(className, path);
                        }
                    } else if (location.exists()) {
                        classDate = new Long(location.lastModified());
                    }
                    if (classDate == null) {
                        if (lostClasses.contains(className)) continue;
                        lostClasses.add(className);
                        Logger.log(Logger.DEBUG, CL_RESOURCES, "ReloadingClassLoader.ClassLost", className);
                        continue;
                    }
                    if (classDate != null && lostClasses.contains(className)) {
                        lostClasses.remove(className);
                    }
                    if ((oldClassDate = (Long)classDateTable.get(className)) == null) {
                        classDateTable.put(className, classDate);
                        continue;
                    }
                    if (oldClassDate.compareTo(classDate) == 0) continue;
                    Logger.log(Logger.INFO, CL_RESOURCES, "ReloadingClassLoader.ReloadRequired", new String[]{className, "" + new Date(classDate), "" + new Date(oldClassDate)});
                    this.webAppConfig.resetClassLoader();
                }
            }
            catch (Throwable err) {
                Logger.log(Logger.ERROR, CL_RESOURCES, "ReloadingClassLoader.MaintenanceThreadError", err);
            }
        }
        Logger.log(Logger.FULL_DEBUG, CL_RESOURCES, "ReloadingClassLoader.MaintenanceThreadFinished");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class findClass(String name) throws ClassNotFoundException {
        ReloadingClassLoader reloadingClassLoader = this;
        synchronized (reloadingClassLoader) {
            this.loadedClasses.add("Class:" + name);
        }
        return super.findClass(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL findResource(String name) {
        ReloadingClassLoader reloadingClassLoader = this;
        synchronized (reloadingClassLoader) {
            this.loadedClasses.add(name);
        }
        return super.findResource(name);
    }

    private Long searchJarPath(String classResourceName, File path) throws IOException, InterruptedException {
        JarFile jar = new JarFile(path);
        Enumeration<JarEntry> e = jar.entries();
        while (e.hasMoreElements() && !this.interrupted) {
            JarEntry entry = e.nextElement();
            if (!entry.getName().equals(classResourceName)) continue;
            return new Long(path.lastModified());
        }
        return null;
    }

    private static String transformToFileFormat(String name) {
        if (!name.startsWith("Class:")) {
            return name;
        }
        return WinstoneResourceBundle.globalReplace(name.substring(6), ".", "/") + ".class";
    }
}

