/*
 * Decompiled with CFR 0.152.
 */
package winstone;

import java.util.Comparator;
import winstone.Launcher;
import winstone.Logger;
import winstone.WinstoneException;
import winstone.WinstoneRequest;

public class Mapping
implements Comparator {
    public static final int EXACT_PATTERN = 1;
    public static final int FOLDER_PATTERN = 2;
    public static final int EXTENSION_PATTERN = 3;
    public static final int DEFAULT_SERVLET = 4;
    public static final String STAR = "*";
    public static final String SLASH = "/";
    private String urlPattern;
    private String linkName;
    private String mappedTo;
    private int patternType;
    private boolean isPatternFirst;

    protected Mapping(String mappedTo) {
        this.mappedTo = mappedTo;
    }

    public static Mapping createFromURL(String mappedTo, String pattern) {
        if (pattern == null || mappedTo == null) {
            throw new WinstoneException(Launcher.RESOURCES.getString("Mapping.InvalidMount", new String[]{mappedTo, pattern}));
        }
        if (!(pattern.equals("") || pattern.startsWith(STAR) || pattern.startsWith(SLASH))) {
            pattern = SLASH + pattern;
        } else if (pattern.equals(STAR)) {
            Logger.log(Logger.WARNING, Launcher.RESOURCES, "Mapping.RewritingStarMount");
            pattern = "/*";
        }
        Mapping me = new Mapping(mappedTo);
        int firstStarPos = pattern.indexOf(STAR);
        int lastStarPos = pattern.lastIndexOf(STAR);
        int patternLength = pattern.length();
        if (pattern.equals(SLASH)) {
            me.urlPattern = "";
            me.patternType = 4;
        } else if (firstStarPos == -1) {
            me.urlPattern = pattern;
            me.patternType = 1;
        } else {
            if (firstStarPos != lastStarPos) {
                throw new WinstoneException(Launcher.RESOURCES.getString("Mapping.InvalidMount", new String[]{mappedTo, pattern}));
            }
            if (pattern.indexOf("/*") == patternLength - "/*".length()) {
                me.urlPattern = pattern.substring(0, pattern.length() - "/*".length());
                me.patternType = 2;
            } else {
                if (pattern.indexOf(SLASH) != -1) {
                    throw new WinstoneException(Launcher.RESOURCES.getString("Mapping.InvalidMount", new String[]{mappedTo, pattern}));
                }
                if (firstStarPos == 0) {
                    me.urlPattern = pattern.substring(STAR.length());
                    me.patternType = 3;
                    me.isPatternFirst = false;
                } else if (firstStarPos == patternLength - STAR.length()) {
                    me.urlPattern = pattern.substring(0, patternLength - STAR.length());
                    me.patternType = 3;
                    me.isPatternFirst = true;
                } else {
                    throw new WinstoneException(Launcher.RESOURCES.getString("Mapping.InvalidMount", new String[]{mappedTo, pattern}));
                }
            }
        }
        Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "Mapping.MappedPattern", new String[]{mappedTo, pattern});
        return me;
    }

    public static Mapping createFromLink(String mappedTo, String linkName) {
        if (linkName == null || mappedTo == null) {
            throw new WinstoneException(Launcher.RESOURCES.getString("Mapping.InvalidLink", new String[]{mappedTo, linkName}));
        }
        Mapping me = new Mapping(mappedTo);
        me.linkName = linkName;
        return me;
    }

    public int getPatternType() {
        return this.patternType;
    }

    public String getUrlPattern() {
        return this.urlPattern;
    }

    public String getMappedTo() {
        return this.mappedTo;
    }

    public String getLinkName() {
        return this.linkName;
    }

    public boolean match(String inputPattern, StringBuffer servletPath, StringBuffer pathInfo) {
        switch (this.patternType) {
            case 2: {
                if (inputPattern.startsWith(this.urlPattern + '/') || inputPattern.equals(this.urlPattern)) {
                    if (servletPath != null) {
                        servletPath.append(WinstoneRequest.decodeURLToken(this.urlPattern));
                    }
                    if (pathInfo != null) {
                        pathInfo.append(WinstoneRequest.decodeURLToken(inputPattern.substring(this.urlPattern.length())));
                    }
                    return true;
                }
                return false;
            }
            case 3: {
                int slashPos = inputPattern.lastIndexOf(SLASH);
                if (slashPos == -1 || slashPos == inputPattern.length() - 1) {
                    return false;
                }
                String fileName = inputPattern.substring(slashPos + 1);
                if (this.isPatternFirst && fileName.startsWith(this.urlPattern) || !this.isPatternFirst && fileName.endsWith(this.urlPattern)) {
                    if (servletPath != null) {
                        servletPath.append(WinstoneRequest.decodeURLToken(inputPattern));
                    }
                    return true;
                }
                return false;
            }
            case 1: {
                if (inputPattern.equals(this.urlPattern)) {
                    if (servletPath != null) {
                        servletPath.append(WinstoneRequest.decodeURLToken(inputPattern));
                    }
                    return true;
                }
                return false;
            }
            case 4: {
                if (servletPath != null) {
                    servletPath.append(WinstoneRequest.decodeURLToken(inputPattern));
                }
                return true;
            }
        }
        return false;
    }

    public int compare(Object objOne, Object objTwo) {
        Integer intTwo;
        Mapping one = (Mapping)objOne;
        Mapping two = (Mapping)objTwo;
        Integer intOne = new Integer(one.getPatternType());
        int order = -1 * intOne.compareTo(intTwo = new Integer(two.getPatternType()));
        if (order != 0) {
            return order;
        }
        if (one.getLinkName() != null) {
            return one.getLinkName().compareTo(two.getLinkName());
        }
        return -1 * one.getUrlPattern().compareTo(two.getUrlPattern());
    }

    public String toString() {
        return this.linkName != null ? "Link:" + this.linkName : "URLPattern:type=" + this.patternType + ",pattern=" + this.urlPattern;
    }
}

