/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.plugins.validator.OSMValidatorPlugin;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.tools.GBC;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Test
extends AbstractVisitor {
    protected String name;
    protected String description;
    protected boolean enabled = true;
    protected JCheckBox checkEnabled;
    protected JCheckBox checkBeforeUpload;
    protected boolean testBeforeUpload = true;
    protected boolean isBeforeUpload;
    protected List<TestError> errors = new ArrayList<TestError>(30);
    protected boolean partialSelection;

    public Test(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public Test(String name) {
        this.name = name;
    }

    public static void initialize(OSMValidatorPlugin plugin) throws Exception {
    }

    public void startTest() {
        this.errors = new ArrayList<TestError>(30);
    }

    public void setPartialSelection(boolean partialSelection) {
        this.partialSelection = partialSelection;
    }

    public List<TestError> getErrors() {
        return this.errors;
    }

    public void endTest() {
    }

    public void visit(Collection<OsmPrimitive> selection) {
        for (OsmPrimitive p : selection) {
            if (p.deleted || p.incomplete) continue;
            p.visit((Visitor)this);
        }
    }

    public void visit(Node n) {
    }

    public void visit(Way w) {
    }

    public void visit(Relation r) {
    }

    public void addGui(JPanel testPanel) {
        this.checkEnabled = new JCheckBox(this.name, this.enabled);
        this.checkEnabled.setToolTipText(this.description);
        testPanel.add((Component)this.checkEnabled, GBC.std());
        GBC a = GBC.eol();
        a.anchor = 13;
        this.checkBeforeUpload = new JCheckBox();
        this.checkBeforeUpload.setSelected(this.testBeforeUpload);
        testPanel.add((Component)this.checkBeforeUpload, a);
    }

    public boolean ok() {
        this.enabled = this.checkEnabled.isSelected();
        this.testBeforeUpload = this.checkBeforeUpload.isSelected();
        return false;
    }

    public Command fixError(TestError testError) {
        return null;
    }

    public boolean isFixable(TestError testError) {
        return false;
    }

    public boolean testBeforeUpload() {
        return this.testBeforeUpload;
    }

    public void setBeforeUpload(boolean isUpload) {
        this.isBeforeUpload = isUpload;
    }
}

