/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.plugins.validator.OSMValidatorPlugin;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.plugins.validator.util.AgregatePrimitivesVisitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class ValidateAction
extends JosmAction {
    private OSMValidatorPlugin plugin;
    private static final long serialVersionUID = -2304521273582574603L;
    private Collection<OsmPrimitive> lastSelection;

    public ValidateAction(OSMValidatorPlugin plugin) {
        super(I18n.tr((String)"Validation"), "validator", I18n.tr((String)"Performs the data validation"), Shortcut.registerShortcut((String)"tools:validate", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Validation")}), (int)86, (int)3, (int)1), true);
        this.plugin = plugin;
    }

    public void actionPerformed(ActionEvent ev) {
        this.doValidate(ev, true);
    }

    public void doValidate(ActionEvent ev, boolean getSelectedItems) {
        Collection<OsmPrimitive> selection;
        if (this.plugin.validateAction == null || Main.map == null || !Main.map.isVisible()) {
            return;
        }
        OSMValidatorPlugin.plugin.initializeErrorLayer();
        Collection<Test> tests = OSMValidatorPlugin.getEnabledTests(false);
        if (tests.isEmpty()) {
            return;
        }
        if (getSelectedItems) {
            selection = Main.main.getCurrentDataSet().getSelected();
            if (selection.isEmpty()) {
                selection = Main.main.getCurrentDataSet().allNonDeletedPrimitives();
                this.lastSelection = null;
            } else {
                AgregatePrimitivesVisitor v = new AgregatePrimitivesVisitor();
                selection = v.visit(selection);
                this.lastSelection = selection;
            }
        } else {
            selection = this.lastSelection == null ? Main.main.getCurrentDataSet().allNonDeletedPrimitives() : this.lastSelection;
        }
        ArrayList<TestError> errors = new ArrayList<TestError>(200);
        for (Test test : tests) {
            test.setPartialSelection(this.lastSelection != null);
            test.startTest();
            test.visit(selection);
            test.endTest();
            errors.addAll(test.getErrors());
        }
        tests = null;
        if (Main.pref.getBoolean("validator.ignore", true)) {
            for (TestError error : errors) {
                ArrayList<String> s = new ArrayList<String>();
                s.add(error.getIgnoreState());
                s.add(error.getIgnoreGroup());
                s.add(error.getIgnoreSubGroup());
                for (String state : s) {
                    if (state == null || !this.plugin.ignoredErrors.contains(state)) continue;
                    error.setIgnored(true);
                }
            }
        }
        this.plugin.validationDialog.tree.setErrors(errors);
        this.plugin.validationDialog.setVisible(true);
        DataSet.fireSelectionChanged((Collection)Main.main.getCurrentDataSet().getSelected());
    }
}

