/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.graphview.core.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.plugins.graphview.core.graph.ConnectorEvaluationGroup;
import org.openstreetmap.josm.plugins.graphview.core.graph.EvaluationGroup;
import org.openstreetmap.josm.plugins.graphview.core.graph.GraphEdge;
import org.openstreetmap.josm.plugins.graphview.core.graph.GraphNode;
import org.openstreetmap.josm.plugins.graphview.core.graph.JunctionEvaluationGroup;
import org.openstreetmap.josm.plugins.graphview.core.graph.WayGraph;
import org.openstreetmap.josm.plugins.graphview.core.graph.WayGraphObserver;
import org.openstreetmap.josm.plugins.graphview.core.transition.Restriction;
import org.openstreetmap.josm.plugins.graphview.core.transition.Segment;
import org.openstreetmap.josm.plugins.graphview.core.transition.SegmentNode;
import org.openstreetmap.josm.plugins.graphview.core.transition.TransitionStructure;
import org.openstreetmap.josm.plugins.graphview.core.transition.TransitionStructureObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TSBasedWayGraph
implements WayGraph,
TransitionStructureObserver {
    private final Set<WayGraphObserver> observers = new HashSet<WayGraphObserver>();
    private final TransitionStructure transitionStructure;
    private Collection<GraphNode> nodes;
    private List<GraphEdge> edges;

    public TSBasedWayGraph(TransitionStructure transitionStructure) {
        assert (transitionStructure != null);
        this.transitionStructure = transitionStructure;
        transitionStructure.addObserver(this);
        this.createNodesAndEdges();
    }

    @Override
    public Collection<GraphEdge> getEdges() {
        return this.edges;
    }

    @Override
    public Collection<GraphNode> getNodes() {
        return this.nodes;
    }

    private void createNodesAndEdges() {
        Collection<EvaluationGroup> evaluationGroups = TSBasedWayGraph.createEvaluationGroups(this.transitionStructure);
        for (EvaluationGroup evaluationGroup : evaluationGroups) {
            evaluationGroup.evaluate(this.transitionStructure.getRestrictions());
        }
        this.createNodesAndEdgesFromEvaluationGroups(evaluationGroups);
        evaluationGroups = null;
    }

    private static Collection<EvaluationGroup> createEvaluationGroups(TransitionStructure transitionStructure) {
        HashMap nodeSetMap = new HashMap();
        for (Restriction restriction : transitionStructure.getRestrictions()) {
            SegmentNode firstNode = restriction.getFrom().getNode2();
            TSBasedWayGraph.createSetIfHasNone(firstNode, nodeSetMap);
            for (Segment segment : restriction.getVias()) {
                TSBasedWayGraph.putInSameSet(segment.getNode1(), firstNode, nodeSetMap);
                TSBasedWayGraph.putInSameSet(segment.getNode2(), firstNode, nodeSetMap);
            }
            for (Segment segment : restriction.getTos()) {
                TSBasedWayGraph.putInSameSet(segment.getNode1(), firstNode, nodeSetMap);
            }
        }
        for (SegmentNode node : transitionStructure.getNodes()) {
            if (nodeSetMap.containsKey(node) || TSBasedWayGraph.isConnectedWithExactly2Nodes(node)) continue;
            TSBasedWayGraph.createSetIfHasNone(node, nodeSetMap);
        }
        HashMap segmentSetMap = new HashMap();
        for (Segment segment : transitionStructure.getSegments()) {
            SegmentNode node1 = segment.getNode1();
            SegmentNode node2 = segment.getNode2();
            if (nodeSetMap.containsKey(node1) && nodeSetMap.containsKey(node2) && nodeSetMap.get(node1) == nodeSetMap.get(node2)) continue;
            TSBasedWayGraph.createSetIfHasNone(segment, segmentSetMap);
            for (Segment subsequentSegment : segment.getNode2().getOutboundSegments()) {
                if (nodeSetMap.containsKey(node2) && subsequentSegment.getNode2() != node1) continue;
                TSBasedWayGraph.putInSameSet(subsequentSegment, segment, segmentSetMap);
            }
        }
        ArrayList<EvaluationGroup> evaluationGroups = new ArrayList<EvaluationGroup>(nodeSetMap.size() + segmentSetMap.size());
        HashSet nodeSets = new HashSet(nodeSetMap.values());
        for (Set nodeSet : nodeSets) {
            evaluationGroups.add(new JunctionEvaluationGroup(nodeSet));
        }
        HashSet hashSets = new HashSet(segmentSetMap.values());
        for (Set segmentSet : hashSets) {
            HashSet<SegmentNode> borderNodes = new HashSet<SegmentNode>();
            for (Segment segment : segmentSet) {
                if (nodeSetMap.containsKey(segment.getNode1())) {
                    borderNodes.add(segment.getNode1());
                }
                if (!nodeSetMap.containsKey(segment.getNode2())) continue;
                borderNodes.add(segment.getNode2());
            }
            evaluationGroups.add(new ConnectorEvaluationGroup(segmentSet, borderNodes));
        }
        return evaluationGroups;
    }

    private void createNodesAndEdgesFromEvaluationGroups(Collection<EvaluationGroup> evaluationGroups) {
        this.nodes = new LinkedList<GraphNode>();
        this.edges = new LinkedList<GraphEdge>();
        HashMap<Segment, GraphNodeImpl> segment2GNMap_approaching = new HashMap<Segment, GraphNodeImpl>();
        HashMap<Segment, GraphNodeImpl> segment2GNMap_leaving = new HashMap<Segment, GraphNodeImpl>();
        HashMap segNode2GNMap_approaching = new HashMap();
        HashMap segNode2GNMap_leaving = new HashMap();
        for (EvaluationGroup evaluationGroup : evaluationGroups) {
            GraphNodeImpl graphNode;
            if (!(evaluationGroup instanceof JunctionEvaluationGroup)) continue;
            JunctionEvaluationGroup junctionEG = (JunctionEvaluationGroup)evaluationGroup;
            for (Segment segment : junctionEG.getInboundSegments()) {
                graphNode = new GraphNodeImpl(segment.getNode2(), segment);
                this.nodes.add(graphNode);
                segment2GNMap_approaching.put(segment, graphNode);
                TSBasedWayGraph.addToCollectionMap(segNode2GNMap_approaching, segment.getNode2(), graphNode);
            }
            for (Segment segment : junctionEG.getOutboundSegments()) {
                graphNode = new GraphNodeImpl(segment.getNode1(), segment);
                this.nodes.add(graphNode);
                segment2GNMap_leaving.put(segment, graphNode);
                TSBasedWayGraph.addToCollectionMap(segNode2GNMap_leaving, segment.getNode1(), graphNode);
            }
            for (Segment inboundSegment : junctionEG.getInboundSegments()) {
                for (Segment outboundSegment : junctionEG.getOutboundSegments()) {
                    List<Segment> segmentSequence = junctionEG.getSegmentSequence(inboundSegment, outboundSegment);
                    if (segmentSequence == null) continue;
                    this.createGraphEdge((GraphNodeImpl)segment2GNMap_approaching.get(inboundSegment), (GraphNodeImpl)segment2GNMap_leaving.get(outboundSegment), segmentSequence);
                }
            }
        }
        for (EvaluationGroup evaluationGroup : evaluationGroups) {
            if (!(evaluationGroup instanceof ConnectorEvaluationGroup)) continue;
            ConnectorEvaluationGroup connectorEG = (ConnectorEvaluationGroup)evaluationGroup;
            for (SegmentNode startNode : connectorEG.getBorderNodes()) {
                for (SegmentNode targetNode : connectorEG.getBorderNodes()) {
                    if (!segNode2GNMap_leaving.containsKey(startNode) || !segNode2GNMap_approaching.containsKey(targetNode)) continue;
                    for (GraphNodeImpl startGraphNode : (Collection)segNode2GNMap_leaving.get(startNode)) {
                        for (GraphNodeImpl targetGraphNode : (Collection)segNode2GNMap_approaching.get(targetNode)) {
                            List<Segment> segmentSequence;
                            if (!connectorEG.getSegments().contains(startGraphNode.getSegment()) || !connectorEG.getSegments().contains(targetGraphNode.getSegment()) || (segmentSequence = connectorEG.getSegmentSequence(startNode, targetNode)) == null) continue;
                            this.createGraphEdge(startGraphNode, targetGraphNode, segmentSequence);
                        }
                    }
                }
            }
        }
    }

    private void createGraphEdge(GraphNodeImpl startNode, GraphNodeImpl targetNode, List<Segment> segments) {
        GraphEdgeImpl newEdge = new GraphEdgeImpl(startNode, targetNode, segments);
        startNode.addOutgoingEdge(newEdge);
        targetNode.addIncomingEdge(newEdge);
        this.edges.add(newEdge);
    }

    private static boolean isConnectedWithExactly2Nodes(SegmentNode node) {
        HashSet<SegmentNode> connectedNodes = new HashSet<SegmentNode>(2);
        for (Segment segment : node.getInboundSegments()) {
            connectedNodes.add(segment.getNode1());
        }
        for (Segment segment : node.getOutboundSegments()) {
            connectedNodes.add(segment.getNode2());
        }
        return connectedNodes.size() == 2;
    }

    private static <T> void createSetIfHasNone(T object, Map<T, Set<T>> objectSetMap) {
        if (!objectSetMap.containsKey(object)) {
            HashSet<T> set = new HashSet<T>();
            set.add(object);
            objectSetMap.put(object, set);
        }
    }

    private static <T> void putInSameSet(T object, T objectInSet, Map<T, Set<T>> objectSetMap) {
        assert (object != null && objectInSet != null && objectSetMap != null);
        assert (objectSetMap.containsKey(objectInSet));
        Set<T> set = objectSetMap.get(objectInSet);
        if (objectSetMap.containsKey(object)) {
            Set<T> oldSet = objectSetMap.get(object);
            for (T objectFromOldSet : oldSet) {
                set.add(objectFromOldSet);
                objectSetMap.put(objectFromOldSet, set);
            }
        } else {
            set.add(object);
            objectSetMap.put(object, set);
        }
    }

    private static <K, E> void addToCollectionMap(Map<K, Collection<E>> map, K key, E entry) {
        if (!map.containsKey(key)) {
            ArrayList newCollection = new ArrayList();
            map.put(key, newCollection);
        }
        map.get(key).add(entry);
    }

    @Override
    public void update(TransitionStructure transitionStructure) {
        this.createNodesAndEdges();
        this.notifyObservers();
    }

    @Override
    public void addObserver(WayGraphObserver observer) {
        this.observers.add(observer);
    }

    @Override
    public void deleteObserver(WayGraphObserver observer) {
        this.observers.remove(observer);
    }

    private void notifyObservers() {
        for (WayGraphObserver observer : this.observers) {
            observer.update(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GraphEdgeImpl
    implements GraphEdge {
        private final GraphNode startNode;
        private final GraphNode targetNode;
        private final List<Segment> segments;

        public GraphEdgeImpl(GraphNode startNode, GraphNode targetNode, List<Segment> segments) {
            assert (startNode != null && targetNode != null && segments != null);
            this.startNode = startNode;
            this.targetNode = targetNode;
            this.segments = segments;
        }

        @Override
        public GraphNode getStartNode() {
            return this.startNode;
        }

        @Override
        public GraphNode getTargetNode() {
            return this.targetNode;
        }

        @Override
        public List<Segment> getSegments() {
            return this.segments;
        }

        public String toString() {
            return "(" + this.startNode + "-->" + this.targetNode + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GraphNodeImpl
    implements GraphNode {
        private final SegmentNode node;
        private final Segment segment;
        private final List<GraphEdge> incomingEdges = new ArrayList<GraphEdge>();
        private final List<GraphEdge> outgoingEdges = new ArrayList<GraphEdge>();

        public GraphNodeImpl(SegmentNode node, Segment segment) {
            assert (node != null && segment != null);
            assert (segment.getNode1() == node || segment.getNode2() == node);
            this.node = node;
            this.segment = segment;
        }

        @Override
        public SegmentNode getSegmentNode() {
            return this.node;
        }

        @Override
        public Segment getSegment() {
            return this.segment;
        }

        public void addIncomingEdge(GraphEdge edge) {
            assert (edge != null);
            this.incomingEdges.add(edge);
        }

        @Override
        public Collection<GraphEdge> getInboundEdges() {
            return this.incomingEdges;
        }

        public void addOutgoingEdge(GraphEdge edge) {
            assert (edge != null);
            this.outgoingEdges.add(edge);
        }

        @Override
        public Collection<GraphEdge> getOutboundEdges() {
            return this.outgoingEdges;
        }

        public String toString() {
            return "(" + this.node + "; " + this.segment + ")";
        }
    }
}

