/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.ColorHelper;

public class ImageModifier {
    private static final long serialVersionUID = 1L;
    public static final int cadastreBackground = -1;
    public static final int cadastreBackgroundTransp = 1;
    public BufferedImage bufferedImage;
    private boolean withBackground = false;
    private int backgroundPixel = 0;
    private int backgroundSampleX;
    private int backgroundSampleY;

    public ImageModifier(BufferedImage bi) {
        this.bufferedImage = bi;
        if (Main.pref.getBoolean("cadastrewms.backgroundTransparent")) {
            this.makeTransparent();
        } else if (Main.pref.getBoolean("cadastrewms.alterColors")) {
            this.replaceBackground();
        }
        if (Main.pref.getBoolean("cadastrewms.invertGrey")) {
            this.invertGrey();
        }
    }

    private void replaceBackground() {
        int w = this.bufferedImage.getWidth();
        int h = this.bufferedImage.getHeight();
        int josmBackgroundColor = ColorHelper.html2color((String)Main.pref.get("color.background", "#000000")).getRGB();
        int x = 0;
        while (x < w) {
            int y = 0;
            while (y < h) {
                int pixel = this.bufferedImage.getRGB(x, y);
                if (pixel == -1) {
                    this.bufferedImage.setRGB(x, y, josmBackgroundColor);
                    if (!this.withBackground) {
                        this.withBackground = true;
                    }
                    this.backgroundSampleX = x;
                    this.backgroundSampleY = y;
                }
                ++y;
            }
            ++x;
        }
    }

    private void invertGrey() {
        int w = this.bufferedImage.getWidth();
        int h = this.bufferedImage.getHeight();
        int x = 0;
        while (x < w) {
            int y = 0;
            while (y < h) {
                int pixel = this.bufferedImage.getRGB(x, y);
                if (pixel != -1) {
                    this.bufferedImage.setRGB(x, y, this.reverseIfGrey(pixel));
                }
                ++y;
            }
            ++x;
        }
    }

    private int reverseIfGrey(int pixel) {
        Color col = new Color(pixel);
        int r = col.getRed();
        int g = col.getGreen();
        int b = col.getBlue();
        if (b == r && b == g) {
            pixel = 0 + ((byte)(255 - r) << 16) + ((byte)(255 - r) << 8) + (byte)(255 - r);
        }
        return pixel;
    }

    private void makeTransparent() {
        ColorModel colorModel = this.bufferedImage.getColorModel();
        if (this.bufferedImage.getColorModel() instanceof IndexColorModel) {
            IndexColorModel icm = (IndexColorModel)colorModel;
            WritableRaster raster = this.bufferedImage.getRaster();
            this.backgroundPixel = this.withBackground ? raster.getSample(this.backgroundSampleX, this.backgroundSampleY, 0) : 1;
            int size = icm.getMapSize();
            byte[] reds = new byte[size];
            byte[] greens = new byte[size];
            byte[] blues = new byte[size];
            icm.getReds(reds);
            icm.getGreens(greens);
            icm.getBlues(blues);
            IndexColorModel icm2 = new IndexColorModel(colorModel.getPixelSize(), size, reds, greens, blues, this.backgroundPixel);
            this.bufferedImage = new BufferedImage(icm2, raster, this.bufferedImage.isAlphaPremultiplied(), null);
        } else {
            int width = this.bufferedImage.getWidth();
            int height = this.bufferedImage.getHeight();
            BufferedImage bi = new BufferedImage(width, height, 2);
            int y = 0;
            while (y < height) {
                int x = 0;
                while (x < width) {
                    Color c = new Color(this.bufferedImage.getRGB(x, y));
                    int r = c.getRed();
                    int g = c.getGreen();
                    int b = c.getBlue();
                    Color maskedColor = r == 0 && g == 0 && b == 0 ? new Color(r, g, b, 0) : new Color(r, g, b, 255);
                    bi.setRGB(x, y, maskedColor.getRGB());
                    ++x;
                }
                ++y;
            }
            this.bufferedImage = bi;
        }
    }
}

