/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import cadastre_fr.CacheControl;
import cadastre_fr.GeorefImage;
import cadastre_fr.WMSLayer;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class WMSAdjustAction
extends MapMode
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    GeorefImage selectedImage;
    private ArrayList<WMSLayer> modifiedLayers = new ArrayList();
    WMSLayer selectedLayer;
    private boolean rasterMoved;
    private EastNorth prevEastNorth;
    private Mode mode = null;

    public WMSAdjustAction(MapFrame mapFrame) {
        super(I18n.tr((String)"Adjust WMS"), "adjustxywms", I18n.tr((String)"Adjust the position of the WMS layer (raster images only)"), mapFrame, ImageProvider.getCursor((String)"normal", (String)"move"));
    }

    public void enterMode() {
        super.enterMode();
        Main.map.mapView.addMouseListener((MouseListener)this);
        Main.map.mapView.addMouseMotionListener((MouseMotionListener)this);
        this.rasterMoved = false;
    }

    public void exitMode() {
        int reply;
        super.exitMode();
        Main.map.mapView.removeMouseListener((MouseListener)this);
        Main.map.mapView.removeMouseMotionListener((MouseMotionListener)this);
        if (this.rasterMoved && CacheControl.cacheEnabled && (reply = JOptionPane.showConfirmDialog(null, "Save the changes in cache ?", "Update cache", 0)) == 0) {
            this.saveModifiedLayers();
        }
        this.modifiedLayers.clear();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        boolean shift;
        if (e.getButton() != 1) {
            return;
        }
        boolean ctrl = (e.getModifiers() & 2) != 0;
        boolean bl = shift = (e.getModifiers() & 1) != 0;
        this.mode = shift ? Mode.moveZ : (ctrl ? Mode.rotate : Mode.moveXY);
        for (Layer layer : Main.map.mapView.getAllLayers()) {
            if (!layer.visible || !(layer instanceof WMSLayer) || !((WMSLayer)layer).isRaster()) continue;
            this.prevEastNorth = Main.map.mapView.getEastNorth(e.getX(), e.getY());
            this.selectedLayer = (WMSLayer)layer;
            this.selectedImage = this.selectedLayer.findImage(this.prevEastNorth);
            if (this.selectedImage == null) continue;
            Main.map.mapView.setCursor(Cursor.getPredefinedCursor(13));
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.selectedImage != null && (this.mode == Mode.moveXY || this.mode == Mode.moveZ || this.mode == Mode.rotate)) {
            EastNorth newEastNorth = Main.map.mapView.getEastNorth(e.getX(), e.getY());
            if (this.mode == Mode.moveXY) {
                this.displace(this.prevEastNorth, newEastNorth);
            } else if (this.mode == Mode.moveZ) {
                this.resize(newEastNorth);
            } else if (this.mode == Mode.rotate) {
                this.rotate(this.prevEastNorth, newEastNorth);
            }
            this.rasterMoved = true;
            if (!this.modifiedLayers.contains((Object)this.selectedLayer)) {
                this.modifiedLayers.add(this.selectedLayer);
            }
            Main.map.mapView.repaint();
            this.prevEastNorth = newEastNorth;
        }
    }

    private void displace(EastNorth start, EastNorth end) {
        this.selectedLayer.displace(end.east() - start.east(), end.north() - start.north());
    }

    private void resize(EastNorth newEastNorth) {
        double dPrev = this.prevEastNorth.distance(this.selectedLayer.getRasterCenter().east(), this.selectedLayer.getRasterCenter().north());
        double dNew = newEastNorth.distance(this.selectedLayer.getRasterCenter().east(), this.selectedLayer.getRasterCenter().north());
        this.selectedLayer.resize(1.0 - dNew / dPrev);
    }

    private void rotate(EastNorth start, EastNorth end) {
        EastNorth pivot = this.selectedLayer.getRasterCenter();
        double startAngle = Math.atan2(start.east() - pivot.east(), start.north() - pivot.north());
        double endAngle = Math.atan2(end.east() - pivot.east(), end.north() - pivot.north());
        double rotationAngle = endAngle - startAngle;
        this.selectedLayer.rotate(rotationAngle);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        Main.map.mapView.setCursor(Cursor.getDefaultCursor());
        this.selectedImage = null;
        this.prevEastNorth = null;
        this.selectedLayer = null;
        this.mode = null;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    private void saveModifiedLayers() {
        for (WMSLayer wmsLayer : this.modifiedLayers) {
            wmsLayer.saveNewCache();
        }
    }

    static enum Mode {
        moveXY,
        moveZ,
        rotate;

    }
}

