/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import cadastre_fr.CadastreGrabber;
import cadastre_fr.CadastrePreferenceSetting;
import cadastre_fr.CheckSourceUploadHook;
import cadastre_fr.MenuActionGrab;
import cadastre_fr.MenuActionLambertZone;
import cadastre_fr.MenuActionLoadFromCache;
import cadastre_fr.MenuActionNewLocation;
import cadastre_fr.MenuActionResetCookie;
import cadastre_fr.WMSAdjustAction;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.UploadAction;
import org.openstreetmap.josm.data.projection.Lambert;
import org.openstreetmap.josm.gui.IconToggleButton;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.tools.I18n;

public class CadastrePlugin
extends Plugin {
    static String VERSION = "1.0";
    static JMenu cadastreJMenu;
    public static CadastreGrabber cadastreGrabber;
    public static String source;
    public static boolean autoSourcing;
    public static boolean pluginUsed;
    public static String cacheDir;
    public static boolean alterColors;
    public static boolean backgroundTransparent;
    public static float transparency;
    public static boolean drawBoundaries;
    private static boolean menuEnabled;

    static {
        cadastreGrabber = new CadastreGrabber();
        source = "";
        autoSourcing = false;
        pluginUsed = false;
        cacheDir = null;
        alterColors = false;
        backgroundTransparent = false;
        transparency = 1.0f;
        drawBoundaries = false;
        menuEnabled = false;
    }

    public CadastrePlugin() throws Exception {
        System.out.println("Pluging \"cadastre-fr\" started...");
        if (Main.pref.get("cadastrewms.cacheDir").equals("")) {
            cacheDir = String.valueOf(Main.pref.getPreferencesDir()) + "plugins/cadastrewms/";
        } else {
            cacheDir = Main.pref.get("cadastrewms.cacheDir");
            if (cacheDir.charAt(cacheDir.length() - 1) != '\\') {
                cacheDir = String.valueOf(cacheDir) + '\\';
            }
        }
        System.out.println("current cache directory: " + cacheDir);
        CadastrePlugin.refreshConfiguration();
        this.refreshMenu();
        LinkedList hooks = ((UploadAction)Main.main.menu.upload).uploadHooks;
        hooks.add(0, new CheckSourceUploadHook());
    }

    public void refreshMenu() throws Exception {
        boolean isLambertProjection = Main.proj.toString().equals(new Lambert().toString());
        MainMenu menu = Main.main.menu;
        if (cadastreJMenu == null) {
            String string = I18n.marktr((String)"Cadastre");
            menu.getClass();
            cadastreJMenu = menu.addMenu(string, 67, 5);
            if (isLambertProjection) {
                MenuActionGrab grab = new MenuActionGrab();
                JMenuItem menuGrab = new JMenuItem((Action)((Object)grab));
                KeyStroke ks = grab.getShortcut().getKeyStroke();
                if (ks != null) {
                    menuGrab.setAccelerator(ks);
                }
                JMenuItem menuSettings = new JMenuItem((Action)((Object)new MenuActionNewLocation()));
                final JCheckBoxMenuItem menuSource = new JCheckBoxMenuItem(I18n.tr((String)"Auto sourcing"));
                menuSource.setSelected(autoSourcing);
                menuSource.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        Main.pref.put("cadastrewms.autosourcing", menuSource.isSelected());
                        autoSourcing = menuSource.isSelected();
                    }
                });
                JMenuItem menuResetCookie = new JMenuItem((Action)((Object)new MenuActionResetCookie()));
                JMenuItem menuLambertZone = new JMenuItem((Action)((Object)new MenuActionLambertZone()));
                JMenuItem menuLoadFromCache = new JMenuItem((Action)((Object)new MenuActionLoadFromCache()));
                cadastreJMenu.add(menuGrab);
                cadastreJMenu.add(menuSettings);
                cadastreJMenu.add(menuSource);
                cadastreJMenu.add(menuResetCookie);
                cadastreJMenu.add(menuLambertZone);
                cadastreJMenu.add(menuLoadFromCache);
            } else {
                JMenuItem hint = new JMenuItem(I18n.tr((String)"Invalid projection"));
                hint.setToolTipText(I18n.tr((String)"Change the projection to {0} first.", (Object[])new Object[]{new Lambert().toString()}));
                hint.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"To enable the cadastre WMS plugin, change\nthe JOSM projection to Lambert and restart"));
                    }
                });
                cadastreJMenu.add(hint);
            }
        }
        this.setEnabledAll(menuEnabled);
    }

    public static void refreshConfiguration() {
        source = Main.pref.get("cadastrewms.source", "cadastre-dgi-fr source : Direction G\u00e9n\u00e9rale des Imp\u00f4ts - Cadastre ; mise \u00e0 jour : AAAA");
        autoSourcing = Main.pref.getBoolean("cadastrewms.autosourcing", true);
        alterColors = Main.pref.getBoolean("cadastrewms.alterColors");
        drawBoundaries = Main.pref.getBoolean("cadastrewms.drawBoundaries", false);
        if (alterColors) {
            backgroundTransparent = Main.pref.getBoolean("cadastrewms.backgroundTransparent");
            transparency = Float.parseFloat(Main.pref.get("cadastrewms.brightness", "1.0f"));
        } else {
            backgroundTransparent = false;
            transparency = 1.0f;
        }
        int i = 0;
        String p = Main.pref.get("shortcut.shortcut." + i, null);
        boolean alreadyRedefined = false;
        while (p != null) {
            String[] s = p.split(";");
            alreadyRedefined = alreadyRedefined || s[0].equals("menu:view:fullscreen");
            p = Main.pref.get("shortcut.shortcut." + ++i, null);
        }
        if (!alreadyRedefined) {
            int reply = JOptionPane.showConfirmDialog(null, I18n.tr((String)"Plugin cadastre-fr used traditionaly for grabbing the key shortcut F11\nwhich is currently allocated for full-screen switch by default\nWould you like to restore F11 for grab action ?"), I18n.tr((String)"Restore grab shortcut F11"), 0);
            if (reply == 0) {
                System.out.println("redefine fullscreen shortcut F11 to shift+F11");
                Main.pref.put("shortcut.shortcut." + i, "menu:view:fullscreen;Toggle Full Screen view;122;5;122;64;false;true");
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"JOSM is stopped for the change to take effect."));
                System.exit(0);
            }
        } else {
            System.out.println("shortcut F11 already redefined; do not change");
        }
    }

    public PreferenceSetting getPreferenceSetting() {
        return new CadastrePreferenceSetting();
    }

    private void setEnabledAll(boolean isEnabled) {
        int i = 0;
        while (i < cadastreJMenu.getItemCount()) {
            JMenuItem item = cadastreJMenu.getItem(i);
            if (item != null) {
                if (item.getText().equals(MenuActionGrab.name)) {
                    item.setEnabled(isEnabled);
                } else if (item.getText().equals(MenuActionLambertZone.name)) {
                    item.setEnabled(!isEnabled);
                }
            }
            ++i;
        }
        menuEnabled = isEnabled;
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (cadastreJMenu != null) {
            if (oldFrame == null && newFrame != null) {
                this.setEnabledAll(true);
                Main.map.addMapMode(new IconToggleButton((Action)((Object)new WMSAdjustAction(Main.map))));
            } else if (oldFrame != null && newFrame == null) {
                this.setEnabledAll(false);
                Lambert.layoutZone = -1;
            }
        }
    }
}

