/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import cadastre_fr.CadastreInterface;
import cadastre_fr.GeorefImage;
import cadastre_fr.ImageModifier;
import cadastre_fr.WMSLayer;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.imageio.ImageIO;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.ProgressInputStream;
import org.openstreetmap.josm.tools.I18n;

public class CadastreGrabber {
    public static final double epsilon = 1.0E-11;
    private CadastreInterface wmsInterface = new CadastreInterface(this);
    private String lastWMSLayerName = null;

    CadastreGrabber() {
        this.getWmsInterface().downloadCancelled = false;
    }

    public GeorefImage grab(WMSLayer wmsLayer, EastNorth lambertMin, EastNorth lambertMax) throws IOException, OsmTransferException {
        try {
            URL url = null;
            url = wmsLayer.isRaster() ? this.getURLRaster(wmsLayer, lambertMin, lambertMax) : this.getURLVector(lambertMin, lambertMax);
            System.out.println("grab:" + url);
            BufferedImage img = this.grab(url);
            ImageModifier imageModified = new ImageModifier(img);
            return new GeorefImage(imageModified.bufferedImage, lambertMin, lambertMax);
        }
        catch (MalformedURLException e) {
            throw (IOException)new IOException(I18n.tr((String)"CadastreGrabber: Illegal url.")).initCause(e);
        }
    }

    private URL getURLRaster(WMSLayer wmsLayer, EastNorth lambertMin, EastNorth lambertMax) throws MalformedURLException {
        String str = new String(String.valueOf(this.wmsInterface.baseURL) + "/scpc/wms?version=1.1&request=GetMap");
        str = String.valueOf(str) + "&layers=CDIF:PMC@";
        str = String.valueOf(str) + wmsLayer.getCodeCommune();
        str = String.valueOf(str) + "&format=image/png";
        str = String.valueOf(str) + "&bbox=";
        str = String.valueOf(str) + wmsLayer.eastNorth2raster(lambertMin, lambertMax);
        str = String.valueOf(str) + "&width=600&height=600";
        str = String.valueOf(str) + "&exception=application/vnd.ogc.se_inimage&styles=";
        return new URL(str.replace(" ", "%20"));
    }

    private URL getURLVector(EastNorth lambertMin, EastNorth lambertMax) throws MalformedURLException {
        String str = new String(String.valueOf(this.wmsInterface.baseURL) + "/scpc/wms?version=1.1&request=GetMap");
        str = String.valueOf(str) + "&layers=CDIF:LS3,CDIF:LS2,CDIF:LS1,CDIF:PARCELLE,CDIF:NUMERO";
        str = String.valueOf(str) + ",CDIF:PT3,CDIF:PT2,CDIF:PT1,CDIF:LIEUDIT";
        str = String.valueOf(str) + ",CDIF:SUBSECTION";
        str = String.valueOf(str) + ",CDIF:SECTION";
        str = String.valueOf(str) + ",CDIF:COMMUNE";
        str = String.valueOf(str) + "&format=image/png";
        str = String.valueOf(str) + "&bbox=" + lambertMin.east() + ",";
        str = String.valueOf(str) + lambertMin.north() + ",";
        str = String.valueOf(str) + lambertMax.east() + ",";
        str = String.valueOf(str) + lambertMax.north();
        str = String.valueOf(str) + "&width=1000&height=800";
        str = String.valueOf(str) + "&styles=LS3_90,LS2_90,LS1_90,PARCELLE_90,NUMERO_90,PT3_90,PT2_90,PT1_90,LIEUDIT_90";
        str = String.valueOf(str) + ",SUBSECTION_90";
        str = String.valueOf(str) + ",SECTION_90";
        str = String.valueOf(str) + ",COMMUNE_90";
        System.out.println("URL=" + str);
        return new URL(str.replace(" ", "%20"));
    }

    private BufferedImage grab(URL url) throws IOException, OsmTransferException {
        this.wmsInterface.urlConn = (HttpURLConnection)url.openConnection();
        this.wmsInterface.urlConn.setRequestMethod("GET");
        this.wmsInterface.setCookie();
        ProgressInputStream is = new ProgressInputStream((URLConnection)this.wmsInterface.urlConn, NullProgressMonitor.INSTANCE);
        BufferedImage img = ImageIO.read((InputStream)is);
        is.close();
        return img;
    }

    public CadastreInterface getWmsInterface() {
        return this.wmsInterface;
    }

    public String getLastWMSLayerName() {
        return this.lastWMSLayerName;
    }

    public void setLastWMSLayerName(String lastWMSLayerName) {
        this.lastWMSLayerName = lastWMSLayerName;
    }
}

