/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.globalsat;

import gnu.io.CommPortIdentifier;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.kaintoch.gps.globalsat.dg100.ByteHelper;
import org.kaintoch.gps.globalsat.dg100.Dg100Config;
import org.kaintoch.gps.globalsat.dg100.FileInfoRec;
import org.kaintoch.gps.globalsat.dg100.GpsRec;
import org.kaintoch.gps.globalsat.dg100.Response;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;

public class GlobalsatDg100 {
    public static final int TIMEOUT = 2000;
    public static final int TRACK_TYPE = 1;
    private static byte[] dg100CmdSwitch2Nmea;
    private static byte[] dg100CmdEnterGMouse;
    private static byte[] dg100CmdDelFile;
    private static byte[] dg100CmdGetFileInfo;
    private static byte[] dg100CmdGetGpsRecs;
    private static byte[] dg100CmdGetConfig;
    private static byte[] dg100CmdSetConfig;
    private static byte[] dg100CmdGetId;
    private static byte[] dg100CmdSetId;
    private byte[] response = new byte[65536];
    private CommPortIdentifier portIdentifier;
    private SerialPort port = null;
    private boolean cancelled = false;

    static {
        byte[] byArray = new byte[32];
        byArray[0] = -96;
        byArray[1] = -94;
        byArray[3] = 24;
        byArray[4] = -127;
        byArray[5] = 2;
        byArray[6] = 1;
        byArray[7] = 1;
        byArray[9] = 1;
        byArray[10] = 1;
        byArray[11] = 1;
        byArray[12] = 5;
        byArray[13] = 1;
        byArray[14] = 1;
        byArray[15] = 1;
        byArray[17] = 1;
        byArray[19] = 1;
        byArray[23] = 1;
        byArray[26] = 37;
        byArray[27] = -128;
        byArray[30] = -80;
        byArray[31] = -77;
        dg100CmdSwitch2Nmea = byArray;
        byte[] byArray2 = new byte[10];
        byArray2[0] = -96;
        byArray2[1] = -94;
        byArray2[3] = 2;
        byArray2[4] = -68;
        byArray2[5] = 1;
        byArray2[7] = -67;
        byArray2[8] = -80;
        byArray2[9] = -77;
        dg100CmdEnterGMouse = byArray2;
        byte[] byArray3 = new byte[11];
        byArray3[0] = -96;
        byArray3[1] = -94;
        byArray3[3] = 3;
        byArray3[4] = -70;
        byArray3[5] = -1;
        byArray3[6] = -1;
        byArray3[7] = 2;
        byArray3[8] = -72;
        byArray3[9] = -80;
        byArray3[10] = -77;
        dg100CmdDelFile = byArray3;
        byte[] byArray4 = new byte[11];
        byArray4[0] = -96;
        byArray4[1] = -94;
        byArray4[3] = 3;
        byArray4[4] = -69;
        byArray4[8] = -69;
        byArray4[9] = -80;
        byArray4[10] = -77;
        dg100CmdGetFileInfo = byArray4;
        byte[] byArray5 = new byte[11];
        byArray5[0] = -96;
        byArray5[1] = -94;
        byArray5[3] = 3;
        byArray5[4] = -75;
        byArray5[6] = 2;
        byArray5[8] = -73;
        byArray5[9] = -80;
        byArray5[10] = -77;
        dg100CmdGetGpsRecs = byArray5;
        byte[] byArray6 = new byte[9];
        byArray6[0] = -96;
        byArray6[1] = -94;
        byArray6[3] = 1;
        byArray6[4] = -73;
        byArray6[6] = -73;
        byArray6[7] = -80;
        byArray6[8] = -77;
        dg100CmdGetConfig = byArray6;
        byte[] byArray7 = new byte[50];
        byArray7[0] = -96;
        byArray7[1] = -94;
        byArray7[3] = 42;
        byArray7[4] = -72;
        byArray7[5] = 2;
        byArray7[18] = 3;
        byArray7[19] = -24;
        byArray7[22] = 3;
        byArray7[23] = -24;
        byArray7[26] = 3;
        byArray7[27] = -24;
        byArray7[45] = 1;
        byArray7[48] = -80;
        byArray7[49] = -77;
        dg100CmdSetConfig = byArray7;
        byte[] byArray8 = new byte[9];
        byArray8[0] = -96;
        byArray8[1] = -94;
        byArray8[3] = 1;
        byArray8[4] = -65;
        byArray8[6] = -65;
        byArray8[7] = -80;
        byArray8[8] = -77;
        dg100CmdGetId = byArray8;
        byte[] byArray9 = new byte[17];
        byArray9[0] = -96;
        byArray9[1] = -94;
        byArray9[3] = 9;
        byArray9[4] = -64;
        byArray9[14] = -64;
        byArray9[15] = -80;
        byArray9[16] = -77;
        dg100CmdSetId = byArray9;
    }

    public GlobalsatDg100(CommPortIdentifier portId) {
        this.portIdentifier = portId;
    }

    public void cancel() {
        this.cancelled = true;
        this.disconnect();
    }

    public GpxData readData(ProgressMonitor progressMonitor) throws ConnectionException {
        progressMonitor.beginTask(null);
        try {
            GpxData result = null;
            this.cancelled = false;
            if (this.port == null) {
                this.connect();
            }
            List<FileInfoRec> fileInfoList = this.readFileInfoList();
            List<GpsRec> gpsRecList = this.readGpsRecList(fileInfoList);
            progressMonitor.setTicksCount(gpsRecList.size());
            if (gpsRecList.size() > 0) {
                GpsRec last = null;
                GpxTrack trk = new GpxTrack();
                ArrayList<WayPoint> seg = new ArrayList<WayPoint>(100);
                result = new GpxData();
                result.tracks.add(trk);
                trk.trackSegs.add(seg);
                for (GpsRec r : gpsRecList) {
                    if (this.cancelled) {
                        GpxData gpxData = result;
                        return gpxData;
                    }
                    WayPoint p = this.wayPointFrom(r);
                    if (r.equals(last)) {
                        result.waypoints.add(p);
                    } else {
                        seg.add(p);
                    }
                    last = r;
                    progressMonitor.worked(1);
                }
            }
            GpxData gpxData = result;
            return gpxData;
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    private WayPoint wayPointFrom(GpsRec r) {
        LatLon l = new LatLon(r.getLatitude(), r.getLongitude());
        WayPoint result = new WayPoint(l);
        result.attr.put("time", r.getStringZuluTime());
        result.attr.put("speed", "" + r.getSpeed());
        if (r.getDg100TypeOfCurRec() > 1) {
            result.attr.put("ele", "" + r.getAltitude());
        }
        return result;
    }

    public void deleteData() throws ConnectionException {
        if (this.port == null) {
            this.connect();
        }
        try {
            Response response = this.sendCmdDelFiles();
        }
        catch (Exception e) {
            throw new ConnectionException(e);
        }
    }

    public void disconnect() {
        if (this.port != null) {
            this.port.close();
            this.port = null;
        }
    }

    private void connect() throws ConnectionException {
        try {
            this.port = (SerialPort)this.portIdentifier.open("DG100", 2000);
            this.port.setSerialPortParams(115200, 8, 2, 0);
            this.port.notifyOnOutputEmpty(false);
        }
        catch (PortInUseException e) {
            throw new ConnectionException(e);
        }
        catch (UnsupportedCommOperationException e) {
            throw new ConnectionException(e);
        }
    }

    private List<FileInfoRec> readFileInfoList() throws ConnectionException {
        int nextIdx = 0;
        ArrayList<FileInfoRec> result = new ArrayList<FileInfoRec>(64);
        try {
            do {
                Response response = this.sendCmdGetFileInfo(nextIdx);
                nextIdx = response.getNextIdx();
                result.addAll(response.getRecs());
            } while (nextIdx > 0);
            return result;
        }
        catch (Exception e) {
            throw new ConnectionException(e);
        }
    }

    public List<GpsRec> readGpsRecList(List<FileInfoRec> fileInfoList) throws ConnectionException {
        int cnt = 0;
        ArrayList<GpsRec> result = new ArrayList<GpsRec>(200);
        try {
            for (FileInfoRec fileInfoRec : fileInfoList) {
                ++cnt;
                Response response = this.sendCmdGetGpsRecs(fileInfoRec.getIdx());
                result.addAll(response.getRecs());
            }
            return result;
        }
        catch (Exception e) {
            throw new ConnectionException(e);
        }
    }

    private Response sendCmdDelFiles() throws IOException, UnsupportedCommOperationException {
        System.out.println("deleting data...");
        int len = this.sendCmd(dg100CmdDelFile, this.response, -1);
        return Response.parseResponse(this.response, len);
    }

    private Response sendCmdGetFileInfo(int idx) throws IOException, UnsupportedCommOperationException {
        byte[] src = dg100CmdGetFileInfo;
        ByteBuffer buf = ByteBuffer.wrap(src);
        buf.position(5);
        buf.putShort((short)idx);
        this.updateCheckSum(buf);
        int len = this.sendCmd(src, this.response, -1);
        return Response.parseResponse(this.response, len);
    }

    private Response sendCmdGetConfig() throws IOException, UnsupportedCommOperationException {
        byte[] src = dg100CmdGetConfig;
        int len = this.sendCmd(src, this.response, -1);
        return Response.parseResponse(this.response, len);
    }

    public Dg100Config getConfig() throws ConnectionException {
        try {
            if (this.port == null) {
                this.connect();
            }
            Response response = this.sendCmdGetConfig();
            return response.getConfig();
        }
        catch (Exception e) {
            throw new ConnectionException(e);
        }
    }

    private void sendCmdSetConfig(Dg100Config config) throws IOException, UnsupportedCommOperationException {
        byte[] src = dg100CmdSetConfig;
        ByteBuffer buf = ByteBuffer.wrap(src);
        if (config != null) {
            config.write(buf);
        }
        this.updateCheckSum(buf);
        int len = this.sendCmd(src, this.response, -1);
        Response.parseResponse(this.response, len);
    }

    public void setConfig(Dg100Config conf) throws ConnectionException {
        try {
            this.sendCmdSetConfig(conf);
        }
        catch (Exception e) {
            throw new ConnectionException(e);
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    private Response sendCmdGetGpsRecs(int idx) throws IOException, UnsupportedCommOperationException {
        byte[] src = dg100CmdGetGpsRecs;
        ByteBuffer buf = ByteBuffer.wrap(src);
        buf.position(5);
        buf.putShort((short)idx);
        this.updateCheckSum(buf);
        int len = this.sendCmd(src, this.response, 2074);
        return Response.parseResponse(this.response, len);
    }

    private void updateCheckSum(ByteBuffer buf) {
        buf.position(2);
        int len = buf.getShort();
        int sum = 0;
        int ii = 0;
        while (ii < len) {
            sum += ByteHelper.byte2IntUnsigned(buf.get());
            ++ii;
        }
        buf.putShort((short)(sum &= Short.MAX_VALUE));
    }

    private int sendCmd(byte[] cmdAndArgs, byte[] response, int bytesToRead) throws IOException, UnsupportedCommOperationException {
        int cntBytTot = 0;
        OutputStream outputStream = null;
        outputStream = this.port.getOutputStream();
        outputStream.write(cmdAndArgs);
        outputStream.flush();
        cntBytTot = this.readResponse(response, bytesToRead);
        return cntBytTot;
    }

    private int readResponse(byte[] response, int bytesToRead) throws IOException, UnsupportedCommOperationException {
        byte[] readBuffer = new byte[200];
        int responsePos = 0;
        boolean headerReceived = false;
        this.port.enableReceiveTimeout(2000);
        int cntBytTot = 0;
        InputStream inputStream = this.port.getInputStream();
        if (inputStream != null) {
            ByteBuffer buf = ByteBuffer.wrap(response);
            this.port.enableReceiveThreshold(2);
            boolean a0A2Received = false;
            while (!a0A2Received) {
                response[0] = response[1];
                int rcvd = inputStream.read(response, 1, 1);
                if (rcvd == 0) {
                    return 0;
                }
                boolean bl = a0A2Received = response[0] == -96 && response[1] == -94;
            }
            responsePos = 2;
            cntBytTot = 2;
            this.port.enableReceiveThreshold(2);
            while (bytesToRead < 0 || bytesToRead >= 0 && cntBytTot < bytesToRead) {
                int cntBytAct = 0;
                cntBytAct = inputStream.read(readBuffer);
                responsePos = ByteHelper.copyByteArr2ByteArr(readBuffer, 0, cntBytAct, response, responsePos);
                if (!headerReceived && (cntBytTot += cntBytAct) >= 4) {
                    if (bytesToRead == -1) {
                        buf.position(2);
                        bytesToRead = buf.getShort() + 4;
                    }
                    this.port.enableReceiveThreshold(1);
                    headerReceived = true;
                }
                if (cntBytAct == 0) break;
            }
            return cntBytTot > bytesToRead ? bytesToRead : cntBytTot;
        }
        return -1;
    }

    public class ConnectionException
    extends Exception {
        ConnectionException(Exception cause) {
            super(cause);
        }

        ConnectionException(String msg) {
            super(msg);
        }
    }
}

