/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.routes;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertedWay {
    private List<Node> nodes = new ArrayList<Node>();
    private BitSet routes;

    public ConvertedWay(BitSet routes, Way way) {
        this.routes = routes;
        this.nodes.addAll(way.nodes);
    }

    public WayEnd getStart() {
        return new WayEnd(this.nodes.get(0));
    }

    public WayEnd getStop() {
        return new WayEnd(this.nodes.get(this.nodes.size() - 1));
    }

    public void connect(ConvertedWay way) {
        for (int i = 0; i < 2; ++i) {
            if (way.nodes.get(0).equals((Object)this.nodes.get(this.nodes.size() - 1))) {
                way.nodes.remove(0);
                this.nodes.addAll(way.nodes);
                return;
            }
            if (way.nodes.get(way.nodes.size() - 1).equals((Object)this.nodes.get(0))) {
                this.nodes.remove(0);
                way.nodes.addAll(this.nodes);
                this.nodes = way.nodes;
                return;
            }
            Collections.reverse(this.nodes);
        }
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public BitSet getRoutes() {
        return this.routes;
    }

    public class WayEnd {
        private Node end;

        public WayEnd(Node end) {
            this.end = end;
        }

        public boolean equals(Object o) {
            if (o instanceof WayEnd) {
                WayEnd otherEnd = (WayEnd)o;
                return this.end.equals((Object)otherEnd.end) && ConvertedWay.this.routes.equals(otherEnd.getRoutes());
            }
            return false;
        }

        public int hashCode() {
            return this.end.hashCode() + ConvertedWay.this.routes.hashCode();
        }

        public BitSet getRoutes() {
            return ConvertedWay.this.routes;
        }

        public ConvertedWay getWay() {
            return ConvertedWay.this;
        }
    }
}

