/*
 * Decompiled with CFR 0.152.
 */
package UtilsPlugin;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.CombineWayAction;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.ReverseWayAction;
import org.openstreetmap.josm.actions.SplitWayAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.TigerUtils;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinAreasAction
extends JosmAction {
    private LinkedList<Command> cmds = new LinkedList();
    private int cmdsCount = 0;

    public JoinAreasAction() {
        super(I18n.tr((String)"Join overlapping Areas"), "joinareas", I18n.tr((String)"Joins areas that overlap each other"), Shortcut.registerShortcut((String)"tools:joinareas", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Join overlapping Areas")}), (int)74, (int)3, (int)1), true);
    }

    public void actionPerformed(ActionEvent e) {
        int result = new ExtendedDialog(Main.parent, I18n.tr((String)"Enter values for all conflicts."), (Component)new JLabel(I18n.tr((String)"THIS IS EXPERIMENTAL. Save your work and verify before uploading.")), new String[]{I18n.tr((String)"Continue anyway"), I18n.tr((String)"Cancel")}, new String[]{"joinareas.png", "cancel.png"}).getValue();
        if (result != 1) {
            return;
        }
        Collection selection = Main.ds.getSelectedWays();
        int ways = 0;
        Way[] selWays = new Way[2];
        LinkedList<Bounds> bounds = new LinkedList<Bounds>();
        OsmDataLayer dataLayer = Main.map.mapView.getEditLayer();
        for (DataSource ds : dataLayer.data.dataSources) {
            if (ds.bounds == null) continue;
            bounds.add(ds.bounds);
        }
        boolean askedAlready = false;
        for (OsmPrimitive prim : selection) {
            Way way = (Way)prim;
            if (ways == 2) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Only up to two areas can be joined at the moment."));
                return;
            }
            if (!way.isClosed()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"\"{0}\" is not closed and therefore can't be joined.", (Object[])new Object[]{way.getName()}));
                return;
            }
            for (Node node : way.nodes) {
                if (askedAlready) break;
                boolean isInsideOneBoundingBox = false;
                for (Bounds b : bounds) {
                    if (!b.contains(node.getCoor())) continue;
                    isInsideOneBoundingBox = true;
                    break;
                }
                if (isInsideOneBoundingBox) continue;
                int option = JOptionPane.showConfirmDialog(Main.parent, I18n.tr((String)"The selected way(s) have nodes outside of the downloaded data region.\nThis can lead to nodes being deleted accidentally.\nAre you really sure to continue?"), I18n.tr((String)"Please abort if you are not sure"), 0, 2);
                if (option != 0) {
                    return;
                }
                askedAlready = true;
                break;
            }
            selWays[ways] = way;
            ++ways;
        }
        if (ways < 1) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please select at least one closed way the should be joined."));
            return;
        }
        if (this.joinAreas(selWays[0], selWays[ways == 2 ? 1 : 0])) {
            Main.map.mapView.repaint();
            DataSet.fireSelectionChanged((Collection)Main.ds.getSelected());
        } else {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"No intersection found. Nothing was changed."));
        }
    }

    private boolean joinAreas(Way a, Way b) {
        ArrayList<OsmPrimitive> nodes;
        boolean same = a.equals((Object)b);
        boolean hadChanges = false;
        if (!same) {
            if (this.checkForTagConflicts(a, b)) {
                return true;
            }
            hadChanges = this.joinAreas(a, a);
            boolean bl = hadChanges = this.joinAreas(b, b) || hadChanges;
        }
        if ((nodes = this.addIntersections(a, b)).size() == 0) {
            return hadChanges;
        }
        this.commitCommands(I18n.marktr((String)"Added node on all intersections"));
        ArrayList<RelationRole> relations = this.removeFromRelations((OsmPrimitive)a);
        if (!same) {
            relations.addAll(this.removeFromRelations((OsmPrimitive)b));
        }
        boolean warnAboutRelations = relations.size() > 0;
        Collection<Way> allWays = this.splitWaysOnNodes(a, b, nodes);
        Collection<Node> allNodes = this.getNodesFromWays(allWays);
        Collection<Way> innerWays = this.findInnerWays(allWays, allNodes);
        Way outerWay = this.joinOuterWays(allWays, innerWays);
        ArrayList<Way> newInnerWays = this.fixMultigons(innerWays, outerWay);
        if (innerWays != null && innerWays.size() > 0) {
            this.cmds.add(DeleteCommand.delete(innerWays, (boolean)true));
        }
        this.commitCommands(I18n.marktr((String)"Delete Ways that are not part of an inner multipolygon"));
        this.addOwnMultigonRelation(newInnerWays, outerWay, relations);
        this.fixRelations(relations, outerWay);
        this.commitCommands(I18n.marktr((String)"Fix relations"));
        this.stripTags(newInnerWays);
        this.makeCommitsOneAction(same ? I18n.marktr((String)"Joined self-overlapping area") : I18n.marktr((String)"Joined overlapping areas"));
        if (warnAboutRelations) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Some of the ways were part of relations that have been modified. Please verify no errors have been introduced."));
        }
        return true;
    }

    private boolean checkForTagConflicts(Way a, Way b) {
        ArrayList<Way> ways = new ArrayList<Way>();
        ways.add(a);
        ways.add(b);
        TreeMap props = new TreeMap();
        for (Way w : ways) {
            for (Map.Entry e : w.entrySet()) {
                if (!props.containsKey(e.getKey())) {
                    props.put(e.getKey(), new TreeSet());
                }
                ((Set)props.get(e.getKey())).add(e.getValue());
            }
        }
        Way ax = new Way(a);
        Way bx = new Way(b);
        HashMap components = new HashMap();
        JPanel p = new JPanel(new GridBagLayout());
        for (Map.Entry e : props.entrySet()) {
            if (TigerUtils.isTigerTag((String)((String)e.getKey()))) {
                String combined = TigerUtils.combineTags((String)((String)e.getKey()), (Set)((Set)e.getValue()));
                ax.put((String)e.getKey(), combined);
                bx.put((String)e.getKey(), combined);
                continue;
            }
            if (((Set)e.getValue()).size() > 1) {
                if ("created_by".equals(e.getKey())) {
                    ax.put("created_by", "JOSM");
                    bx.put("created_by", "JOSM");
                    continue;
                }
                JComboBox<Object> c = new JComboBox<Object>(((Set)e.getValue()).toArray());
                c.setEditable(true);
                p.add((Component)new JLabel((String)e.getKey()), GBC.std());
                p.add(Box.createHorizontalStrut(10), GBC.std());
                p.add(c, GBC.eol());
                components.put(e.getKey(), c);
                continue;
            }
            String val = (String)((Set)e.getValue()).iterator().next();
            ax.put((String)e.getKey(), val);
            bx.put((String)e.getKey(), val);
        }
        if (components.isEmpty()) {
            return false;
        }
        int result = new ExtendedDialog(Main.parent, I18n.tr((String)"Enter values for all conflicts."), (Component)p, new String[]{I18n.tr((String)"Solve Conflicts"), I18n.tr((String)"Cancel")}, new String[]{"dialogs/conflict.png", "cancel.png"}).getValue();
        if (result != 1) {
            return true;
        }
        for (Map.Entry e : components.entrySet()) {
            String val = ((JComboBox)e.getValue()).getEditor().getItem().toString();
            ax.put((String)e.getKey(), val);
            bx.put((String)e.getKey(), val);
        }
        this.cmds.add((Command)new ChangeCommand((OsmPrimitive)a, (OsmPrimitive)ax));
        this.cmds.add((Command)new ChangeCommand((OsmPrimitive)b, (OsmPrimitive)bx));
        this.commitCommands(I18n.marktr((String)"Fix tag conflicts"));
        return false;
    }

    private ArrayList<OsmPrimitive> addIntersections(Way a, Way b) {
        int i;
        boolean same = a.equals((Object)b);
        int nodesSizeA = a.nodes.size();
        int nodesSizeB = b.nodes.size();
        ArrayList<OsmPrimitive> nodes = new ArrayList<OsmPrimitive>();
        ArrayList<NodeToSegs> nodesA = new ArrayList<NodeToSegs>();
        ArrayList<NodeToSegs> nodesB = new ArrayList<NodeToSegs>();
        int n = i = same ? 1 : 0;
        while (i < nodesSizeA - 1) {
            int j;
            int n2 = j = same ? i + 2 : 0;
            while (j < nodesSizeB - 1) {
                if (((Node)a.nodes.get(i)).equals(b.nodes.get(j)) || ((Node)a.nodes.get(i + 1)).equals(b.nodes.get(j))) {
                    nodes.add((OsmPrimitive)b.nodes.get(j));
                } else if (((Node)a.nodes.get(i)).equals(b.nodes.get(j + 1)) || ((Node)a.nodes.get(i + 1)).equals(b.nodes.get(j + 1))) {
                    nodes.add((OsmPrimitive)b.nodes.get(j + 1));
                } else {
                    LatLon intersection = JoinAreasAction.getLineLineIntersection(((Node)a.nodes.get(i)).getEastNorth().east(), ((Node)a.nodes.get(i)).getEastNorth().north(), ((Node)a.nodes.get(i + 1)).getEastNorth().east(), ((Node)a.nodes.get(i + 1)).getEastNorth().north(), ((Node)b.nodes.get(j)).getEastNorth().east(), ((Node)b.nodes.get(j)).getEastNorth().north(), ((Node)b.nodes.get(j + 1)).getEastNorth().east(), ((Node)b.nodes.get(j + 1)).getEastNorth().north());
                    if (intersection != null) {
                        Node n3 = new Node(intersection);
                        this.cmds.add((Command)new AddCommand((OsmPrimitive)n3));
                        nodes.add((OsmPrimitive)n3);
                        nodesA.add(new NodeToSegs(i, n3, ((Node)a.nodes.get(i)).getCoor()));
                        if (same) {
                            nodesA.add(new NodeToSegs(j, n3, ((Node)a.nodes.get(j)).getCoor()));
                        } else {
                            nodesB.add(new NodeToSegs(j, n3, ((Node)b.nodes.get(j)).getCoor()));
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        this.addNodesToWay(a, nodesA);
        if (!same) {
            this.addNodesToWay(b, nodesB);
        }
        return nodes;
    }

    private static LatLon getLineLineIntersection(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        if (!Line2D.linesIntersect(x1, y1, x2, y2, x3, y3, x4, y4)) {
            return null;
        }
        double a1 = y2 - y1;
        double b1 = x1 - x2;
        double c1 = x2 * y1 - x1 * y2;
        double a2 = y4 - y3;
        double b2 = x3 - x4;
        double c2 = x4 * y3 - x3 * y4;
        double det = a1 * b2 - a2 * b1;
        if (det == 0.0) {
            return null;
        }
        return Main.proj.eastNorth2latlon(new EastNorth((b1 * c2 - b2 * c1) / det, (a2 * c1 - a1 * c2) / det));
    }

    private void addNodesToWay(Way a, ArrayList<NodeToSegs> nodes) {
        Way ax = new Way(a);
        Collections.sort(nodes);
        int numOfAdds = 1;
        for (NodeToSegs n : nodes) {
            ax.addNode(n.pos + numOfAdds, n.n);
            ++numOfAdds;
        }
        this.cmds.add((Command)new ChangeCommand((OsmPrimitive)a, (OsmPrimitive)ax));
    }

    private void commitCommands(String description) {
        switch (this.cmds.size()) {
            case 0: {
                return;
            }
            case 1: {
                Main.main.undoRedo.add(this.cmds.getFirst());
                break;
            }
            default: {
                SequenceCommand c = new SequenceCommand(I18n.tr((String)description), this.cmds);
                Main.main.undoRedo.add((Command)c);
            }
        }
        this.cmds.clear();
        ++this.cmdsCount;
    }

    private ArrayList<RelationRole> removeFromRelations(OsmPrimitive osm) {
        ArrayList<RelationRole> result = new ArrayList<RelationRole>();
        block0: for (Relation r : Main.ds.relations) {
            if (r.deleted || r.incomplete) continue;
            for (RelationMember rm : r.members) {
                if (rm.member != osm) continue;
                Relation newRel = new Relation(r);
                newRel.members.remove(rm);
                this.cmds.add((Command)new ChangeCommand((OsmPrimitive)r, (OsmPrimitive)newRel));
                RelationRole saverel = new RelationRole(r, rm.role);
                if (result.contains(saverel)) continue block0;
                result.add(saverel);
                continue block0;
            }
        }
        this.commitCommands(I18n.marktr((String)"Removed Element from Relations"));
        return result;
    }

    private Collection<Way> splitWaysOnNodes(Way a, Way b, Collection<OsmPrimitive> nodes) {
        ArrayList<Way> ways = new ArrayList<Way>();
        ways.add(a);
        if (!a.equals((Object)b)) {
            ways.add(b);
        }
        ArrayList<OsmPrimitive> affected = new ArrayList<OsmPrimitive>();
        for (Way way : ways) {
            nodes.add((OsmPrimitive)way);
            Main.ds.setSelected(nodes);
            nodes.remove(way);
            new SplitWayAction().actionPerformed(null);
            ++this.cmdsCount;
            affected.addAll(Main.ds.getSelectedWays());
        }
        return JoinAreasAction.osmprim2way(affected);
    }

    private static Collection<Way> osmprim2way(Collection<OsmPrimitive> ways) {
        ArrayList<Way> result = new ArrayList<Way>();
        for (OsmPrimitive w : ways) {
            if (!(w instanceof Way)) continue;
            result.add((Way)w);
        }
        return result;
    }

    private Collection<Node> getNodesFromWays(Collection<Way> ways) {
        ArrayList<Node> allNodes = new ArrayList<Node>();
        for (Way w : ways) {
            allNodes.addAll(w.nodes);
        }
        return allNodes;
    }

    private Collection<Way> findInnerWays(Collection<Way> multigonWays, Collection<Node> multigonNodes) {
        ArrayList<Way> innerWays = new ArrayList<Way>();
        for (Way w : multigonWays) {
            Polygon poly = new Polygon();
            for (Node n : w.nodes) {
                poly.addPoint(this.latlonToXY(n.getCoor().lat()), this.latlonToXY(n.getCoor().lon()));
            }
            for (Node n : multigonNodes) {
                if (w.nodes.contains(n) || !poly.contains(this.latlonToXY(n.getCoor().lat()), this.latlonToXY(n.getCoor().lon()))) continue;
                this.getWaysByNode(innerWays, multigonWays, n);
            }
        }
        return innerWays;
    }

    private int latlonToXY(double val) {
        return (int)Math.round(val * 1000000.0);
    }

    private void getWaysByNode(Collection<Way> innerWays, Collection<Way> w, Node n) {
        for (Way way : w) {
            if (!way.nodes.contains(n) || innerWays.contains(way)) continue;
            innerWays.add(way);
        }
    }

    private Way joinOuterWays(Collection<Way> multigonWays, Collection<Way> innerWays) {
        ArrayList<Way> join = new ArrayList<Way>();
        for (Way w : multigonWays) {
            if (innerWays.contains(w)) continue;
            if (w.nodes.size() <= 2) {
                this.cmds.add((Command)new DeleteCommand((OsmPrimitive)w));
                continue;
            }
            join.add(w);
        }
        this.commitCommands(I18n.marktr((String)"Join Areas: Remove Short Ways"));
        return this.closeWay(this.joinWays(join));
    }

    private Way closeWay(Way w) {
        if (w.isClosed()) {
            return w;
        }
        Main.ds.setSelected(new OsmPrimitive[]{w});
        Way wnew = new Way(w);
        wnew.addNode(wnew.firstNode());
        this.cmds.add((Command)new ChangeCommand((OsmPrimitive)w, (OsmPrimitive)wnew));
        this.commitCommands(I18n.marktr((String)"Closed Way"));
        return (Way)Main.ds.getSelectedWays().toArray()[0];
    }

    private Way joinWays(ArrayList<Way> ways) {
        if (ways.size() < 2) {
            return ways.get(0);
        }
        Way a = null;
        for (Way b : ways) {
            if (a == null) {
                a = b;
                continue;
            }
            if (((Node)a.nodes.get(0)).equals(b.nodes.get(0)) || ((Node)a.nodes.get(a.nodes.size() - 1)).equals(b.nodes.get(b.nodes.size() - 1))) {
                Main.ds.setSelected(new OsmPrimitive[]{b});
                new ReverseWayAction().actionPerformed(null);
                ++this.cmdsCount;
            }
            a = b;
        }
        Main.ds.setSelected(ways);
        new CombineWayAction().actionPerformed(null);
        ++this.cmdsCount;
        return (Way)Main.ds.getSelectedWays().toArray()[0];
    }

    private ArrayList<Way> fixMultigons(Collection<Way> uninterestingWays, Way outerWay) {
        Collection<Node> innerNodes = this.getNodesFromWays(uninterestingWays);
        List outerNodes = outerWay.nodes;
        ArrayList<Way> newInnerWays = new ArrayList<Way>();
        ArrayList<Way> possibleWays = new ArrayList<Way>();
        block0: for (Way w : uninterestingWays) {
            boolean hasInnerNodes = false;
            for (Node n : w.nodes) {
                if (outerNodes.contains(n)) continue block0;
                if (hasInnerNodes || !innerNodes.contains(n)) continue;
                hasInnerNodes = true;
            }
            if (!hasInnerNodes || w.nodes.size() < 2) continue;
            possibleWays.add(w);
        }
        this.removeAlmostAlikeWays(possibleWays);
        this.removePartlyUnconnectedWays(possibleWays);
        Way joined = null;
        block2: do {
            joined = null;
            for (Way w1 : possibleWays) {
                if (w1.isClosed()) {
                    if (!this.wayIsCollapsed(w1)) {
                        uninterestingWays.remove(w1);
                        newInnerWays.add(w1);
                    }
                    joined = w1;
                    possibleWays.remove(w1);
                    continue block2;
                }
                for (Way w2 : possibleWays) {
                    if (!this.waysCanBeCombined(w1, w2)) continue;
                    ArrayList<Way> joinThem = new ArrayList<Way>();
                    joinThem.add(w1);
                    joinThem.add(w2);
                    uninterestingWays.removeAll(joinThem);
                    possibleWays.removeAll(joinThem);
                    joined = this.joinWays(joinThem);
                    uninterestingWays.add(joined);
                    possibleWays.add(joined);
                    continue block2;
                }
            }
        } while (joined != null);
        return newInnerWays;
    }

    private void removeAlmostAlikeWays(ArrayList<Way> ways) {
        ArrayList<Way> removables = new ArrayList<Way>();
        block0: for (int i = 0; i < ways.size(); ++i) {
            Way a = ways.get(i);
            for (int j = i + 1; j < ways.size(); ++j) {
                Way b = ways.get(j);
                ArrayList revNodes = new ArrayList(b.nodes);
                Collections.reverse(revNodes);
                if (!((Object)a.nodes).equals(b.nodes) && !((Object)a.nodes).equals(revNodes)) continue;
                removables.add(a);
                continue block0;
            }
        }
        ways.removeAll(removables);
    }

    private void removePartlyUnconnectedWays(ArrayList<Way> ways) {
        ArrayList<Way> removables = new ArrayList<Way>();
        for (Way a : ways) {
            if (a.isClosed()) continue;
            boolean connectedStart = false;
            boolean connectedEnd = false;
            for (Way b : ways) {
                if (a.equals((Object)b)) continue;
                if (b.isFirstLastNode(a.firstNode())) {
                    connectedStart = true;
                }
                if (!b.isFirstLastNode(a.lastNode())) continue;
                connectedEnd = true;
            }
            if (connectedStart && connectedEnd) continue;
            removables.add(a);
        }
        ways.removeAll(removables);
    }

    private boolean wayIsCollapsed(Way w) {
        if (w.nodes.size() <= 3) {
            return true;
        }
        Way x = new Way(w);
        int count = 0;
        for (Node n : w.nodes) {
            x.nodes.remove(n);
            if (x.nodes.contains(n)) {
                ++count;
            }
            if (count != 2) continue;
            return true;
        }
        return false;
    }

    private boolean waysCanBeCombined(Way w1, Way w2) {
        if (w1.equals((Object)w2)) {
            return false;
        }
        if (((Node)w1.nodes.get(0)).equals(w2.nodes.get(0))) {
            return true;
        }
        if (((Node)w1.nodes.get(0)).equals(w2.nodes.get(w2.nodes.size() - 1))) {
            return true;
        }
        if (((Node)w1.nodes.get(w1.nodes.size() - 1)).equals(w2.nodes.get(0))) {
            return true;
        }
        return ((Node)w1.nodes.get(w1.nodes.size() - 1)).equals(w2.nodes.get(w2.nodes.size() - 1));
    }

    private void addOwnMultigonRelation(Collection<Way> inner, Way outer, ArrayList<RelationRole> rels) {
        if (inner.size() == 0) {
            return;
        }
        Relation newRel = new Relation();
        newRel.put("type", "multipolygon");
        for (Way w : inner) {
            newRel.members.add(new RelationMember("inner", (OsmPrimitive)w));
        }
        this.cmds.add((Command)new AddCommand((OsmPrimitive)newRel));
        rels.add(new RelationRole(newRel, "outer"));
    }

    private void fixRelations(ArrayList<RelationRole> rels, Way outer) {
        ArrayList<RelationRole> multiouters = new ArrayList<RelationRole>();
        for (RelationRole r : rels) {
            if (r.rel.get("type") != null && r.rel.get("type").equalsIgnoreCase("multipolygon") && r.role.equalsIgnoreCase("outer")) {
                multiouters.add(r);
                continue;
            }
            Relation newRel = new Relation(r.rel);
            newRel.members.add(new RelationMember(r.role, (OsmPrimitive)outer));
            this.cmds.add((Command)new ChangeCommand((OsmPrimitive)r.rel, (OsmPrimitive)newRel));
        }
        Relation newRel = null;
        switch (multiouters.size()) {
            case 0: {
                return;
            }
            case 1: {
                newRel = new Relation(((RelationRole)multiouters.get((int)0)).rel);
                newRel.members.add(new RelationMember(((RelationRole)multiouters.get((int)0)).role, (OsmPrimitive)outer));
                this.cmds.add((Command)new ChangeCommand((OsmPrimitive)((RelationRole)multiouters.get((int)0)).rel, (OsmPrimitive)newRel));
                return;
            }
        }
        newRel = new Relation();
        for (RelationRole r : multiouters) {
            for (RelationMember rm : r.rel.members) {
                if (newRel.members.contains(rm)) continue;
                newRel.members.add(rm);
            }
            for (String key : r.rel.keys.keySet()) {
                newRel.put(key, (String)r.rel.keys.get(key));
            }
            this.cmds.add((Command)new DeleteCommand((OsmPrimitive)r.rel));
        }
        newRel.members.add(new RelationMember("outer", (OsmPrimitive)outer));
        this.cmds.add((Command)new AddCommand((OsmPrimitive)newRel));
    }

    private void stripTags(Collection<Way> ways) {
        for (Way w : ways) {
            this.stripTags(w);
        }
        this.commitCommands(I18n.marktr((String)"Remove tags from inner ways"));
    }

    private void stripTags(Way x) {
        if (x.keys == null) {
            return;
        }
        Way y = new Way(x);
        for (String key : x.keys.keySet()) {
            y.remove(key);
        }
        this.cmds.add((Command)new ChangeCommand((OsmPrimitive)x, (OsmPrimitive)y));
    }

    private void makeCommitsOneAction(String message) {
        int i;
        UndoRedoHandler ur = Main.main.undoRedo;
        this.cmds.clear();
        for (i = Math.max(ur.commands.size() - this.cmdsCount, 0); i < ur.commands.size(); ++i) {
            this.cmds.add((Command)ur.commands.get(i));
        }
        for (i = 0; i < this.cmds.size(); ++i) {
            ur.undo();
        }
        this.commitCommands(message == null ? I18n.marktr((String)"Join Areas Function") : message);
        this.cmdsCount = 0;
    }

    private class RelationRole {
        public Relation rel;
        public String role;

        public RelationRole(Relation rel, String role) {
            this.rel = rel;
            this.role = role;
        }

        public boolean equals(Object other) {
            if (!(other instanceof RelationRole)) {
                return false;
            }
            RelationRole otherMember = (RelationRole)other;
            return otherMember.role.equals(this.role) && otherMember.rel.equals((Object)this.rel);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NodeToSegs
    implements Comparable<NodeToSegs> {
        public int pos;
        public Node n;
        public double dis;

        public NodeToSegs(int pos, Node n, LatLon dis) {
            this.pos = pos;
            this.n = n;
            this.dis = n.getCoor().greatCircleDistance(dis);
        }

        @Override
        public int compareTo(NodeToSegs o) {
            if (this.pos == o.pos) {
                return this.dis - o.dis > 0.0 ? 1 : -1;
            }
            return this.pos - o.pos;
        }
    }
}

