/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.czechaddress.gui;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.AddressElement;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.Database;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.ElementWithStreets;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.Region;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.Suburb;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.ViToCi;

public class LocationSelector
extends ExtendedDialog {
    protected ElementWithStreets selectedElement;
    protected ArrayList<ItemListener> listeners = new ArrayList();
    private JLabel castObceLabel;
    private JPanel mainPanel;
    private JLabel obecLabel;
    private JComboBox oblastComboBox;
    private JLabel oblastLabel;
    private JComboBox suburbComboBox;
    private JComboBox vitociComboBox;

    public static ElementWithStreets selectLocation() {
        LocationSelector ls = new LocationSelector();
        ls.setVisible(true);
        if (ls.getValue() == 1) {
            return ls.selectedElement;
        }
        return null;
    }

    private LocationSelector() {
        super(Main.parent, "V\u00fdb\u011br um\u00edst\u011bn\u00ed", new String[]{"OK", "Zru\u0161it"}, true);
        this.initComponents();
        this.setupDialog(this.mainPanel, new String[]{"ok.png", "cancel.png"});
        this.oblastComboBox.setRenderer(new AddressElementRenderer());
        this.vitociComboBox.setRenderer(new AddressElementRenderer());
        this.suburbComboBox.setRenderer(new SuburbRenderer());
        this.oblastComboBox.setModel(new DefaultComboBoxModel<Object>(Database.getInstance().regions.toArray()));
        try {
            this.autodetectLocation();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.oblastComboBoxItemStateChanged(null);
    }

    private void autodetectLocation() {
        LatLon center;
        boolean assertions = false;
        if (!$assertionsDisabled) {
            assertions = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        OsmPrimitive bestFit = null;
        double bestLen = 0.0;
        BoundingXYVisitor visitor = new BoundingXYVisitor();
        for (OsmPrimitive op : Main.ds.allPrimitives()) {
            if (op instanceof Node) {
                ((Node)op).visit((Visitor)visitor);
                continue;
            }
            if (!(op instanceof Way)) continue;
            ((Way)op).visit((Visitor)visitor);
        }
        try {
            center = Main.proj.eastNorth2latlon(visitor.getBounds().getCenter());
        }
        catch (Exception e) {
            System.err.println("AUTO: No bounds to determine autolocation.");
            return;
        }
        if (assertions) {
            System.out.println("AUTO: Center is " + center);
        }
        for (OsmPrimitive op : Main.ds.allPrimitives()) {
            if (!(op instanceof Node)) continue;
            Node node = (Node)op;
            double multiplicator = 5.0;
            if (new String("city").equals(op.get("place"))) {
                multiplicator = 2.8;
            } else if (new String("town").equals(op.get("place"))) {
                multiplicator = 2.3;
            } else if (new String("village").equals(op.get("place"))) {
                multiplicator = 2.0;
            } else {
                if (!new String("suburb").equals(op.get("place"))) continue;
                multiplicator = 1.0;
            }
            double currLen = multiplicator * node.getCoor().distance((Point2D)center);
            if (bestFit != null && !(currLen < bestLen)) continue;
            bestFit = op;
            bestLen = currLen;
        }
        if (bestFit != null) {
            if (assertions) {
                System.out.println("AUTO: Best fit " + bestFit.getName() + "\t " + bestFit.get("name"));
            }
            block4: for (Region oblast : Database.getInstance().regions) {
                block5: for (ViToCi obec : oblast.getViToCis()) {
                    if (!bestFit.get("place").equals("suburb")) {
                        if (!obec.getName().toUpperCase().equals(bestFit.get("name").toUpperCase())) continue;
                        this.oblastComboBox.setSelectedItem(oblast);
                        this.vitociComboBox.setSelectedItem(obec);
                        for (Suburb castObce : obec.getSuburbs()) {
                            if (!castObce.getName().toUpperCase().equals(bestFit.get("name").toUpperCase())) continue;
                            this.suburbComboBox.setSelectedItem(castObce);
                            continue block4;
                        }
                        continue block4;
                    }
                    for (Suburb castObce : obec.getSuburbs()) {
                        if (!castObce.getName().toUpperCase().equals(bestFit.get("name").toUpperCase())) continue;
                        this.oblastComboBox.setSelectedItem(oblast);
                        this.vitociComboBox.setSelectedItem(obec);
                        this.suburbComboBox.setSelectedItem(castObce);
                        continue block5;
                    }
                }
            }
        }
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.oblastComboBox = new JComboBox();
        this.suburbComboBox = new JComboBox();
        this.vitociComboBox = new JComboBox();
        this.obecLabel = new JLabel();
        this.castObceLabel = new JLabel();
        this.oblastLabel = new JLabel();
        this.setTitle("V\u00fdb\u011br um\u00edst\u011bn\u00ed");
        this.setModal(true);
        this.setName("locationSelector");
        this.getContentPane().setLayout(new GridLayout(1, 0));
        this.oblastComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                LocationSelector.this.oblastComboBoxItemStateChanged(evt);
            }
        });
        this.suburbComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                LocationSelector.this.suburbComboBoxItemStateChanged(evt);
            }
        });
        this.vitociComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                LocationSelector.this.vitociComboBoxItemStateChanged(evt);
            }
        });
        this.obecLabel.setText("Obec:");
        this.castObceLabel.setText("\u010c\u00e1st obce:");
        this.oblastLabel.setText("ORP:");
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.oblastLabel).addComponent(this.obecLabel).addComponent(this.castObceLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.suburbComboBox, 0, 341, Short.MAX_VALUE).addComponent(this.vitociComboBox, 0, 341, Short.MAX_VALUE).addComponent(this.oblastComboBox, 0, 341, Short.MAX_VALUE))));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.oblastLabel).addComponent(this.oblastComboBox, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.obecLabel).addComponent(this.vitociComboBox, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.castObceLabel).addComponent(this.suburbComboBox, -2, 25, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.getContentPane().add(this.mainPanel);
    }

    private void oblastComboBoxItemStateChanged(ItemEvent evt) {
        Region oblast = (Region)this.oblastComboBox.getSelectedItem();
        if (oblast == null) {
            return;
        }
        this.vitociComboBox.setModel(new DefaultComboBoxModel<Object>(oblast.getViToCis().toArray()));
        this.vitociComboBox.setEnabled(this.vitociComboBox.getModel().getSize() > 1);
        this.vitociComboBoxItemStateChanged(null);
    }

    private void vitociComboBoxItemStateChanged(ItemEvent evt) {
        ViToCi obec = (ViToCi)this.vitociComboBox.getSelectedItem();
        if (obec == null) {
            return;
        }
        if (obec.getSuburbs().size() > 0) {
            Object[] suburbs = new Object[obec.getSuburbs().size() + 1];
            for (int i = 0; i < obec.getSuburbs().size(); ++i) {
                suburbs[i] = obec.getSuburbs().get(i);
            }
            suburbs[obec.getSuburbs().size()] = obec;
            this.suburbComboBox.setModel(new DefaultComboBoxModel<Object>(suburbs));
        } else {
            this.suburbComboBox.setModel(new DefaultComboBoxModel());
        }
        this.suburbComboBox.setEnabled(this.suburbComboBox.getModel().getSize() > 1);
        this.suburbComboBoxItemStateChanged(null);
    }

    private void suburbComboBoxItemStateChanged(ItemEvent evt) {
        if (this.suburbComboBox.getSelectedItem() != null) {
            this.selectedElement = (ElementWithStreets)this.suburbComboBox.getSelectedItem();
        } else if (this.vitociComboBox.getSelectedItem() != null) {
            this.selectedElement = (ElementWithStreets)this.vitociComboBox.getSelectedItem();
        } else if (this.oblastComboBox.getSelectedItem() != null) {
            this.selectedElement = (ElementWithStreets)this.oblastComboBox.getSelectedItem();
        }
    }

    private class SuburbRenderer
    extends AddressElementRenderer {
        private SuburbRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value instanceof ViToCi) {
                this.setFont(this.getFont().deriveFont(1));
                this.setText("v\u0161echny \u010d\u00e1sti obce [experiment\u00e1ln\u00ed]");
            } else {
                this.setFont(this.getFont().deriveFont(0));
            }
            return c;
        }
    }

    private class AddressElementRenderer
    extends DefaultListCellRenderer {
        private AddressElementRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof AddressElement && !(value instanceof Region)) {
                this.setText(((AddressElement)value).getName());
            }
            return c;
        }
    }
}

