/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.czechaddress.gui;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.plugins.czechaddress.CzechAddressPlugin;
import org.openstreetmap.josm.plugins.czechaddress.NotNullList;
import org.openstreetmap.josm.plugins.czechaddress.Preferences;
import org.openstreetmap.josm.plugins.czechaddress.StatusListener;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.AddressElement;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.House;
import org.openstreetmap.josm.plugins.czechaddress.gui.utils.HalfCookedComboBoxModel;
import org.openstreetmap.josm.plugins.czechaddress.gui.utils.UniversalListRenderer;
import org.openstreetmap.josm.plugins.czechaddress.intelligence.Reasoner;
import org.openstreetmap.josm.plugins.czechaddress.proposal.AddKeyValueProposal;
import org.openstreetmap.josm.plugins.czechaddress.proposal.Proposal;
import org.openstreetmap.josm.plugins.czechaddress.proposal.ProposalContainer;

public class PointManipulatorDialog
extends ExtendedDialog
implements StatusListener {
    private Timer updateMatchesTimer = null;
    private Action updateMatchesAction;
    private ProposalContainer proposalContainer;
    private JTextField alternateNumberEdit;
    private JButton changeLocationButton;
    private JLabel jLabel1;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JScrollPane jScrollPane1;
    private JTextField locationEdit;
    private JPanel mainPanel;
    private JComboBox matchesComboBox;
    private JList proposalList;
    private JLabel statusLabel;

    public PointManipulatorDialog(OsmPrimitive primitive) {
        super(Main.parent, "Adresn\u00ed bod", new String[]{"OK", "Zru\u0161it"}, true);
        this.initComponents();
        this.updateMatchesAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                PointManipulatorDialog.this.updateMatches();
            }
        };
        CzechAddressPlugin.addStatusListener(this);
        this.updateLocation();
        this.proposalContainer = new ProposalContainer(primitive);
        this.proposalList.setModel(this.proposalContainer);
        this.proposalList.setCellRenderer(new UniversalListRenderer());
        this.matchesComboBox.setModel(new MatchesComboBoxModel());
        this.matchesComboBox.setRenderer(new UniversalListRenderer());
        if (primitive.get("addr:alternatenumber") != null) {
            this.alternateNumberEdit.setText(primitive.get("addr:alternatenumber"));
            this.updateMatches();
        }
        this.setupDialog(this.mainPanel, new String[]{"ok.png", "cancel.png"});
        this.setDefaultCloseOperation(2);
        this.setAlwaysOnTop(false);
        this.setModal(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buttonAction(ActionEvent evt) {
        super.buttonAction(evt);
        if (this.getValue() == 1) {
            if (this.updateMatchesTimer != null && this.updateMatchesTimer.isRunning()) {
                this.updateMatchesTimer.stop();
                this.updateMatches();
            }
            this.proposalContainer.applyAll();
            Main.ds.setSelected(new OsmPrimitive[]{null});
            Main.ds.setSelected(new OsmPrimitive[]{this.proposalContainer.getTarget()});
            AddressElement elem = (AddressElement)this.matchesComboBox.getSelectedItem();
            if (elem != null) {
                Reasoner r;
                Reasoner reasoner = r = Reasoner.getInstance();
                synchronized (reasoner) {
                    r.openTransaction();
                    r.doOverwrite(this.proposalContainer.getTarget(), elem);
                    r.closeTransaction();
                }
            }
        }
        CzechAddressPlugin.removeStatusListener(this);
    }

    public void updateLocation() {
        this.locationEdit.setText(CzechAddressPlugin.getLocation().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMatches() {
        if (this.proposalContainer.getTarget().deleted) {
            this.setVisible(false);
        }
        OsmPrimitive prim = this.proposalContainer.getTarget();
        Reasoner r = Reasoner.getInstance();
        NotNullList<AddressElement> elems = new NotNullList<AddressElement>();
        Reasoner reasoner = r;
        synchronized (reasoner) {
            Map backup = prim.keys;
            r.openTransaction();
            for (AddressElement elem : r.getCandidates(prim)) {
                r.unOverwrite(prim, elem);
            }
            prim.keys = null;
            prim.put("addr:alternatenumber", this.alternateNumberEdit.getText());
            r.update(prim);
            elems.addAll(r.getCandidates(prim));
            prim.keys = backup;
            r.update(prim);
            r.closeTransaction();
        }
        MatchesComboBoxModel matchesModel = (MatchesComboBoxModel)this.matchesComboBox.getModel();
        matchesModel.setElements(elems);
        if (matchesModel.getSize() > 0) {
            this.matchesComboBox.setSelectedIndex(0);
            return;
        }
        House fakeHouse = new House(this.alternateNumberEdit.getText(), null);
        fakeHouse.setParent(CzechAddressPlugin.getLocation());
        this.proposalContainer.setProposals(fakeHouse.getDiff(this.proposalContainer.getTarget()));
    }

    public void pluginStatusChanged(int message) {
        if (message == 1) {
            this.updateLocation();
            this.mainPanel.setEnabled(false);
        }
    }

    private void initComponents() {
        this.jLabel4 = new JLabel();
        this.mainPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.alternateNumberEdit = new JTextField();
        this.jLabel5 = new JLabel();
        this.locationEdit = new JTextField();
        this.changeLocationButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.proposalList = new JList();
        this.matchesComboBox = new JComboBox();
        this.jLabel6 = new JLabel();
        this.statusLabel = new JLabel();
        this.jLabel4.setText("jLabel4");
        this.getContentPane().setLayout(new GridLayout(1, 0));
        this.jLabel1.setText("\u010c\u00edslo popisn\u00e9:");
        this.alternateNumberEdit.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                PointManipulatorDialog.this.keyReleased(evt);
            }
        });
        this.jLabel5.setText("M\u00edsto:");
        this.locationEdit.setEditable(false);
        this.locationEdit.setFocusable(false);
        this.changeLocationButton.setText("Zm\u011bnit");
        this.changeLocationButton.setFocusable(false);
        this.changeLocationButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PointManipulatorDialog.this.changeLocationButtonActionPerformed(evt);
            }
        });
        this.proposalList.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                PointManipulatorDialog.this.proposalListKeyReleased(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.proposalList);
        this.matchesComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{""}));
        this.matchesComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                PointManipulatorDialog.this.matchChanged(evt);
            }
        });
        this.jLabel6.setText("Zaznam v databazi:");
        this.statusLabel.setText(" ");
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6).addComponent(this.jLabel1).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup().addComponent(this.locationEdit, -1, 228, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.changeLocationButton)).addComponent(this.alternateNumberEdit, -1, 293, Short.MAX_VALUE).addComponent(this.matchesComboBox, 0, 293, Short.MAX_VALUE))).addComponent(this.statusLabel, -1, 433, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 433, Short.MAX_VALUE));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.locationEdit, -2, -1, -2).addComponent(this.jLabel5).addComponent(this.changeLocationButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.alternateNumberEdit, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.matchesComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 161, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusLabel)));
        this.getContentPane().add(this.mainPanel);
    }

    private void changeLocationButtonActionPerformed(ActionEvent evt) {
        CzechAddressPlugin.changeLocation();
    }

    private void keyReleased(KeyEvent evt) {
        if (this.updateMatchesTimer != null) {
            this.updateMatchesTimer.stop();
        }
        this.updateMatchesTimer = new Timer(300, this.updateMatchesAction);
        this.updateMatchesTimer.setRepeats(false);
        this.updateMatchesTimer.start();
    }

    private void proposalListKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            for (Object o : this.proposalList.getSelectedValues()) {
                this.proposalContainer.removeProposal((Proposal)o);
            }
        }
    }

    private void matchChanged(ItemEvent evt) {
        if (this.matchesComboBox.getSelectedItem() == null) {
            return;
        }
        AddressElement selectedElement = (AddressElement)this.matchesComboBox.getSelectedItem();
        this.proposalContainer.setProposals(selectedElement.getDiff(this.proposalContainer.getTarget()));
        Preferences p = Preferences.getInstance();
        if (p.addNewTag && this.proposalContainer.getTarget().keySet().size() == 0) {
            this.proposalContainer.addProposal(new AddKeyValueProposal(p.addNewTagKey, p.addNewTagValue));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MatchesComboBoxModel
    extends HalfCookedComboBoxModel {
        private List<AddressElement> matches = null;
        AddressElement selected = null;

        private MatchesComboBoxModel() {
        }

        public void setElements(List<AddressElement> elements) {
            this.matches = elements;
            this.selected = null;
            this.notifyAllListeners();
        }

        @Override
        public void setSelectedItem(Object anItem) {
            if (this.matches == null) {
                return;
            }
            this.selected = (AddressElement)anItem;
            if (Reasoner.getInstance().translate(this.selected) != PointManipulatorDialog.this.proposalContainer.getTarget()) {
                PointManipulatorDialog.this.statusLabel.setText("Vybran\u00e1 adresa u\u017e v map\u011b existuje. Potvrzen\u00edm vznikne konflikt.");
            } else {
                PointManipulatorDialog.this.statusLabel.setText(" ");
            }
        }

        @Override
        public Object getSelectedItem() {
            return this.selected;
        }

        @Override
        public int getSize() {
            if (this.matches == null) {
                return 0;
            }
            return this.matches.size();
        }

        @Override
        public Object getElementAt(int index) {
            if (this.matches == null) {
                return null;
            }
            if (index >= this.matches.size()) {
                return null;
            }
            return this.matches.get(index);
        }
    }
}

