/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import java.util.ArrayList;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.plugins.validator.util.Bag;
import org.openstreetmap.josm.tools.I18n;

public class WronglyOrderedWays
extends Test {
    protected static int WRONGLY_ORDERED_COAST = 1001;
    protected static int WRONGLY_ORDERED_WATER = 1002;
    protected static int WRONGLY_ORDERED_LAND = 1003;
    Bag<Way, Way> _errorWays;

    public WronglyOrderedWays() {
        super(I18n.tr((String)"Wrongly Ordered Ways."), I18n.tr((String)"This test checks the direction of water, land and coastline ways."));
    }

    public void startTest() {
        this._errorWays = new Bag();
    }

    public void endTest() {
        this._errorWays = null;
    }

    public void visit(Way w) {
        int type;
        String errortype = "";
        if (w.deleted || w.incomplete) {
            return;
        }
        String natural = w.get("natural");
        if (natural == null) {
            return;
        }
        if (natural.equals("coastline")) {
            errortype = I18n.tr((String)"Reversed coastline: land not on left side");
            type = WRONGLY_ORDERED_COAST;
        } else if (natural.equals("water")) {
            errortype = I18n.tr((String)"Reversed water: land not on left side");
            type = WRONGLY_ORDERED_WATER;
        } else if (natural.equals("land")) {
            errortype = I18n.tr((String)"Reversed land: land not on left side");
            type = WRONGLY_ORDERED_LAND;
        } else {
            return;
        }
        if (w.nodes.get(0) == w.nodes.get(w.nodes.size() - 1)) {
            double area2 = 0.0;
            for (int node = 1; node < w.nodes.size(); ++node) {
                area2 += ((Node)w.nodes.get(node - 1)).getCoor().lon() * ((Node)w.nodes.get(node)).getCoor().lat() - ((Node)w.nodes.get(node)).getCoor().lon() * ((Node)w.nodes.get(node - 1)).getCoor().lat();
            }
            if ((natural.equals("coastline") || natural.equals("land")) && area2 < 0.0 || natural.equals("water") && area2 > 0.0) {
                ArrayList<Way> primitives = new ArrayList<Way>();
                primitives.add(w);
                this.errors.add(new TestError((Test)this, Severity.WARNING, errortype, type, primitives));
                this._errorWays.add(w, w);
            }
        }
    }
}

