/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.agpifoj;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.lang.Rational;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.GpsDirectory;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.coor.CachedLatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.agpifoj.AgpifojDialog;
import org.openstreetmap.josm.plugins.agpifoj.AgpifojPlugin;
import org.openstreetmap.josm.plugins.agpifoj.CorrelateGpxWithImages;
import org.openstreetmap.josm.tools.ExifReader;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgpifojLayer
extends Layer {
    List<ImageEntry> data;
    private Icon icon = ImageProvider.get((String)"dialogs/agpifoj-marker");
    private Icon selectedIcon = ImageProvider.get((String)"dialogs/agpifoj-marker-selected");
    private int currentPhoto = -1;
    public boolean hasTimeoffset = false;
    public long timeoffset = 0L;
    private MouseAdapter mouseAdapter = null;

    public static void create(File[] files) {
        Loader loader = new Loader(files);
        Main.worker.execute((Runnable)((Object)loader));
    }

    private AgpifojLayer(List<ImageEntry> data) {
        super(I18n.tr((String)"Geotagged Images"));
        Collections.sort(data);
        this.data = data;
    }

    public Icon getIcon() {
        return ImageProvider.get((String)"dialogs/agpifoj");
    }

    public Object getInfoComponent() {
        return null;
    }

    public Component[] getMenuEntries() {
        JMenuItem correlateItem = new JMenuItem(I18n.tr((String)"Correlate to GPX"), ImageProvider.get((String)"dialogs/gpx2img"));
        correlateItem.addActionListener(new CorrelateGpxWithImages(this));
        return new Component[]{new JMenuItem((Action)new LayerListDialog.ShowHideLayerAction((Layer)this)), new JMenuItem((Action)new LayerListDialog.DeleteLayerAction((Layer)this)), new JMenuItem((Action)new RenameLayerAction(null, (Layer)this)), new JSeparator(), correlateItem};
    }

    public String getToolTipText() {
        int i = 0;
        for (ImageEntry e : this.data) {
            if (e.pos == null) continue;
            ++i;
        }
        return this.data.size() + " " + I18n.trn((String)"image", (String)"images", (long)this.data.size()) + " loaded. " + I18n.tr((String)"{0} were found to be gps tagged.", (Object[])new Object[]{i});
    }

    public boolean isMergable(Layer other) {
        return other instanceof AgpifojLayer;
    }

    public void mergeFrom(Layer from) {
        AgpifojLayer l = (AgpifojLayer)from;
        ImageEntry selected = null;
        if (l.currentPhoto >= 0) {
            selected = l.data.get(l.currentPhoto);
        }
        this.data.addAll(l.data);
        Collections.sort(this.data);
        if (this.data.size() > 1) {
            ImageEntry prev = this.data.get(this.data.size() - 1);
            for (int i = this.data.size() - 2; i >= 0; --i) {
                ImageEntry cur = this.data.get(i);
                if (cur.file.equals(prev.file)) {
                    this.data.remove(i);
                    continue;
                }
                prev = cur;
            }
        }
        if (selected != null) {
            for (int i = 0; i < this.data.size(); ++i) {
                if (this.data.get(i) != selected) continue;
                this.currentPhoto = i;
                AgpifojDialog.showImage(this, this.data.get(i));
                break;
            }
        }
        this.name = l.name;
    }

    public void paint(Graphics g, MapView mv) {
        int iconWidth = this.icon.getIconWidth() / 2;
        int iconHeight = this.icon.getIconHeight() / 2;
        for (ImageEntry e : this.data) {
            if (e.pos == null) continue;
            Point p = mv.getPoint((LatLon)e.pos);
            Rectangle r = new Rectangle(p.x - iconWidth, p.y - iconHeight, this.icon.getIconWidth(), this.icon.getIconHeight());
            this.icon.paintIcon((Component)mv, g, r.x, r.y);
        }
        if (this.currentPhoto >= 0 && this.currentPhoto < this.data.size()) {
            ImageEntry e = this.data.get(this.currentPhoto);
            if (e.pos != null) {
                Point p = mv.getPoint((LatLon)e.pos);
                Rectangle r = new Rectangle(p.x - this.selectedIcon.getIconWidth() / 2, p.y - this.selectedIcon.getIconHeight() / 2, this.selectedIcon.getIconWidth(), this.selectedIcon.getIconHeight());
                this.selectedIcon.paintIcon((Component)mv, g, r.x, r.y);
            }
        }
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
        for (ImageEntry e : this.data) {
            v.visit((LatLon)e.pos);
        }
    }

    private static void extractExif(ImageEntry e) {
        try {
            Metadata metadata = JpegMetadataReader.readMetadata((File)e.file);
            Directory dir = metadata.getDirectory(GpsDirectory.class);
            Rational[] components = dir.getRationalArray(4);
            int deg = components[0].intValue();
            float min = components[1].floatValue();
            float sec = components[2].floatValue();
            double lon = (float)deg + min / 60.0f + sec / 3600.0f;
            if (dir.getString(3).charAt(0) == 'W') {
                lon = -lon;
            }
            components = dir.getRationalArray(2);
            deg = components[0].intValue();
            min = components[1].floatValue();
            sec = components[2].floatValue();
            double lat = (float)deg + min / 60.0f + sec / 3600.0f;
            if (dir.getString(1).charAt(0) == 'S') {
                lat = -lat;
            }
            e.setCoor(new LatLon(lat, lon));
            e.exifCoor = e.pos;
        }
        catch (Exception p) {
            e.pos = null;
        }
    }

    public void showNextPhoto() {
        if (this.data != null && this.data.size() > 0) {
            ++this.currentPhoto;
            if (this.currentPhoto >= this.data.size()) {
                this.currentPhoto = this.data.size() - 1;
            }
            AgpifojDialog.showImage(this, this.data.get(this.currentPhoto));
        } else {
            this.currentPhoto = -1;
        }
        Main.map.repaint();
    }

    public void showPreviousPhoto() {
        if (this.data != null && this.data.size() > 0) {
            --this.currentPhoto;
            if (this.currentPhoto < 0) {
                this.currentPhoto = 0;
            }
            AgpifojDialog.showImage(this, this.data.get(this.currentPhoto));
        } else {
            this.currentPhoto = -1;
        }
        Main.map.repaint();
    }

    public void removeCurrentPhoto() {
        if (this.data != null && this.data.size() > 0 && this.currentPhoto >= 0 && this.currentPhoto < this.data.size()) {
            this.data.remove(this.currentPhoto);
            if (this.currentPhoto >= this.data.size()) {
                this.currentPhoto = this.data.size() - 1;
            }
            if (this.currentPhoto >= 0) {
                AgpifojDialog.showImage(this, this.data.get(this.currentPhoto));
            } else {
                AgpifojDialog.showImage(this, null);
            }
        }
        Main.map.repaint();
    }

    private void hook_up_mouse_events() {
        this.mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getButton() != 1) {
                    return;
                }
                if (AgpifojLayer.this.visible) {
                    Main.map.mapView.repaint();
                }
            }

            public void mouseReleased(MouseEvent ev) {
                if (ev.getButton() != 1) {
                    return;
                }
                if (!AgpifojLayer.this.visible) {
                    return;
                }
                for (int i = AgpifojLayer.this.data.size() - 1; i >= 0; --i) {
                    ImageEntry e = AgpifojLayer.this.data.get(i);
                    if (e.pos == null) continue;
                    Point p = Main.map.mapView.getPoint((LatLon)e.pos);
                    Rectangle r = new Rectangle(p.x - AgpifojLayer.this.icon.getIconWidth() / 2, p.y - AgpifojLayer.this.icon.getIconHeight() / 2, AgpifojLayer.this.icon.getIconWidth(), AgpifojLayer.this.icon.getIconHeight());
                    if (!r.contains(ev.getPoint())) continue;
                    AgpifojLayer.this.currentPhoto = i;
                    AgpifojDialog.showImage(AgpifojLayer.this, e);
                    Main.map.repaint();
                    break;
                }
                Main.map.mapView.repaint();
            }
        };
        Main.map.mapView.addMouseListener((MouseListener)this.mouseAdapter);
        Layer.listeners.add(new Layer.LayerChangeListener(){

            public void activeLayerChange(Layer oldLayer, Layer newLayer) {
                if (newLayer == AgpifojLayer.this && AgpifojLayer.this.currentPhoto >= 0) {
                    Main.map.repaint();
                    AgpifojDialog.showImage(AgpifojLayer.this, AgpifojLayer.this.data.get(AgpifojLayer.this.currentPhoto));
                }
            }

            public void layerAdded(Layer newLayer) {
            }

            public void layerRemoved(Layer oldLayer) {
                if (oldLayer == AgpifojLayer.this) {
                    Main.map.mapView.removeMouseListener((MouseListener)AgpifojLayer.this.mouseAdapter);
                    AgpifojLayer.this.currentPhoto = -1;
                    AgpifojLayer.this.data.clear();
                    AgpifojLayer.this.data = null;
                }
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Loader
    extends PleaseWaitRunnable {
        private boolean cancelled = false;
        private AgpifojLayer layer;
        private final File[] selection;
        private HashSet<String> loadedDirectories = new HashSet();

        public Loader(File[] selection) {
            super(I18n.tr((String)"Extracting GPS locations from EXIF"));
            this.selection = selection;
        }

        protected void realRun() throws IOException {
            Main.pleaseWaitDlg.currentAction.setText(I18n.tr((String)"Starting directory scan"));
            ArrayList<File> files = new ArrayList<File>();
            try {
                this.addRecursiveFiles(files, this.selection);
            }
            catch (NullPointerException npe) {
                this.errorMessage = this.errorMessage + I18n.tr((String)"One of the selected files was null !!!");
            }
            if (this.cancelled) {
                return;
            }
            Main.pleaseWaitDlg.currentAction.setText(I18n.tr((String)"Read photos..."));
            ArrayList<ImageEntry> data = new ArrayList<ImageEntry>(files.size());
            int progress = 0;
            Main.pleaseWaitDlg.progress.setMaximum(files.size());
            Main.pleaseWaitDlg.progress.setValue(progress);
            for (File f : files) {
                if (this.cancelled) break;
                Main.pleaseWaitDlg.currentAction.setText(I18n.tr((String)"Reading {0}...", (Object[])new Object[]{f.getName()}));
                Main.pleaseWaitDlg.progress.setValue(progress++);
                ImageEntry e = new ImageEntry();
                try {
                    e.time = ExifReader.readTime((File)f);
                }
                catch (ParseException e1) {
                    e.time = null;
                }
                e.file = f;
                AgpifojLayer.extractExif(e);
                data.add(e);
            }
            this.layer = new AgpifojLayer(data);
            files.clear();
        }

        private void addRecursiveFiles(List<File> files, File[] sel) {
            boolean nullFile = false;
            for (File f : sel) {
                if (this.cancelled) break;
                if (f == null) {
                    nullFile = true;
                    continue;
                }
                if (f.isDirectory()) {
                    String canonical = null;
                    try {
                        canonical = f.getCanonicalPath();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        this.errorMessage = this.errorMessage + I18n.tr((String)"Unable to get canonical path for directory {0}\n", (Object[])new Object[]{f.getAbsolutePath()});
                    }
                    if (canonical == null || this.loadedDirectories.contains(canonical)) continue;
                    this.loadedDirectories.add(canonical);
                    File[] children = f.listFiles(AgpifojPlugin.JPEG_FILE_FILTER);
                    if (children != null) {
                        Main.pleaseWaitDlg.currentAction.setText(I18n.tr((String)"Scanning directory {0}", (Object[])new Object[]{f.getPath()}));
                        try {
                            this.addRecursiveFiles(files, children);
                        }
                        catch (NullPointerException npe) {
                            npe.printStackTrace();
                            this.errorMessage = this.errorMessage + I18n.tr((String)"Found null file in directory {0}\n", (Object[])new Object[]{f.getPath()});
                        }
                        continue;
                    }
                    this.errorMessage = this.errorMessage + I18n.tr((String)"Error while getting files from directory {0}\n", (Object[])new Object[]{f.getPath()});
                    continue;
                }
                files.add(f);
            }
            if (nullFile) {
                throw new NullPointerException();
            }
        }

        protected void finish() {
            if (this.layer != null) {
                Main.main.addLayer((Layer)this.layer);
                this.layer.hook_up_mouse_events();
                if (!this.cancelled && this.layer.data.size() > 0) {
                    boolean noGeotagFound = true;
                    for (ImageEntry e : this.layer.data) {
                        if (e.pos == null) continue;
                        noGeotagFound = false;
                    }
                    if (noGeotagFound) {
                        new CorrelateGpxWithImages(this.layer).actionPerformed(null);
                    }
                }
            }
        }

        protected void cancel() {
            this.cancelled = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ImageEntry
    implements Comparable<ImageEntry> {
        File file;
        Date time;
        LatLon exifCoor;
        CachedLatLon pos;
        Double speed;
        Double elevation;

        ImageEntry() {
        }

        public void setCoor(LatLon latlon) {
            this.pos = new CachedLatLon(latlon);
        }

        @Override
        public int compareTo(ImageEntry image) {
            if (this.time != null && image.time != null) {
                return this.time.compareTo(image.time);
            }
            if (this.time == null && image.time == null) {
                return 0;
            }
            if (this.time == null) {
                return -1;
            }
            return 1;
        }
    }
}

