/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graphs;
import org.jgrapht.alg.NeighborIndex;
import org.jgrapht.event.GraphEdgeChangeEvent;
import org.jgrapht.event.GraphListener;
import org.jgrapht.event.GraphVertexChangeEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectedNeighborIndex<V, E>
implements GraphListener<V, E> {
    Map<V, NeighborIndex.Neighbors<V, E>> predecessorMap = new HashMap<V, NeighborIndex.Neighbors<V, E>>();
    Map<V, NeighborIndex.Neighbors<V, E>> successorMap = new HashMap<V, NeighborIndex.Neighbors<V, E>>();
    private DirectedGraph<V, E> graph;

    public DirectedNeighborIndex(DirectedGraph<V, E> directedGraph) {
        this.graph = directedGraph;
    }

    public Set<V> predecessorsOf(V v) {
        return this.getPredecessors(v).getNeighbors();
    }

    public List<V> predecessorListOf(V v) {
        return this.getPredecessors(v).getNeighborList();
    }

    public Set<V> successorsOf(V v) {
        return this.getSuccessors(v).getNeighbors();
    }

    public List<V> successorListOf(V v) {
        return this.getSuccessors(v).getNeighborList();
    }

    @Override
    public void edgeAdded(GraphEdgeChangeEvent<V, E> graphEdgeChangeEvent) {
        E e = graphEdgeChangeEvent.getEdge();
        Object v = this.graph.getEdgeSource(e);
        Object v2 = this.graph.getEdgeTarget(e);
        this.getSuccessors(v).addNeighbor(v2);
        this.getPredecessors(v2).addNeighbor(v);
    }

    @Override
    public void edgeRemoved(GraphEdgeChangeEvent<V, E> graphEdgeChangeEvent) {
        E e = graphEdgeChangeEvent.getEdge();
        Object v = this.graph.getEdgeSource(e);
        Object v2 = this.graph.getEdgeTarget(e);
        if (this.successorMap.containsKey(v)) {
            this.successorMap.get(v).removeNeighbor(v2);
        }
        if (this.predecessorMap.containsKey(v2)) {
            this.predecessorMap.get(v2).removeNeighbor(v);
        }
    }

    @Override
    public void vertexAdded(GraphVertexChangeEvent<V> graphVertexChangeEvent) {
    }

    @Override
    public void vertexRemoved(GraphVertexChangeEvent<V> graphVertexChangeEvent) {
        this.predecessorMap.remove(graphVertexChangeEvent.getVertex());
        this.successorMap.remove(graphVertexChangeEvent.getVertex());
    }

    private NeighborIndex.Neighbors<V, E> getPredecessors(V v) {
        NeighborIndex.Neighbors<V, E> neighbors = this.predecessorMap.get(v);
        if (neighbors == null) {
            neighbors = new NeighborIndex.Neighbors(v, Graphs.predecessorListOf(this.graph, v));
            this.predecessorMap.put((NeighborIndex.Neighbors<V, E>)v, (NeighborIndex.Neighbors<NeighborIndex.Neighbors<V, E>, E>)neighbors);
        }
        return neighbors;
    }

    private NeighborIndex.Neighbors<V, E> getSuccessors(V v) {
        NeighborIndex.Neighbors<V, E> neighbors = this.successorMap.get(v);
        if (neighbors == null) {
            neighbors = new NeighborIndex.Neighbors(v, Graphs.successorListOf(this.graph, v));
            this.successorMap.put((NeighborIndex.Neighbors<V, E>)v, (NeighborIndex.Neighbors<NeighborIndex.Neighbors<V, E>, E>)neighbors);
        }
        return neighbors;
    }
}

