/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.tools.I18n;

public class UntaggedWay
extends Test {
    protected static final int EMPTY_WAY = 301;
    protected static final int UNTAGGED_WAY = 302;
    protected static final int UNNAMED_WAY = 303;
    protected static final int ONE_NODE_WAY = 304;
    private LinkedList<Way> multipolygonways;
    public static final Set<String> NAMED_WAYS = new HashSet<String>();

    public UntaggedWay() {
        super(I18n.tr((String)"Untagged, empty and one node ways."), I18n.tr((String)"This test checks for untagged, empty and one node ways."));
    }

    public void visit(Way w) {
        String highway;
        if (w.deleted || w.incomplete) {
            return;
        }
        Map tags = w.keys;
        if (tags != null && (highway = (String)tags.get("highway")) != null && NAMED_WAYS.contains(highway) && !tags.containsKey("name") && !tags.containsKey("ref")) {
            String key;
            boolean hasName = false;
            Iterator i$ = w.keySet().iterator();
            while (i$.hasNext() && !(hasName = (key = (String)i$.next()).startsWith("name:") || key.endsWith("_name") || key.endsWith("_ref"))) {
            }
            if (!hasName) {
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"Unnamed ways"), 303, (OsmPrimitive)w));
            }
        }
        if (!w.isTagged() && !this.multipolygonways.contains(w)) {
            this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"Untagged ways"), 302, (OsmPrimitive)w));
        }
        if (w.nodes.size() == 0) {
            this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr((String)"Empty ways"), 301, (OsmPrimitive)w));
        } else if (w.nodes.size() == 1) {
            this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr((String)"One node ways"), 304, (OsmPrimitive)w));
        }
    }

    public void startTest() {
        this.multipolygonways = new LinkedList();
        for (Relation r : Main.ds.relations) {
            if (r.deleted || r.incomplete || r.keys == null || !"multipolygon".equals(r.keys.get("type"))) continue;
            for (RelationMember m : r.members) {
                if (m.member == null || !(m.member instanceof Way) || m.member.deleted || m.member.incomplete || m.member.isTagged()) continue;
                this.multipolygonways.add((Way)m.member);
            }
        }
    }

    public void endTest() {
        this.multipolygonways = null;
    }

    public boolean isFixable(TestError testError) {
        if (testError.getTester() instanceof UntaggedWay) {
            return testError.getCode() == 301 || testError.getCode() == 304;
        }
        return false;
    }

    public Command fixError(TestError testError) {
        return DeleteCommand.delete(testError.getPrimitives());
    }

    static {
        NAMED_WAYS.add("motorway");
        NAMED_WAYS.add("trunk");
        NAMED_WAYS.add("primary");
        NAMED_WAYS.add("secondary");
        NAMED_WAYS.add("tertiary");
        NAMED_WAYS.add("residential");
        NAMED_WAYS.add("pedestrian");
    }
}

