/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.actions.MergeNodesAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.plugins.validator.util.Bag;
import org.openstreetmap.josm.tools.I18n;

public class DuplicateNode
extends Test {
    protected static int DUPLICATE_NODE = 1;
    Bag<LatLon, OsmPrimitive> nodes;

    public DuplicateNode() {
        super(I18n.tr((String)"Duplicated nodes") + ".", I18n.tr((String)"This test checks that there are no nodes at the very same location."));
    }

    public void startTest() {
        this.nodes = new Bag(1000);
    }

    public void endTest() {
        for (List duplicated : this.nodes.values()) {
            if (duplicated.size() <= 1) continue;
            TestError testError = new TestError((Test)this, Severity.ERROR, I18n.tr((String)"Duplicated nodes"), DUPLICATE_NODE, duplicated);
            this.errors.add(testError);
        }
        this.nodes = null;
    }

    public void visit(Node n) {
        if (!n.deleted && !n.incomplete) {
            this.nodes.add(n.getCoor(), (OsmPrimitive)n);
        }
    }

    public Command fixError(TestError testError) {
        List<? extends OsmPrimitive> sel = testError.getPrimitives();
        LinkedList<Node> nodes = new LinkedList<Node>();
        for (OsmPrimitive osmPrimitive : sel) {
            if (!(osmPrimitive instanceof Node)) continue;
            nodes.add((Node)osmPrimitive);
        }
        if (nodes.size() < 2) {
            return null;
        }
        Node target = null;
        for (Node n : nodes) {
            if (n.id <= 0L) continue;
            target = n;
            break;
        }
        if (target == null) {
            target = (Node)nodes.iterator().next();
        }
        MergeNodesAction.mergeNodes(nodes, target);
        return null;
    }

    public boolean isFixable(TestError testError) {
        return testError.getTester() instanceof DuplicateNode;
    }
}

