/*
 * Decompiled with CFR 0.152.
 */
package livegps;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import livegps.LiveGpsData;
import livegps.LiveGpsLock;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.tools.I18n;

public class LiveGpsLayer
extends GpxLayer
implements PropertyChangeListener {
    public static final String LAYER_NAME = I18n.tr((String)"LiveGPS layer");
    public static final String KEY_LIVEGPS_COLOR = "color.livegps.position";
    LatLon lastPos;
    WayPoint lastPoint;
    GpxTrack trackBeingWritten;
    Collection<WayPoint> trackSegment;
    float speed;
    float course;
    String status;
    boolean autocenter;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");

    public LiveGpsLayer(GpxData data) {
        super(data, LAYER_NAME);
        this.trackBeingWritten = new GpxTrack();
        this.trackBeingWritten.attr.put("desc", "josm live gps");
        this.trackSegment = new ArrayList<WayPoint>();
        this.trackBeingWritten.trackSegs.add(this.trackSegment);
        data.tracks.add(this.trackBeingWritten);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCurrentPosition(double lat, double lon) {
        LatLon thisPos = new LatLon(lat, lon);
        if (this.lastPos != null && thisPos.equalsEpsilon(this.lastPos)) {
            return;
        }
        this.lastPos = thisPos;
        this.lastPoint = new WayPoint(thisPos);
        this.lastPoint.attr.put("time", this.dateFormat.format(new Date()));
        Class<LiveGpsLock> clazz = LiveGpsLock.class;
        synchronized (LiveGpsLock.class) {
            this.trackSegment.add(this.lastPoint);
            // ** MonitorExit[var6_4] (shouldn't be in output)
            if (this.autocenter) {
                this.center();
            }
            return;
        }
    }

    public void center() {
        if (this.lastPoint != null) {
            Main.map.mapView.zoomTo(this.lastPoint.getCoor());
        }
    }

    void setSpeed(float metresPerSecond) {
        this.speed = metresPerSecond;
    }

    void setCourse(float degrees) {
        this.course = degrees;
    }

    public void setAutoCenter(boolean ac) {
        this.autocenter = ac;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g, MapView mv) {
        Class<LiveGpsLock> clazz = LiveGpsLock.class;
        synchronized (LiveGpsLock.class) {
            super.paint(g, mv);
            if (this.lastPoint != null) {
                Point screen = mv.getPoint(this.lastPoint.getCoor());
                g.setColor(Main.pref.getColor(KEY_LIVEGPS_COLOR, Color.RED));
                g.drawOval(screen.x - 10, screen.y - 10, 20, 20);
                g.drawOval(screen.x - 9, screen.y - 9, 18, 18);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        LiveGpsData data;
        if (!this.visible) {
            return;
        }
        if ("gpsdata".equals(evt.getPropertyName()) && (data = (LiveGpsData)evt.getNewValue()).isFix()) {
            this.setCurrentPosition(data.getLatitude(), data.getLongitude());
            if (!Float.isNaN(data.getSpeed())) {
                this.setSpeed(data.getSpeed());
            }
            if (!Float.isNaN(data.getCourse())) {
                this.setCourse(data.getCourse());
            }
            Main.map.repaint();
        }
    }
}

