/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.piclayer;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.plugins.piclayer.PicLayerAbstract;
import org.openstreetmap.josm.tools.ImageProvider;

public class RotatePictureAction
extends MapMode
implements MouseListener,
MouseMotionListener {
    private boolean mb_dragging = false;
    private int m_prevY;
    private PicLayerAbstract m_currentLayer = null;

    public RotatePictureAction(MapFrame frame) {
        super("PicLayer", "rotate", "Drag to rotate the picture", frame, ImageProvider.getCursor((String)"crosshair", null));
    }

    public void enterMode() {
        super.enterMode();
        Main.map.mapView.addMouseListener((MouseListener)this);
        Main.map.mapView.addMouseMotionListener((MouseMotionListener)this);
    }

    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener((MouseListener)this);
        Main.map.mapView.removeMouseMotionListener((MouseMotionListener)this);
    }

    public void mousePressed(MouseEvent e) {
        if (Main.map.mapView.getActiveLayer() instanceof PicLayerAbstract) {
            this.m_currentLayer = (PicLayerAbstract)Main.map.mapView.getActiveLayer();
            if (this.m_currentLayer != null && e.getButton() == 1) {
                this.mb_dragging = true;
                this.m_prevY = e.getY();
            }
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.mb_dragging) {
            this.m_currentLayer.rotatePictureBy((double)(e.getY() - this.m_prevY) / 10.0);
            this.m_prevY = e.getY();
            Main.map.mapView.repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.mb_dragging = false;
    }
}

