/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.osb.api;

import java.awt.Point;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.plugins.osb.api.util.HttpUtils;
import org.openstreetmap.josm.tools.I18n;

public class NewAction {
    private final String CHARSET = "UTF-8";

    public Node execute(Point p, String text) throws IOException {
        LatLon latlon = Main.map.mapView.getLatLon(p.x, p.y);
        String uri = Main.pref.get("osb.uri.new");
        String post = "lon=" + latlon.lon() + "&lat=" + latlon.lat() + "&text=" + URLEncoder.encode(text, "UTF-8");
        String result = null;
        result = Main.pref.getBoolean("osb.api.disabled") ? "ok 12345" : HttpUtils.post(uri, null, post, "UTF-8");
        Pattern resultPattern = Pattern.compile("ok\\s+(\\d+)\\s*");
        Matcher m = resultPattern.matcher(result);
        String id = "-1";
        if (!m.matches()) {
            throw new RuntimeException(I18n.tr((String)"Couldn't create new bug. Result: {0}", (Object[])new Object[]{result}));
        }
        id = m.group(1);
        Node osmNode = new Node(latlon);
        osmNode.put("id", id);
        osmNode.put("note", text);
        osmNode.put("openstreetbug", "FIXME");
        osmNode.put("state", "0");
        return osmNode;
    }
}

