/*
 * Decompiled with CFR 0.152.
 */
package org.insignificant.josm.plugins.imagewaypoint;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.filechooser.FileFilter;
import org.insignificant.josm.plugins.imagewaypoint.ImageEntries;
import org.insignificant.josm.plugins.imagewaypoint.ImageWayPointDialog;
import org.insignificant.josm.plugins.imagewaypoint.ImageWayPointLayer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImageWayPointPlugin
extends Plugin {
    public ImageWayPointPlugin() {
        MainMenu menu = Main.main.menu;
        MainMenu.add((JMenu)menu.fileMenu, (JosmAction)new LoadImagesAction(this));
    }

    public final void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (newFrame != null) {
            newFrame.addToggleDialog(ImageWayPointDialog.getInstance().getDisplayComponent());
        } else {
            ImageEntries.getInstance().setCurrentImageEntry(null);
        }
    }

    private void addFiles(List<File> allFiles, File[] selectedFiles) {
        for (int index = 0; index < selectedFiles.length; ++index) {
            File selectedFile = selectedFiles[index];
            if (selectedFile.isDirectory()) {
                this.addFiles(allFiles, selectedFile.listFiles());
                continue;
            }
            if (!selectedFile.getName().toLowerCase().endsWith(".jpg")) continue;
            allFiles.add(selectedFile);
        }
    }

    private static final class LoadImagesAction
    extends JosmAction {
        private static final long serialVersionUID = 4480306223276347301L;
        private final ImageWayPointPlugin plugin;

        public LoadImagesAction(ImageWayPointPlugin plugin) {
            super(I18n.tr((String)"Open images with ImageWayPoint"), "imagewaypoint-open", I18n.tr((String)"Load set of images as a new layer."), null, false);
            this.plugin = plugin;
        }

        public final void actionPerformed(ActionEvent actionEvent) {
            JFileChooser fileChooser = new JFileChooser(Main.pref.get("tagimages.lastdirectory"));
            fileChooser.setFileSelectionMode(2);
            fileChooser.setMultiSelectionEnabled(true);
            fileChooser.setAcceptAllFileFilterUsed(false);
            fileChooser.setFileFilter(new ImageFileFilter());
            fileChooser.showOpenDialog(Main.parent);
            File[] selectedFiles = fileChooser.getSelectedFiles();
            if (null != selectedFiles && 0 != selectedFiles.length) {
                Main.pref.put("tagimages.lastdirectory", fileChooser.getCurrentDirectory().getPath());
                ArrayList allFiles = new ArrayList();
                this.plugin.addFiles(allFiles, selectedFiles);
                ImageEntries.getInstance().add(allFiles.toArray(new File[allFiles.size()]));
                boolean foundImageWayPointLayer = false;
                if (null != Main.map && null != Main.map.mapView) {
                    Collection layerCollection = Main.map.mapView.getAllLayers();
                    Iterator layerIterator = layerCollection.iterator();
                    while (layerIterator.hasNext() && !foundImageWayPointLayer) {
                        if (!(layerIterator.next() instanceof ImageWayPointLayer)) continue;
                        foundImageWayPointLayer = true;
                    }
                }
                if (!foundImageWayPointLayer) {
                    new ImageWayPointLayer();
                }
            }
        }
    }

    private static final class ImageFileFilter
    extends FileFilter {
        private ImageFileFilter() {
        }

        public final boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(".jpg") || file.getName().toLowerCase().endsWith(".jpeg") || file.getName().toLowerCase().endsWith(".png") || file.getName().toLowerCase().endsWith(".gif");
        }

        public final String getDescription() {
            return I18n.tr((String)"Image files (*.jpg, *.jpeg, *.png, *.gif)");
        }
    }
}

