/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.plugins.validator.util.Bag;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;

public class OverlappingWays
extends Test {
    Bag<Pair<Node, Node>, WaySegment> nodePairs;
    protected static int OVERLAPPING_HIGHWAY = 101;
    protected static int OVERLAPPING_RAILWAY = 102;
    protected static int OVERLAPPING_WAY = 103;
    protected static int OVERLAPPING_HIGHWAY_AREA = 111;
    protected static int OVERLAPPING_RAILWAY_AREA = 112;
    protected static int OVERLAPPING_WAY_AREA = 113;
    protected static int OVERLAPPING_AREA = 120;

    public OverlappingWays() {
        super(I18n.tr((String)"Overlapping ways."), I18n.tr((String)"This test checks that a connection between two nodes is not used by more than one way."));
    }

    public void startTest() {
        this.nodePairs = new Bag(1000);
    }

    public void endTest() {
        HashMap ways_seen = new HashMap(500);
        for (List duplicated : this.nodePairs.values()) {
            int ways = duplicated.size();
            if (ways <= 1) continue;
            ArrayList<Way> prims = new ArrayList<Way>();
            ArrayList<Way> current_ways = new ArrayList<Way>();
            int highway = 0;
            int railway = 0;
            int area = 0;
            for (WaySegment ws : duplicated) {
                if (ws.way.get("highway") != null) {
                    ++highway;
                } else if (ws.way.get("railway") != null) {
                    ++railway;
                }
                Boolean ar = OsmUtils.getOsmBoolean((String)ws.way.get("area"));
                if (ar != null && ar.booleanValue()) {
                    ++area;
                }
                if (ws.way.get("landuse") != null || ws.way.get("natural") != null || ws.way.get("amenity") != null || ws.way.get("leisure") != null || ws.way.get("building") != null) {
                    ++area;
                    --ways;
                }
                prims.add(ws.way);
                current_ways.add(ws.way);
            }
            List highlight = (List)ways_seen.get(current_ways);
            if (highlight == null) {
                int type;
                String errortype;
                if (area > 0) {
                    if (ways == 0 || duplicated.size() == area) {
                        errortype = I18n.tr((String)"Overlapping areas");
                        type = OVERLAPPING_AREA;
                    } else if (highway == ways) {
                        errortype = I18n.tr((String)"Overlapping highways (with area)");
                        type = OVERLAPPING_HIGHWAY_AREA;
                    } else if (railway == ways) {
                        errortype = I18n.tr((String)"Overlapping railways (with area)");
                        type = OVERLAPPING_RAILWAY_AREA;
                    } else {
                        errortype = I18n.tr((String)"Overlapping ways (with area)");
                        type = OVERLAPPING_WAY_AREA;
                    }
                } else if (highway == ways) {
                    errortype = I18n.tr((String)"Overlapping highways");
                    type = OVERLAPPING_HIGHWAY;
                } else if (railway == ways) {
                    errortype = I18n.tr((String)"Overlapping railways");
                    type = OVERLAPPING_RAILWAY;
                } else {
                    errortype = I18n.tr((String)"Overlapping ways");
                    type = OVERLAPPING_WAY;
                }
                this.errors.add(new TestError(this, type < OVERLAPPING_HIGHWAY_AREA ? Severity.WARNING : Severity.OTHER, I18n.tr((String)errortype), type, prims, duplicated));
                ways_seen.put(current_ways, duplicated);
                continue;
            }
            for (WaySegment ws : duplicated) {
                highlight.add(ws);
            }
        }
        this.nodePairs = null;
    }

    public void visit(Way w) {
        Node lastN = null;
        int i = -2;
        for (Node n : w.nodes) {
            ++i;
            if (lastN == null) {
                lastN = n;
                continue;
            }
            this.nodePairs.add((Pair<Node, Node>)Pair.sort((Pair)new Pair((Object)lastN, (Object)n)), new WaySegment(w, i));
            lastN = n;
        }
    }
}

