/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.osb.gui.historycombobox;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComboBox;
import org.openstreetmap.josm.plugins.osb.gui.historycombobox.ComboBoxHistory;
import org.openstreetmap.josm.plugins.osb.gui.historycombobox.HistoryChangedListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JHistoryComboBox
extends JComboBox
implements ActionListener {
    protected ComboBoxHistory model;

    public JHistoryComboBox() {
    }

    public JHistoryComboBox(List<String> history) {
        this.model = new ComboBoxHistory(15);
        this.setModel(this.model);
        this.getEditor().addActionListener(this);
        this.setEditable(true);
        this.setHistory(history);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.addCurrentItemToHistory();
    }

    public void addCurrentItemToHistory() {
        String regex = (String)this.getEditor().getItem();
        this.model.addElement(regex);
    }

    public void setText(String text) {
        this.getEditor().setItem(text);
    }

    public String getText() {
        return this.getEditor().getItem().toString();
    }

    public void addHistoryChangedListener(HistoryChangedListener l) {
        this.model.addHistoryChangedListener(l);
    }

    public void removeHistoryChangedListener(HistoryChangedListener l) {
        this.model.removeHistoryChangedListener(l);
    }

    public void setHistory(List<String> history) {
        this.model.setItems(history);
    }

    public List<String> getHistory() {
        return this.model.asList();
    }
}

