/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.geom.Point2D;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.validator.util.Util;
import org.openstreetmap.josm.tools.ImageProvider;

public class GridLayer
extends Layer {
    public GridLayer(String name) {
        super(name);
    }

    public Icon getIcon() {
        return ImageProvider.get((String)"layer", (String)"validator");
    }

    public void paint(Graphics g, MapView mv) {
        Point point;
        long aux;
        if (!Main.pref.hasKey("validator.debug.grid")) {
            return;
        }
        int gridWidth = Integer.parseInt(Main.pref.get("validator.debug.grid"));
        int width = mv.getWidth();
        int height = mv.getHeight();
        EastNorth origin = mv.getEastNorth(0, 0);
        EastNorth border = mv.getEastNorth(width, height);
        if (border.east() * (double)gridWidth > 50.0) {
            return;
        }
        g.setColor(Color.RED.darker().darker());
        HighlightCellVisitor visitor = new HighlightCellVisitor(g, mv, gridWidth);
        for (OsmPrimitive p : Main.ds.getSelected()) {
            p.visit((Visitor)visitor);
        }
        long x0 = (long)Math.floor(origin.east() * (double)gridWidth);
        long x1 = (long)Math.floor(border.east() * (double)gridWidth);
        long y0 = (long)Math.floor(origin.north() * (double)gridWidth) + 1L;
        long y1 = (long)Math.floor(border.north() * (double)gridWidth) + 1L;
        if (x0 > x1) {
            aux = x0;
            x0 = x1;
            x1 = aux;
        }
        if (y0 > y1) {
            aux = y0;
            y0 = y1;
            y1 = aux;
        }
        g.setColor(Color.RED.brighter().brighter());
        for (double x = (double)x0; x <= (double)x1; x += 1.0) {
            point = mv.getPoint(new EastNorth(x / (double)gridWidth, 0.0));
            g.drawLine(point.x, 0, point.x, height);
        }
        for (double y = (double)y0; y <= (double)y1; y += 1.0) {
            point = mv.getPoint(new EastNorth(0.0, y / (double)gridWidth));
            g.drawLine(0, point.y, width, point.y);
        }
    }

    public String getToolTipText() {
        return null;
    }

    public void mergeFrom(Layer from) {
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
    }

    public Object getInfoComponent() {
        return this.getToolTipText();
    }

    public Component[] getMenuEntries() {
        return new Component[]{new JMenuItem((Action)new LayerListDialog.ShowHideLayerAction((Layer)this)), new JMenuItem((Action)new LayerListDialog.DeleteLayerAction((Layer)this)), new JSeparator(), new JMenuItem((Action)new RenameLayerAction(null, (Layer)this)), new JSeparator(), new JMenuItem((Action)new LayerListPopup.InfoAction((Layer)this))};
    }

    public void destroy() {
    }

    class HighlightCellVisitor
    extends AbstractVisitor {
        private final MapView mv;
        private final Graphics g;
        private final int gridDetail;
        private int cellWidth;

        public HighlightCellVisitor(Graphics g, MapView mv, int gridDetail) {
            this.g = g;
            this.mv = mv;
            this.gridDetail = gridDetail;
            Point p = mv.getPoint(new EastNorth(0.0, 0.0));
            Point p2 = mv.getPoint(new EastNorth(1.0 / (double)gridDetail, 1.0 / (double)gridDetail));
            this.cellWidth = Math.abs(p2.x - p.x);
        }

        public void visit(Node n) {
            double x = n.getEastNorth().east() * (double)this.gridDetail;
            double y = n.getEastNorth().north() * (double)this.gridDetail + 1.0;
            this.drawCell(Math.floor(x), Math.floor(y));
        }

        public void visit(Way w) {
            Node lastN = null;
            for (Node n : w.nodes) {
                if (lastN == null) {
                    lastN = n;
                    continue;
                }
                for (Point2D p : Util.getSegmentCells(lastN, n, this.gridDetail)) {
                    this.drawCell(p.getX(), p.getY());
                }
                lastN = n;
            }
        }

        public void visit(Relation r) {
        }

        protected void drawCell(double x, double y) {
            Point p = this.mv.getPoint(new EastNorth(x / (double)this.gridDetail, y / (double)this.gridDetail));
            this.g.fillRect(p.x, p.y, this.cellWidth, this.cellWidth);
        }
    }
}

