/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.MergeNodesAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WayDownloaderPlugin
extends Plugin {
    private Way priorConnectedWay = null;
    private Node selectedNode = null;

    public WayDownloaderPlugin() {
        MainMenu.add((JMenu)Main.main.menu.toolsMenu, (JosmAction)new WayDownloadAction());
    }

    private Node duplicateNode() {
        for (Node onNode : Main.ds.nodes) {
            if (onNode.equals((Object)this.selectedNode) || onNode.coor.lat() != this.selectedNode.coor.lat() || onNode.coor.lon() != this.selectedNode.coor.lon()) continue;
            return onNode;
        }
        return null;
    }

    private Node findOtherEnd(Way way, Node firstEnd) {
        Node otherEnd = (Node)way.nodes.get(0);
        if (otherEnd.equals((Object)firstEnd)) {
            otherEnd = (Node)way.nodes.get(way.nodes.size() - 1);
        }
        return otherEnd;
    }

    private ArrayList<Way> findConnectedWays() {
        ArrayList<Way> connectedWays = new ArrayList<Way>();
        for (Way onWay : Main.ds.ways) {
            Object[] nodes = onWay.nodes.toArray();
            if (nodes.length < 2) {
                System.err.println("WayDownloader plugin encountered a way with " + nodes.length + " nodes :" + onWay.toString());
                continue;
            }
            Node firstNode = (Node)nodes[0];
            Node lastNode = (Node)nodes[nodes.length - 1];
            if (!firstNode.equals((Object)this.selectedNode) && !lastNode.equals((Object)this.selectedNode)) continue;
            connectedWays.add(onWay);
        }
        return connectedWays;
    }

    private boolean workFromWaySelection(Collection<OsmPrimitive> selection) {
        if (selection.size() > 1) {
            return false;
        }
        Way selectedWay = (Way)selection.toArray()[0];
        this.selectedNode = (Node)selectedWay.nodes.get(0);
        if (this.isDownloaded(this.selectedNode)) {
            this.selectedNode = this.findOtherEnd(selectedWay, this.selectedNode);
            if (this.isDownloaded(this.selectedNode)) {
                return false;
            }
        }
        Main.ds.setSelected(new OsmPrimitive[]{this.selectedNode});
        return true;
    }

    private boolean isDownloaded(Node node) {
        for (DataSource datasource : Main.ds.dataSources) {
            Bounds bounds = datasource.bounds;
            if (!(node.coor.lat() > bounds.min.lat()) || !(node.coor.lat() < bounds.max.lat()) || !(node.coor.lon() > bounds.min.lon()) || !(node.coor.lon() < bounds.max.lon())) continue;
            return true;
        }
        return false;
    }

    private class WayDownloadAction
    extends JosmAction
    implements Runnable {
        public WayDownloadAction() {
            super("Way Download", "way-download", "Download map data on the end of selected way", Shortcut.registerShortcut((String)"waydownloader:waydownload", (String)"Way Download", (int)87, (int)2, (int)1), true);
        }

        public void actionPerformed(ActionEvent e) {
            System.out.println("Way Download");
            String errMsg = null;
            WayDownloaderPlugin.this.selectedNode = null;
            Collection selection = Main.ds.getSelectedNodes();
            if (selection.size() == 0) {
                selection = Main.ds.getSelectedWays();
                if (!WayDownloaderPlugin.this.workFromWaySelection(selection)) {
                    errMsg = I18n.tr((String)"Select a starting node on the end of a way");
                }
                selection = Main.ds.getSelectedNodes();
            }
            if (selection.size() == 0 || selection.size() > 1) {
                errMsg = I18n.tr((String)"Select a starting node on the end of a way");
            } else {
                OsmPrimitive p = (OsmPrimitive)selection.iterator().next();
                if (!(p instanceof Node)) {
                    errMsg = I18n.tr((String)"Select a starting node on the end of a way");
                } else {
                    WayDownloaderPlugin.this.selectedNode = (Node)p;
                    Main.map.mapView.zoomTo(((WayDownloaderPlugin)WayDownloaderPlugin.this).selectedNode.eastNorth, Main.map.mapView.getScale());
                    ArrayList connectedWays = WayDownloaderPlugin.this.findConnectedWays();
                    if (connectedWays.size() == 0) {
                        errMsg = I18n.tr((String)"Select a starting node on the end of a way");
                    } else {
                        WayDownloaderPlugin.this.priorConnectedWay = (Way)connectedWays.get(0);
                        double latbuffer = 3.0E-4;
                        double lonbuffer = 5.0E-4;
                        DownloadOsmTask downloadTask = new DownloadOsmTask();
                        downloadTask.download(null, ((WayDownloaderPlugin)WayDownloaderPlugin.this).selectedNode.coor.lat() - latbuffer, ((WayDownloaderPlugin)WayDownloaderPlugin.this).selectedNode.coor.lon() - lonbuffer, ((WayDownloaderPlugin)WayDownloaderPlugin.this).selectedNode.coor.lat() + latbuffer, ((WayDownloaderPlugin)WayDownloaderPlugin.this).selectedNode.coor.lon() + lonbuffer);
                        Main.worker.execute(this);
                    }
                }
            }
            if (errMsg != null) {
                JOptionPane.showMessageDialog(Main.parent, errMsg);
            }
        }

        public void run() {
            ArrayList connectedWays = WayDownloaderPlugin.this.findConnectedWays();
            String errMsg = null;
            if (connectedWays.size() == 0) {
                throw new RuntimeException("Way downloader data inconsistency. priorConnectedWay (" + WayDownloaderPlugin.this.priorConnectedWay.toString() + ") wasn't discovered after download");
            }
            if (connectedWays.size() == 1) {
                Node dupeNode = WayDownloaderPlugin.this.duplicateNode();
                if (dupeNode != null) {
                    if (JOptionPane.showConfirmDialog(null, "Merge duplicate node?") == 0) {
                        LinkedList<Node> dupeNodes = new LinkedList<Node>();
                        dupeNodes.add(dupeNode);
                        MergeNodesAction.mergeNodes(dupeNodes, (Node)WayDownloaderPlugin.this.selectedNode);
                        connectedWays = WayDownloaderPlugin.this.findConnectedWays();
                    }
                } else {
                    errMsg = I18n.tr((String)"Reached the end of the line");
                }
            }
            if (connectedWays.size() > 2) {
                errMsg = I18n.tr((String)"Reached a junction");
            } else if (connectedWays.size() == 2) {
                System.out.println("connectedWays.toString()=" + connectedWays.toString());
                Way wayA = (Way)connectedWays.get(0);
                Way wayB = (Way)connectedWays.get(1);
                Way nextWay = wayA;
                if (WayDownloaderPlugin.this.priorConnectedWay.equals((Object)wayA)) {
                    nextWay = wayB;
                }
                Node nextNode = WayDownloaderPlugin.this.findOtherEnd(nextWay, WayDownloaderPlugin.this.selectedNode);
                Main.ds.setSelected(new OsmPrimitive[]{nextNode});
                Main.map.mapView.zoomTo(nextNode.eastNorth, Main.map.mapView.getScale());
            }
            if (errMsg != null) {
                JOptionPane.showMessageDialog(Main.parent, errMsg);
            }
        }
    }
}

