/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.ValidatorVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestError {
    private Boolean ignored = false;
    private Severity severity;
    private String message;
    private String description;
    private String description_en;
    private List<? extends OsmPrimitive> primitives;
    private List<?> highlighted;
    private Test tester;
    private int code;
    private boolean selected;

    public TestError(Test tester, Severity severity, String message, String description, String description_en, int code, List<? extends OsmPrimitive> primitives, List<?> highlighted) {
        this.tester = tester;
        this.severity = severity;
        this.message = message;
        this.description = description;
        this.description_en = description_en;
        this.primitives = primitives;
        this.highlighted = highlighted;
        this.code = code;
    }

    public TestError(Test tester, Severity severity, String message, int code, List<? extends OsmPrimitive> primitives, List<?> highlighted) {
        this(tester, severity, message, null, null, code, primitives, highlighted);
    }

    public TestError(Test tester, Severity severity, String message, String description, String description_en, int code, List<? extends OsmPrimitive> primitives) {
        this(tester, severity, message, description, description_en, code, primitives, primitives);
    }

    public TestError(Test tester, Severity severity, String message, int code, List<? extends OsmPrimitive> primitives) {
        this(tester, severity, message, null, null, code, primitives, primitives);
    }

    public TestError(Test tester, Severity severity, String message, int code, OsmPrimitive primitive) {
        this(tester, severity, message, null, null, code, Collections.singletonList(primitive), Collections.singletonList(primitive));
    }

    public TestError(Test tester, Severity severity, String message, String description, String description_en, int code, OsmPrimitive primitive) {
        this(tester, severity, message, description, description_en, code, Collections.singletonList(primitive));
    }

    public String getMessage() {
        return this.message;
    }

    public String getDescription() {
        return this.description;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public List<? extends OsmPrimitive> getPrimitives() {
        return this.primitives;
    }

    public void setPrimitives(List<OsmPrimitive> primitives) {
        this.primitives = primitives;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public void setSeverity(Severity severity) {
        this.severity = severity;
    }

    public String getIgnoreState() {
        TreeSet<String> strings = new TreeSet<String>();
        String ignorestring = this.getIgnoreSubGroup();
        for (OsmPrimitive osmPrimitive : this.primitives) {
            if (osmPrimitive.id == 0L) {
                return null;
            }
            String type = "u";
            if (osmPrimitive instanceof Way) {
                type = "w";
            } else if (osmPrimitive instanceof Relation) {
                type = "r";
            } else if (osmPrimitive instanceof Node) {
                type = "n";
            }
            strings.add(type + "_" + osmPrimitive.id);
        }
        for (String string : strings) {
            ignorestring = ignorestring + ":" + string;
        }
        return ignorestring;
    }

    public String getIgnoreSubGroup() {
        String ignorestring = this.getIgnoreGroup();
        if (this.description_en != null) {
            ignorestring = ignorestring + "_" + this.description_en;
        }
        return ignorestring;
    }

    public String getIgnoreGroup() {
        return Integer.toString(this.code);
    }

    public void setIgnored(boolean state) {
        this.ignored = state;
    }

    public Boolean getIgnored() {
        return this.ignored;
    }

    public Test getTester() {
        return this.tester;
    }

    public int getCode() {
        return this.code;
    }

    public boolean isFixable() {
        return this.tester != null && this.tester.isFixable(this);
    }

    public Command getFix() {
        if (this.tester == null) {
            return null;
        }
        return this.tester.fixError(this);
    }

    public void paint(Graphics g, MapView mv) {
        if (!this.ignored.booleanValue()) {
            PaintVisitor v = new PaintVisitor(g, mv);
            this.visitHighlighted(v);
        }
    }

    public void visitHighlighted(ValidatorVisitor v) {
        for (Object o : this.highlighted) {
            if (o instanceof OsmPrimitive) {
                v.visit((OsmPrimitive)o);
                continue;
            }
            if (!(o instanceof WaySegment)) continue;
            v.visit((WaySegment)o);
        }
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    class PaintVisitor
    extends AbstractVisitor
    implements ValidatorVisitor {
        private final Graphics g;
        private final MapView mv;

        public PaintVisitor(Graphics g, MapView mv) {
            this.g = g;
            this.mv = mv;
        }

        public void visit(OsmPrimitive p) {
            if (!p.deleted && !p.incomplete) {
                p.visit((Visitor)this);
            }
        }

        public void drawNode(Node n, Color color) {
            Point p = this.mv.getPoint(n.getEastNorth());
            this.g.setColor(color);
            if (TestError.this.selected) {
                this.g.fillOval(p.x - 5, p.y - 5, 10, 10);
            } else {
                this.g.drawOval(p.x - 5, p.y - 5, 10, 10);
            }
        }

        public void drawSegment(Node n1, Node n2, Color color) {
            Point p1 = this.mv.getPoint(n1.getEastNorth());
            Point p2 = this.mv.getPoint(n2.getEastNorth());
            this.g.setColor(color);
            double t = Math.atan2(p2.x - p1.x, p2.y - p1.y);
            double cosT = Math.cos(t);
            double sinT = Math.sin(t);
            int deg = (int)Math.toDegrees(t);
            if (TestError.this.selected) {
                int[] x = new int[]{(int)((double)p1.x + 5.0 * cosT), (int)((double)p2.x + 5.0 * cosT), (int)((double)p2.x - 5.0 * cosT), (int)((double)p1.x - 5.0 * cosT)};
                int[] y = new int[]{(int)((double)p1.y - 5.0 * sinT), (int)((double)p2.y - 5.0 * sinT), (int)((double)p2.y + 5.0 * sinT), (int)((double)p1.y + 5.0 * sinT)};
                this.g.fillPolygon(x, y, 4);
                this.g.fillArc(p1.x - 5, p1.y - 5, 10, 10, deg, 180);
                this.g.fillArc(p2.x - 5, p2.y - 5, 10, 10, deg, -180);
            } else {
                this.g.drawLine((int)((double)p1.x + 5.0 * cosT), (int)((double)p1.y - 5.0 * sinT), (int)((double)p2.x + 5.0 * cosT), (int)((double)p2.y - 5.0 * sinT));
                this.g.drawLine((int)((double)p1.x - 5.0 * cosT), (int)((double)p1.y + 5.0 * sinT), (int)((double)p2.x - 5.0 * cosT), (int)((double)p2.y + 5.0 * sinT));
                this.g.drawArc(p1.x - 5, p1.y - 5, 10, 10, deg, 180);
                this.g.drawArc(p2.x - 5, p2.y - 5, 10, 10, deg, -180);
            }
        }

        public void visit(Node n) {
            if (this.isNodeVisible(n)) {
                this.drawNode(n, TestError.this.severity.getColor());
            }
        }

        public void visit(Way w) {
            Node lastN = null;
            for (Node n : w.nodes) {
                if (lastN == null) {
                    lastN = n;
                    continue;
                }
                if (this.isSegmentVisible(lastN, n)) {
                    this.drawSegment(lastN, n, TestError.this.severity.getColor());
                }
                lastN = n;
            }
        }

        public void visit(WaySegment ws) {
            Node b;
            if (ws.lowerIndex < 0 || ws.lowerIndex + 1 >= ws.way.nodes.size()) {
                return;
            }
            Node a = (Node)ws.way.nodes.get(ws.lowerIndex);
            if (this.isSegmentVisible(a, b = (Node)ws.way.nodes.get(ws.lowerIndex + 1))) {
                this.drawSegment(a, b, TestError.this.severity.getColor());
            }
        }

        public void visit(Relation r) {
        }

        protected boolean isNodeVisible(Node n) {
            Point p = this.mv.getPoint(n.getEastNorth());
            return p.x >= 0 && p.y >= 0 && p.x <= this.mv.getWidth() && p.y <= this.mv.getHeight();
        }

        protected boolean isSegmentVisible(Node n1, Node n2) {
            Point p1 = this.mv.getPoint(n1.getEastNorth());
            Point p2 = this.mv.getPoint(n2.getEastNorth());
            if (p1.x < 0 && p2.x < 0) {
                return false;
            }
            if (p1.y < 0 && p2.y < 0) {
                return false;
            }
            if (p1.x > this.mv.getWidth() && p2.x > this.mv.getWidth()) {
                return false;
            }
            return p1.y <= this.mv.getHeight() || p2.y <= this.mv.getHeight();
        }
    }
}

