/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator;

import java.awt.Component;
import java.awt.Graphics;
import java.util.Enumeration;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.validator.OSMValidatorPlugin;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.plugins.validator.util.Bag;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ErrorLayer
extends Layer
implements Layer.LayerChangeListener {
    private OSMValidatorPlugin plugin;

    public ErrorLayer(OSMValidatorPlugin plugin) {
        super(I18n.tr((String)"Validation errors"));
        this.plugin = plugin;
        Layer.listeners.add(this);
    }

    public Icon getIcon() {
        return ImageProvider.get((String)"layer", (String)"validator");
    }

    public void paint(Graphics g, MapView mv) {
        DefaultMutableTreeNode root = this.plugin.validationDialog.tree.getRoot();
        if (root == null || root.getChildCount() == 0) {
            return;
        }
        for (DefaultMutableTreeNode severity = (DefaultMutableTreeNode)root.getLastChild(); severity != null; severity = severity.getPreviousSibling()) {
            Enumeration<TreeNode> errorMessages = severity.breadthFirstEnumeration();
            while (errorMessages.hasMoreElements()) {
                Object tn = ((DefaultMutableTreeNode)errorMessages.nextElement()).getUserObject();
                if (!(tn instanceof TestError)) continue;
                ((TestError)tn).paint(g, mv);
            }
        }
    }

    public String getToolTipText() {
        Bag<Severity, TestError> errorTree = new Bag<Severity, TestError>();
        List<TestError> errors = this.plugin.validationDialog.tree.getErrors();
        for (TestError e : errors) {
            errorTree.add(e.getSeverity(), e);
        }
        StringBuilder b = new StringBuilder();
        for (Severity s : Severity.values()) {
            if (!errorTree.containsKey((Object)s)) continue;
            b.append(I18n.tr((String)s.toString())).append(": ").append(errorTree.get(s).size()).append("<br>");
        }
        if (b.length() == 0) {
            return "<html>" + I18n.tr((String)"No validation errors") + "</html>";
        }
        return "<html>" + I18n.tr((String)"Validation errors") + ":<br>" + b + "</html>";
    }

    public void mergeFrom(Layer from) {
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
    }

    public Object getInfoComponent() {
        return this.getToolTipText();
    }

    public Component[] getMenuEntries() {
        return new Component[]{new JMenuItem((Action)new LayerListDialog.ShowHideLayerAction((Layer)this)), new JMenuItem((Action)new LayerListDialog.DeleteLayerAction((Layer)this)), new JSeparator(), new JMenuItem((Action)new RenameLayerAction(null, (Layer)this)), new JSeparator(), new JMenuItem((Action)new LayerListPopup.InfoAction((Layer)this))};
    }

    public void destroy() {
    }

    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
    }

    public void layerAdded(Layer newLayer) {
    }

    public void layerRemoved(Layer oldLayer) {
        if (oldLayer == Main.map.mapView.editLayer) {
            Main.map.mapView.removeLayer((Layer)this);
        } else if (oldLayer == this) {
            OSMValidatorPlugin.errorLayer = null;
        }
    }
}

