/*
 * Decompiled with CFR 0.152.
 */
package wmsplugin;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.PreferenceDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import wmsplugin.WMSInfo;
import wmsplugin.WMSPlugin;

public class WMSPreferenceEditor
implements PreferenceSetting {
    private Map<String, String> orig;
    private DefaultTableModel model;
    private HashMap<Integer, WMSInfo> oldValues = new HashMap();
    JCheckBox overlapCheckBox;
    JSpinner spinLat;
    JSpinner spinLon;

    public void addGui(final PreferenceDialog gui) {
        JPanel p = gui.createPreferenceTab("wms", I18n.tr((String)"WMS Plugin Preferences"), I18n.tr((String)"Modify list of WMS servers displayed in the WMS plugin menu"));
        this.model = new DefaultTableModel(new String[]{I18n.tr((String)"Menu Name"), I18n.tr((String)"WMS URL")}, 0);
        final JTable list = new JTable(this.model);
        JScrollPane scroll = new JScrollPane(list);
        p.add((Component)scroll, GBC.eol().fill(1));
        scroll.setPreferredSize(new Dimension(200, 200));
        for (WMSInfo i : WMSPlugin.wmsList) {
            this.oldValues.put(i.prefid, i);
            this.model.addRow(new String[]{i.name, i.url});
        }
        final DefaultTableModel modeldef = new DefaultTableModel(new String[]{I18n.tr((String)"Menu Name (Default)"), I18n.tr((String)"WMS URL (Default)")}, 0);
        final JTable listdef = new JTable(modeldef){

            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        JScrollPane scrolldef = new JScrollPane(listdef);
        p.add((Component)scrolldef, GBC.eol().insets(0, 5, 0, 0).fill(1));
        scrolldef.setPreferredSize(new Dimension(200, 200));
        for (Map.Entry<String, String> i : WMSPlugin.wmsListDefault.entrySet()) {
            modeldef.addRow(new String[]{i.getKey(), i.getValue()});
        }
        JPanel buttonPanel = new JPanel(new FlowLayout());
        JButton add = new JButton(I18n.tr((String)"Add"));
        buttonPanel.add((Component)add, GBC.std().insets(0, 5, 0, 0));
        add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JPanel p = new JPanel(new GridBagLayout());
                p.add((Component)new JLabel(I18n.tr((String)"Menu Name")), GBC.std().insets(0, 0, 5, 0));
                JTextField key = new JTextField(10);
                JTextField value = new JTextField(10);
                p.add((Component)key, GBC.eop().insets(5, 0, 0, 0).fill(2));
                p.add((Component)new JLabel(I18n.tr((String)"WMS URL")), GBC.std().insets(0, 0, 5, 0));
                p.add((Component)value, GBC.eol().insets(5, 0, 0, 0).fill(2));
                int answer = JOptionPane.showConfirmDialog((Component)gui, p, I18n.tr((String)"Enter a menu name and WMS URL"), 2);
                if (answer == 0) {
                    WMSPreferenceEditor.this.model.addRow(new String[]{key.getText(), value.getText()});
                }
            }
        });
        JButton delete = new JButton(I18n.tr((String)"Delete"));
        buttonPanel.add((Component)delete, GBC.std().insets(0, 5, 0, 0));
        delete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (list.getSelectedRow() == -1) {
                    JOptionPane.showMessageDialog((Component)gui, I18n.tr((String)"Please select the row to delete."));
                } else {
                    Integer i;
                    while ((i = Integer.valueOf(list.getSelectedRow())) != -1) {
                        WMSPreferenceEditor.this.model.removeRow(i);
                    }
                }
            }
        });
        JButton copy = new JButton(I18n.tr((String)"Copy Default"));
        buttonPanel.add((Component)copy, GBC.std().insets(0, 5, 0, 0));
        copy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Integer line = listdef.getSelectedRow();
                if (line == -1) {
                    JOptionPane.showMessageDialog((Component)gui, I18n.tr((String)"Please select the row to copy."));
                } else {
                    WMSPreferenceEditor.this.model.addRow(new String[]{modeldef.getValueAt(line, 0).toString(), modeldef.getValueAt(line, 1).toString()});
                }
            }
        });
        p.add(buttonPanel);
        p.add(Box.createHorizontalGlue(), GBC.eol().fill(2));
        this.overlapCheckBox = new JCheckBox(I18n.tr((String)"Overlap tiles"), WMSPlugin.doOverlap);
        JLabel labelLat = new JLabel(I18n.tr((String)"% of lat:"));
        JLabel labelLon = new JLabel(I18n.tr((String)"% of lon:"));
        this.spinLat = new JSpinner(new SpinnerNumberModel(WMSPlugin.overlapLat, 1, 50, 1));
        this.spinLon = new JSpinner(new SpinnerNumberModel(WMSPlugin.overlapLon, 1, 50, 1));
        JPanel overlapPanel = new JPanel(new FlowLayout());
        overlapPanel.add(this.overlapCheckBox);
        overlapPanel.add(labelLat);
        overlapPanel.add(this.spinLat);
        overlapPanel.add(labelLon);
        overlapPanel.add(this.spinLon);
        p.add(overlapPanel);
    }

    public boolean ok() {
        boolean change = false;
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            String name = this.model.getValueAt(i, 0).toString();
            String url = this.model.getValueAt(i, 1).toString();
            WMSInfo origValue = this.oldValues.get(i);
            if (origValue == null) {
                new WMSInfo(name, url, i).save();
                change = true;
                continue;
            }
            if (!origValue.name.equals(name) || !origValue.url.equals(url)) {
                origValue.name = name;
                origValue.url = url;
                origValue.save();
                change = true;
            }
            this.oldValues.remove(i);
        }
        for (WMSInfo i : this.oldValues.values()) {
            i.url = null;
            i.name = null;
            i.save();
            change = true;
        }
        if (change) {
            WMSPlugin.refreshMenu();
        }
        WMSPlugin.doOverlap = this.overlapCheckBox.getModel().isSelected();
        WMSPlugin.overlapLat = (Integer)this.spinLat.getModel().getValue();
        WMSPlugin.overlapLon = (Integer)this.spinLon.getModel().getValue();
        Main.pref.put("wmsplugin.url.overlap", String.valueOf(WMSPlugin.doOverlap));
        Main.pref.put("wmsplugin.url.overlapLat", String.valueOf(WMSPlugin.overlapLat));
        Main.pref.put("wmsplugin.url.overlapLon", String.valueOf(WMSPlugin.overlapLon));
        return false;
    }

    public void setServerUrl(String server, String url) {
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            if (!server.equals(this.model.getValueAt(i, 0).toString())) continue;
            this.model.setValueAt(url, i, 1);
            return;
        }
        this.model.addRow(new String[]{server, url});
    }

    public String getServerUrl(String server) {
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            if (!server.equals(this.model.getValueAt(i, 0).toString())) continue;
            return this.model.getValueAt(i, 1).toString();
        }
        return null;
    }
}

