/*
 * Decompiled with CFR 0.152.
 */
package wmsplugin;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.projection.Mercator;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.io.CacheFiles;
import org.openstreetmap.josm.io.ProgressInputStream;
import org.openstreetmap.josm.tools.I18n;
import wmsplugin.GeorefImage;
import wmsplugin.Grabber;
import wmsplugin.WMSLayer;

public class WMSGrabber
extends Grabber {
    protected String baseURL;
    private static Boolean shownWarning = false;
    private boolean urlWithPatterns;
    public static final NumberFormat latLonFormat = new DecimalFormat("###0.0000000", new DecimalFormatSymbols(Locale.US));

    WMSGrabber(String baseURL, Bounds b, Projection proj, double pixelPerDegree, GeorefImage image, MapView mv, WMSLayer layer, CacheFiles cache) {
        super(b, proj, pixelPerDegree, image, mv, layer, cache);
        this.baseURL = baseURL;
        this.urlWithPatterns = baseURL != null && baseURL.contains("{1}");
    }

    public void run() {
        this.attempt();
        this.mv.repaint();
    }

    void fetch() throws Exception {
        URL url = null;
        try {
            url = this.getURL(this.b.min.lon(), this.b.min.lat(), this.b.max.lon(), this.b.max.lat(), this.width(), this.height());
            this.image.min = this.proj.latlon2eastNorth(this.b.min);
            this.image.max = this.proj.latlon2eastNorth(this.b.max);
            if (this.image.isVisible((NavigatableComponent)this.mv)) {
                this.image.image = this.grab(url);
                this.image.flushedResizedCachedInstance();
            }
            this.image.downloadingStarted = false;
        }
        catch (Exception e) {
            throw new Exception(e.getMessage() + "\nImage couldn't be fetched: " + (url != null ? url.toString() : ""));
        }
    }

    protected URL getURL(double w, double s, double e, double n, int wi, int ht) throws MalformedURLException {
        String str = this.baseURL;
        String bbox = latLonFormat.format(w) + "," + latLonFormat.format(s) + "," + latLonFormat.format(e) + "," + latLonFormat.format(n);
        if (this.urlWithPatterns) {
            String proj = Main.proj.toCode();
            if (Main.proj instanceof Mercator) {
                proj = "EPSG:4326";
            }
            str = MessageFormat.format(str, proj, bbox, wi, ht);
        } else {
            if (!str.endsWith("?")) {
                str = str + "&";
            }
            str = str + "bbox=" + bbox + WMSGrabber.getProjection(this.baseURL, false) + "&width=" + wi + "&height=" + ht;
        }
        return new URL(str.replace(" ", "%20"));
    }

    public static String getProjection(String baseURL, Boolean warn) {
        String projname = Main.proj.toCode();
        if (Main.proj instanceof Mercator) {
            projname = "EPSG:4326";
        }
        String res = "";
        try {
            Matcher m = Pattern.compile(".*srs=([a-z0-9:]+).*").matcher(baseURL.toLowerCase());
            if (m.matches()) {
                if (!(projname = projname.toLowerCase()).equals(m.group(1)) && warn.booleanValue()) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"The projection ''{0}'' in URL and current projection ''{1}'' mismatch.\nThis may lead to wrong coordinates.", (Object[])new Object[]{m.group(1), projname}));
                }
            } else {
                res = "&srs=" + projname;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return res;
    }

    protected BufferedImage grab(URL url) throws IOException {
        BufferedImage cached = this.cache.getImg(url.toString());
        if (cached != null) {
            return cached;
        }
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(Main.pref.getInteger("wmsplugin.timeout.connect", 30) * 1000);
        conn.setReadTimeout(Main.pref.getInteger("wmsplugin.timeout.read", 30) * 1000);
        String contentType = conn.getHeaderField("Content-Type");
        if (conn.getResponseCode() != 200 || contentType != null && !contentType.startsWith("image")) {
            throw new IOException(this.readException(conn));
        }
        ProgressInputStream is = new ProgressInputStream((URLConnection)conn, null);
        BufferedImage img = ImageIO.read((InputStream)is);
        is.close();
        this.cache.saveImg(url.toString(), img);
        return img;
    }

    protected String readException(URLConnection conn) throws IOException {
        StringBuilder exception = new StringBuilder();
        InputStream in = conn.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        String line = null;
        while ((line = br.readLine()) != null) {
            exception.append(line);
            exception.append('\n');
        }
        return exception.toString();
    }
}

