/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.DirectUpload;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.JMultilineLabel;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.io.GpxWriter;
import org.openstreetmap.josm.tools.Base64;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class UploadDataGui
extends ExtendedDialog {
    private String username = Main.pref.get("osm-server.username");
    private String password = Main.pref.get("osm-server.password");
    private JMultilineLabel OutputDisplay = new JMultilineLabel(" ");
    private JTextField descriptionField = new JTextField(50);
    private JTextField tagsField = new JTextField(50);
    private JCheckBox publicCheckbox = new JCheckBox();
    private static final String API_VERSION = "0.6";
    private static final String BOUNDARY = "----------------------------d10f7aa230e8";
    private static final String LINE_END = "\r\n";
    private static final String uploadTraceText = I18n.tr((String)"Upload Trace");
    private String datename = new SimpleDateFormat("yyMMddHHmmss").format(new Date());
    private String filename = "";
    private boolean cancelled = false;

    public UploadDataGui() {
        super(Main.parent, I18n.tr((String)"Upload Traces"), new String[]{uploadTraceText, I18n.tr((String)"Cancel")}, true);
        JPanel content = this.initComponents();
        this.autoSelectTrace();
        this.setupDialog(content, new String[]{"uploadtrace.png", "cancel.png"});
        ((JButton)this.buttons.get(0)).setEnabled(!this.checkForGPXLayer());
    }

    private JPanel initComponents() {
        this.publicCheckbox.setText(I18n.tr((String)"Public"));
        this.publicCheckbox.setToolTipText(I18n.tr((String)"Selected makes your trace public in openstreetmap.org"));
        JLabel descriptionLabel = new JLabel(I18n.tr((String)"Description"));
        this.descriptionField.setToolTipText(I18n.tr((String)"Please enter Description about your trace."));
        JLabel tagsLabel = new JLabel(I18n.tr((String)"Tags"));
        this.tagsField.setToolTipText(I18n.tr((String)"Please enter tags about your trace."));
        JPanel p = new JPanel(new GridBagLayout());
        this.OutputDisplay.setMaxWidth(this.findMaxDialogSize().width - 10);
        p.add((Component)this.OutputDisplay, GBC.eol());
        p.add((Component)tagsLabel, GBC.eol().insets(0, 10, 0, 0));
        p.add((Component)this.tagsField, GBC.eol().fill(2));
        p.add((Component)descriptionLabel, GBC.eol().insets(0, 10, 0, 0));
        p.add((Component)this.descriptionField, GBC.eol().fill(2));
        p.add((Component)this.publicCheckbox, GBC.eol());
        return p;
    }

    private void autoSelectTrace() {
        if (Main.map != null && Main.map.mapView != null) {
            MapView mv = Main.map.mapView;
            if (!(mv.getActiveLayer() instanceof GpxLayer)) {
                Layer lastLayer = null;
                int layerCount = 0;
                for (Layer l : mv.getAllLayers()) {
                    if (!(l instanceof GpxLayer)) continue;
                    lastLayer = l;
                    ++layerCount;
                }
                if (layerCount == 1) {
                    mv.setActiveLayer(lastLayer);
                }
            }
            if (mv.getActiveLayer() instanceof GpxLayer) {
                GpxData data = ((GpxLayer)Main.map.mapView.getActiveLayer()).data;
                try {
                    this.filename = data.storageFile.getName().replaceAll("[&?/\\\\]", " ").replaceAll("(\\.[^.]*)$", "");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.descriptionField.setText(this.getFilename());
                this.OutputDisplay.setText(I18n.tr((String)"Selected track: {0}", (Object[])new Object[]{this.getFilename()}));
            }
        }
    }

    private void upload(String description, String tags, Boolean isPublic, GpxData gpxData) throws IOException {
        if (this.checkForErrors(this.username, this.password, description, gpxData)) {
            return;
        }
        description = description.replaceAll("[&?/\\\\]", " ");
        tags = tags.replaceAll("[&?/\\\\.,;]", " ");
        Main.pleaseWaitDlg.progress.setValue(0);
        Main.pleaseWaitDlg.setIndeterminate(true);
        Main.pleaseWaitDlg.currentAction.setText(I18n.tr((String)"Connecting..."));
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.writeGpxFile(baos, "file", gpxData);
            this.writeField(baos, "description", description);
            this.writeField(baos, "tags", tags != null && tags.length() > 0 ? tags : "");
            this.writeField(baos, "public", isPublic != false ? "1" : "0");
            this.writeString(baos, "------------------------------d10f7aa230e8--\r\n");
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            HttpURLConnection conn = this.setupConnection(baos.size());
            Main.pleaseWaitDlg.progress.setMaximum(baos.size());
            Main.pleaseWaitDlg.setIndeterminate(false);
            try {
                this.flushToServer(bais, conn.getOutputStream());
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.cancelled) {
                conn.disconnect();
                this.OutputDisplay.setText(I18n.tr((String)"Upload cancelled"));
                ((JButton)this.buttons.get(0)).setEnabled(true);
                this.cancelled = false;
            } else {
                boolean success = this.finishUpConnection(conn);
                ((JButton)this.buttons.get(0)).setEnabled(!success);
                if (success) {
                    ((JButton)this.buttons.get(1)).setText(I18n.tr((String)"Close"));
                }
            }
        }
        catch (Exception e) {
            this.OutputDisplay.setText(I18n.tr((String)"Error while uploading"));
            e.printStackTrace();
        }
    }

    private HttpURLConnection setupConnection(int contentLength) throws Exception {
        CharsetEncoder encoder = Charset.forName("UTF-8").newEncoder();
        String auth = this.username + ":" + this.password;
        ByteBuffer bytes = encoder.encode(CharBuffer.wrap(auth));
        URL url = new URL("http://www.openstreetmap.org/api/0.6/gpx/create");
        HttpURLConnection c = (HttpURLConnection)url.openConnection();
        c.setFixedLengthStreamingMode(contentLength);
        c.setConnectTimeout(15000);
        c.setRequestMethod("POST");
        c.setDoOutput(true);
        c.addRequestProperty("Authorization", "Basic " + Base64.encode((ByteBuffer)bytes));
        c.addRequestProperty("Content-Type", "multipart/form-data; boundary=----------------------------d10f7aa230e8");
        c.addRequestProperty("Connection", "close");
        c.addRequestProperty("Expect", "");
        c.connect();
        return c;
    }

    private boolean finishUpConnection(HttpURLConnection c) throws Exception {
        String returnMsg = c.getResponseMessage();
        boolean success = returnMsg.equals("OK");
        if (c.getResponseCode() != 200 && c.getHeaderField("Error") != null) {
            returnMsg = returnMsg + "\n" + c.getHeaderField("Error");
        }
        this.OutputDisplay.setText(success ? I18n.tr((String)"GPX upload was successful") : I18n.tr((String)"Upload failed. Server returned the following message: ") + returnMsg);
        c.disconnect();
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushToServer(InputStream in, OutputStream out) throws Exception {
        byte[] buffer = new byte[10000];
        int cur = 0;
        InputStream inputStream = in;
        synchronized (inputStream) {
            int nread;
            while ((nread = in.read(buffer, 0, buffer.length)) >= 0) {
                out.write(buffer, 0, nread);
                out.flush();
                Main.pleaseWaitDlg.progress.setValue(cur += nread);
                Main.pleaseWaitDlg.currentAction.setText(this.getProgressText(cur));
                if (!this.cancelled) continue;
            }
        }
        if (!this.cancelled) {
            out.flush();
        }
        Main.pleaseWaitDlg.currentAction.setText("Waiting for server reply...");
        buffer = null;
    }

    private String getProgressText(int cur) {
        int max = Main.pleaseWaitDlg.progress.getMaximum();
        int percent = Math.round(cur * 100 / max);
        return I18n.tr((String)"Uploading GPX track: {0}% ({1} of {2})", (Object[])new Object[]{percent, this.formatBytes(cur), this.formatBytes(max)});
    }

    private String formatBytes(int bytes) {
        return bytes > 1000000 ? new DecimalFormat("0.00").format((double)Math.round(bytes / 10000) / 100.0) + " MB" : (bytes > 1000 ? Math.round(bytes / 1000) + " kB" : bytes + " B");
    }

    private boolean checkForErrors(String username, String password, String description, GpxData gpxData) {
        String errors = "";
        if (description == null || description.length() == 0) {
            errors = errors + I18n.tr((String)"No description provided. Please provide some description.");
        }
        if (gpxData == null) {
            errors = errors + I18n.tr((String)"No GPX layer selected. Cannot upload a trace.");
        }
        if (username == null || username.length() == 0) {
            errors = errors + I18n.tr((String)"No username provided.");
        }
        if (password == null || password.length() == 0) {
            errors = errors + I18n.tr((String)"No password provided.");
        }
        this.OutputDisplay.setText(errors);
        return errors.length() > 0;
    }

    private boolean checkForGPXLayer() {
        if (Main.map == null || Main.map.mapView == null || Main.map.mapView.getActiveLayer() == null || !(Main.map.mapView.getActiveLayer() instanceof GpxLayer)) {
            this.OutputDisplay.setText(I18n.tr((String)"No GPX layer selected. Cannot upload a trace."));
            return true;
        }
        return false;
    }

    private void setupUpload() {
        if (this.checkForGPXLayer()) {
            return;
        }
        ((JButton)this.buttons.get(0)).setEnabled(false);
        PleaseWaitRunnable uploadTask = new PleaseWaitRunnable(I18n.tr((String)"Uploading GPX Track")){

            protected void realRun() throws IOException {
                UploadDataGui.this.upload(UploadDataGui.this.descriptionField.getText(), UploadDataGui.this.tagsField.getText(), UploadDataGui.this.publicCheckbox.isSelected(), ((GpxLayer)Main.map.mapView.getActiveLayer()).data);
            }

            protected void finish() {
            }

            protected void cancel() {
                UploadDataGui.this.cancelled = true;
            }
        };
        Main.worker.execute((Runnable)uploadTask);
    }

    private void writeField(ByteArrayOutputStream baos, String name, String value) throws IOException {
        this.writeBoundary(baos);
        this.writeString(baos, "Content-Disposition: form-data; name=\"" + name + "\"");
        this.writeLineEnd(baos);
        this.writeLineEnd(baos);
        baos.write(value.getBytes("UTF-8"));
        this.writeLineEnd(baos);
    }

    private void writeGpxFile(ByteArrayOutputStream baos, String name, GpxData gpxData) throws IOException {
        this.writeBoundary(baos);
        this.writeString(baos, "Content-Disposition: form-data; name=\"" + name + "\"; ");
        this.writeString(baos, "filename=\"" + this.getFilename() + ".gpx" + "\"");
        this.writeLineEnd(baos);
        this.writeString(baos, "Content-Type: application/octet-stream");
        this.writeLineEnd(baos);
        this.writeLineEnd(baos);
        new GpxWriter((OutputStream)baos).write(gpxData);
        this.writeLineEnd(baos);
    }

    private void writeString(ByteArrayOutputStream baos, String s) {
        try {
            baos.write(s.getBytes());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void writeLineEnd(ByteArrayOutputStream baos) {
        this.writeString(baos, LINE_END);
    }

    private void writeBoundary(ByteArrayOutputStream baos) {
        this.writeString(baos, "------------------------------d10f7aa230e8");
        this.writeLineEnd(baos);
    }

    private String getFilename() {
        return this.filename.equals("") ? this.datename : this.filename;
    }

    protected void buttonAction(ActionEvent evt) {
        String a = evt.getActionCommand();
        if (uploadTraceText.equals(a)) {
            this.setupUpload();
        } else {
            this.setVisible(false);
        }
    }
}

