/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.czechaddress;

import java.text.Normalizer;
import java.util.ArrayList;
import org.openstreetmap.josm.data.coor.LatLon;

public abstract class StringUtils {
    public static String extractNumber(String s) {
        char ch;
        String result = "";
        for (int i = 0; i < s.length() && (ch = s.charAt(i)) >= '0' && ch <= '9'; ++i) {
            result = result + ch;
        }
        return result;
    }

    public static String coordinateToString(double coor) {
        double degrees = Math.floor(coor);
        double minutes = Math.floor(60.0 * (coor - degrees));
        double seconds = 3600.0 * (coor - degrees - minutes / 60.0);
        return String.valueOf(Math.round(degrees)) + "\u00b0" + String.valueOf(Math.round(minutes)) + "'" + String.valueOf((double)Math.round(100.0 * seconds) / 100.0) + "\"";
    }

    public static String latLonToString(LatLon position) {
        if (position == null) {
            return "";
        }
        return "(lat: " + StringUtils.coordinateToString(position.lat()) + " lon: " + StringUtils.coordinateToString(position.lon()) + ")";
    }

    public static boolean matchAbbrev(String s1, String s2) {
        int i;
        s1 = StringUtils.anglicize(s1);
        s2 = StringUtils.anglicize(s2);
        ArrayList<Integer> beg1 = new ArrayList<Integer>(4);
        ArrayList<Integer> beg2 = new ArrayList<Integer>(4);
        int lastChar = 32;
        for (i = 0; i < s1.length(); ++i) {
            if (s1.charAt(i) != ' ' && lastChar == 32) {
                beg1.add(i);
            }
            lastChar = s1.charAt(i);
        }
        lastChar = 32;
        for (i = 0; i < s2.length(); ++i) {
            if (s2.charAt(i) != ' ' && lastChar == 32) {
                beg2.add(i);
            }
            lastChar = s2.charAt(i);
        }
        if (beg1.size() != beg2.size()) {
            return false;
        }
        for (i = 0; i < beg1.size(); ++i) {
            int pos2;
            int pos1 = (Integer)beg1.get(i);
            boolean doContinue = false;
            for (pos2 = ((Integer)beg2.get(i)).intValue(); pos1 < s1.length() && pos2 < s2.length(); ++pos1, ++pos2) {
                if (s1.charAt(pos1) == '.' || s2.charAt(pos2) == '.') {
                    doContinue = true;
                    break;
                }
                if (s1.charAt(pos1) == ' ' && s2.charAt(pos2) == ' ') {
                    doContinue = true;
                    break;
                }
                if (Character.toUpperCase(s1.charAt(pos1)) == Character.toUpperCase(s2.charAt(pos2))) continue;
                return false;
            }
            if (doContinue || !(pos1 >= s1.length() ^ pos2 >= s2.length())) continue;
            return false;
        }
        return true;
    }

    public static String capitalize(String s) {
        char last;
        if (s == null) {
            return null;
        }
        char[] charr = s.toCharArray();
        char ch = last = ' ';
        for (int i = 0; i < charr.length; ++i) {
            ch = charr[i];
            ch = last >= 'a' && last <= '\u017e' || last >= 'A' && last <= '\u017d' ? Character.toLowerCase(ch) : Character.toTitleCase(ch);
            last = charr[i] = ch;
        }
        String[] noCapitalize = new String[]{"Nad", "Pod", "U", "Na", "Z"};
        String result = String.valueOf(charr);
        for (String noc : noCapitalize) {
            result = result.replaceAll(" " + noc + " ", " " + noc.toLowerCase() + " ");
        }
        return result;
    }

    public static String anglicize(String str) {
        String strNFD = Normalizer.normalize(str, Normalizer.Form.NFD);
        StringBuilder sb = new StringBuilder(str.length());
        for (char ch : strNFD.toCharArray()) {
            if (Character.getType(ch) == 6) continue;
            sb.append(ch);
        }
        return sb.toString();
    }
}

