/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.czechaddress;

import java.util.Collection;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.osm.visitor.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MapUtils {
    public static final double NODE_ZOOM_LEVEL = 7.0E-8;

    public static void zoomToMany(Collection<OsmPrimitive> primitives) {
        BoundingXYVisitor visitor = new BoundingXYVisitor();
        for (OsmPrimitive op : primitives) {
            if (op instanceof Node) {
                ((Node)op).visit((Visitor)visitor);
                continue;
            }
            if (!(op instanceof Way)) continue;
            ((Way)op).visit((Visitor)visitor);
        }
        Main.map.mapView.zoomTo(visitor.min.interpolate(visitor.max, 0.5), 7.0E-8);
        Main.ds.setSelected(primitives);
    }

    public static void zoomTo(OsmPrimitive primitive) {
        BoundingXYVisitor visitor = new BoundingXYVisitor();
        if (primitive instanceof Node && ((Node)primitive).eastNorth != null) {
            Main.map.mapView.zoomTo(((Node)primitive).eastNorth, 7.0E-8);
        } else if (primitive instanceof Way) {
            ((Way)primitive).visit((Visitor)visitor);
            Main.map.mapView.zoomTo(visitor.min.interpolate(visitor.max, 0.5), 7.0E-8);
        }
        Main.ds.setSelected(new OsmPrimitive[]{primitive});
    }
}

