/*
 * Decompiled with CFR 0.152.
 */
package wmsplugin;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.io.CacheFiles;
import org.openstreetmap.josm.tools.I18n;
import wmsplugin.GeorefImage;
import wmsplugin.WMSLayer;
import wmsplugin.WMSPlugin;

public abstract class Grabber
implements Runnable {
    protected Bounds b;
    protected Projection proj;
    protected double pixelPerDegree;
    protected MapView mv;
    protected WMSLayer layer;
    protected GeorefImage image;
    protected CacheFiles cache;

    Grabber(Bounds b, Projection proj, double pixelPerDegree, GeorefImage image, MapView mv, WMSLayer layer, CacheFiles cache) {
        if (b.min != null && b.max != null && WMSPlugin.doOverlap) {
            double latCent = (b.min.lat() + b.max.lat()) / 2.0;
            double lonCent = (b.min.lon() + b.max.lon()) / 2.0;
            double latSize = b.max.lat() - b.min.lat();
            double lonSize = b.max.lon() - b.min.lon();
            double latCoef = (100.0 + (double)WMSPlugin.overlapLat) / 100.0 / 2.0;
            double lonCoef = (100.0 + (double)WMSPlugin.overlapLon) / 100.0 / 2.0;
            this.b = new Bounds(new LatLon(latCent - latCoef * latSize, lonCent - lonCoef * lonSize), new LatLon(latCent + latCoef * latSize, lonCent + lonCoef * lonSize));
        } else {
            this.b = b;
        }
        this.proj = proj;
        this.pixelPerDegree = pixelPerDegree;
        this.image = image;
        this.mv = mv;
        this.layer = layer;
        this.cache = cache;
    }

    abstract void fetch() throws Exception;

    int width() {
        return (int)((this.b.max.lon() - this.b.min.lon()) * this.pixelPerDegree);
    }

    int height() {
        return (int)((this.b.max.lat() - this.b.min.lat()) * this.pixelPerDegree);
    }

    protected void grabError(Exception e) {
        e.printStackTrace();
        BufferedImage img = new BufferedImage(this.width(), this.height(), 2);
        Graphics g = img.getGraphics();
        g.setColor(Color.RED);
        g.fillRect(0, 0, this.width(), this.height());
        Font font = g.getFont();
        Font tempFont = font.deriveFont(0).deriveFont(36.0f);
        g.setFont(tempFont);
        g.setColor(Color.BLACK);
        g.drawString(I18n.tr((String)"Exception occurred"), 10, this.height() / 2);
        this.image.image = img;
        this.image.flushedResizedCachedInstance();
        this.image.failed = true;
        g.setFont(font);
    }

    protected void attempt() {
        int maxTries = 5;
        for (int i = 1; i <= maxTries; ++i) {
            try {
                this.fetch();
                break;
            }
            catch (Exception e) {
                try {
                    Thread.sleep(Grabber.random(1000, 2000));
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
                if (i != maxTries) continue;
                this.grabError(e);
                continue;
            }
        }
    }

    public static int random(int min, int max) {
        return (int)(Math.random() * (double)(max + 1 - min)) + min;
    }
}

