/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.editgpx;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.editgpx.EditGpxPlugin;
import org.openstreetmap.josm.plugins.editgpx.GPXLayerImportAction;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class EditGpxLayer
extends Layer {
    private static Icon icon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(EditGpxPlugin.class.getResource("/images/editgpx_layer.png")));
    private DataSet dataSet;
    private GPXLayerImportAction layerImport;

    public EditGpxLayer(String str, DataSet ds) {
        super(str);
        this.dataSet = ds;
        this.layerImport = new GPXLayerImportAction(this.dataSet);
    }

    public void initializeImport() {
        try {
            if (this.dataSet.nodes.isEmpty()) {
                this.layerImport.activateImport();
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public Icon getIcon() {
        return icon;
    }

    public Object getInfoComponent() {
        return this.getToolTipText();
    }

    public Component[] getMenuEntries() {
        return new Component[]{new JMenuItem((Action)new LayerListDialog.ShowHideLayerAction((Layer)this)), new JMenuItem((Action)new LayerListDialog.DeleteLayerAction((Layer)this)), new JSeparator(), new JMenuItem(this.layerImport), new JMenuItem(new ConvertToGpxLayerAction()), new JMenuItem(new ConvertToAnonTimeGpxLayerAction()), new JSeparator(), new JMenuItem((Action)new LayerListPopup.InfoAction((Layer)this))};
    }

    public String getToolTipText() {
        return I18n.tr((String)"Layer for editing GPX tracks");
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void mergeFrom(Layer from) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g, MapView mv) {
        g.setColor(Color.yellow);
        Object object = this.layerImport.importing;
        synchronized (object) {
            for (Node n : this.dataSet.nodes) {
                if (n.deleted) continue;
                LatLon c = n.coor;
                Point pnt = Main.map.mapView.getPoint(Main.proj.latlon2eastNorth(c));
                g.drawOval(pnt.x - 2, pnt.y - 2, 4, 4);
            }
        }
    }

    public void reset() {
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
    }

    private GpxData toGpxData(boolean anonTime) {
        GpxData gpxData = new GpxData();
        HashSet<Node> doneNodes = new HashSet<Node>();
        for (Way w : this.dataSet.ways) {
            if (w.incomplete || w.deleted) continue;
            GpxTrack trk = new GpxTrack();
            gpxData.tracks.add(trk);
            if (w.get("name") != null) {
                trk.attr.put("name", w.get("name"));
            }
            ArrayList<WayPoint> trkseg = null;
            for (Node n : w.nodes) {
                if (n.incomplete || n.deleted) {
                    trkseg = null;
                    continue;
                }
                Date tstamp = n.getTimestamp();
                if (trkseg == null) {
                    trkseg = new ArrayList<WayPoint>();
                    trk.trackSegs.add(trkseg);
                }
                doneNodes.add(n);
                WayPoint wpt = new WayPoint(n.coor);
                if (anonTime) {
                    wpt.attr.put("time", "1970-01-01T00:00:00");
                } else {
                    wpt.attr.put("time", WayPoint.GPXTIMEFMT.format(tstamp));
                }
                wpt.setTime();
                trkseg.add(wpt);
            }
        }
        for (Node n : this.dataSet.nodes) {
            if (n.incomplete || n.deleted || doneNodes.contains(n)) continue;
            Date tstamp = n.getTimestamp();
            WayPoint wpt = new WayPoint(n.coor);
            if (anonTime) {
                wpt.attr.put("time", "1970-01-01T00:00:00");
            } else {
                wpt.attr.put("time", WayPoint.GPXTIMEFMT.format(tstamp));
            }
            wpt.setTime();
            if (n.keys != null && n.keys.containsKey("name")) {
                wpt.attr.put("name", n.keys.get("name"));
            }
            gpxData.waypoints.add(wpt);
        }
        return gpxData;
    }

    public class ConvertToAnonTimeGpxLayerAction
    extends AbstractAction {
        public ConvertToAnonTimeGpxLayerAction() {
            super(I18n.tr((String)"Convert to GPX layer with anonymised time"), ImageProvider.get((String)"converttogpx"));
        }

        public void actionPerformed(ActionEvent e) {
            Main.main.addLayer((Layer)new GpxLayer(EditGpxLayer.this.toGpxData(true), I18n.tr((String)"Converted from: {0}", (Object[])new Object[]{EditGpxLayer.this.name})));
            Main.main.removeLayer((Layer)EditGpxLayer.this);
        }
    }

    public class ConvertToGpxLayerAction
    extends AbstractAction {
        public ConvertToGpxLayerAction() {
            super(I18n.tr((String)"Convert to GPX layer"), ImageProvider.get((String)"converttogpx"));
        }

        public void actionPerformed(ActionEvent e) {
            Main.main.addLayer((Layer)new GpxLayer(EditGpxLayer.this.toGpxData(false), I18n.tr((String)"Converted from: {0}", (Object[])new Object[]{EditGpxLayer.this.name})));
            Main.main.removeLayer((Layer)EditGpxLayer.this);
        }
    }
}

