/*
 * Decompiled with CFR 0.152.
 */
package com.innovant.josm.plugin.routing.gui;

import com.innovant.josm.plugin.routing.RoutingLayer;
import com.innovant.josm.plugin.routing.RoutingModel;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class RoutingDialog
extends ToggleDialog {
    private DefaultListModel model = new DefaultListModel();
    private JList jList = null;
    private JScrollPane jScrollPane = null;
    private static final long serialVersionUID = 8625615652900341987L;

    public RoutingDialog() {
        super(I18n.tr((String)"Routing"), "routing", I18n.tr((String)"Open a list of routing nodes"), Shortcut.registerShortcut((String)"subwindow:relations", (String)I18n.tr((String)"Toggle: {0}", (Object[])new Object[]{I18n.tr((String)"Routing")}), (int)82, (int)4), 150);
        this.setSize(456, 292);
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.setBorder(BorderFactory.createEtchedBorder(0));
        this.setName("PrincipalDialog");
        this.setFont(new Font("Dialog", 0, 12));
        this.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        this.add(this.getJScrollPane(), null);
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setBorder(BorderFactory.createEtchedBorder(1));
            this.jScrollPane.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            this.jScrollPane.setHorizontalScrollBarPolicy(30);
            this.jScrollPane.setVerticalScrollBarPolicy(20);
            this.jScrollPane.setName("nList");
            this.jScrollPane.setViewportBorder(BorderFactory.createEtchedBorder(1));
            this.jScrollPane.setViewportView(this.getJList());
        }
        return this.jScrollPane;
    }

    private JList getJList() {
        if (this.jList == null) {
            this.jList = new JList();
            this.jList.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            this.jList.setModel(this.model);
        }
        return this.jList;
    }

    public void removeNode(int index) {
        this.model.remove(index);
    }

    public void addNode(Node n) {
        this.model.addElement(n.id + " [" + n.coor.toDisplayString() + "]");
    }

    public void insertNode(int index, Node n) {
        this.model.insertElementAt(n.id + " [" + n.coor.toDisplayString() + "]", index);
    }

    public void clearNodes() {
        this.model.clear();
    }

    public void refresh() {
        this.clearNodes();
        if (Main.map.mapView.getActiveLayer() instanceof RoutingLayer) {
            RoutingLayer routingLayer = (RoutingLayer)Main.map.mapView.getActiveLayer();
            RoutingModel routingModel = routingLayer.getRoutingModel();
            for (Node n : routingModel.getSelectedNodes()) {
                this.addNode(n);
            }
        }
    }
}

