/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.czechaddress;

import java.text.Normalizer;
import org.openstreetmap.josm.data.coor.LatLon;

public abstract class StringUtils {
    public static String extractNumber(String s) {
        char ch;
        String result = "";
        for (int i = 0; i < s.length() && (ch = s.charAt(i)) >= '0' && ch <= '9'; ++i) {
            result = result + ch;
        }
        return result;
    }

    public static String coordinateToString(double coor) {
        double degrees = Math.floor(coor);
        double minutes = Math.floor(60.0 * (coor - degrees));
        double seconds = 3600.0 * (coor - degrees - minutes / 60.0);
        return String.valueOf(Math.round(degrees)) + "\u00b0" + String.valueOf(Math.round(minutes)) + "'" + String.valueOf((double)Math.round(100.0 * seconds) / 100.0) + "\"";
    }

    public static String latLonToString(LatLon position) {
        if (position == null) {
            return "";
        }
        return "(lat: " + StringUtils.coordinateToString(position.lat()) + " lon: " + StringUtils.coordinateToString(position.lon()) + ")";
    }

    public static boolean matchAbbrev(String s1, String s2) {
        String[] parts2;
        String[] parts1 = StringUtils.anglicize(s1).split(" +");
        if (parts1.length != (parts2 = StringUtils.anglicize(s2).split(" +")).length) {
            return false;
        }
        for (int i = 0; i < parts1.length; ++i) {
            int minLen;
            String part1 = parts1[i];
            String part2 = parts2[i];
            if (part1.charAt(part1.length() - 1) == '.') {
                part1 = part1.substring(0, part1.length() - 1);
            }
            if (part2.charAt(part2.length() - 1) == '.') {
                part2 = part2.substring(0, part2.length() - 1);
            }
            if ((part1 = part1.substring(0, minLen = Math.min(part1.length(), part2.length())).toUpperCase()).equals(part2 = part2.substring(0, minLen).toUpperCase())) continue;
            return false;
        }
        return true;
    }

    public static String capitalize(String s) {
        String[] noCapitalize;
        if (s == null) {
            return s;
        }
        String result = "";
        char last = ' ';
        for (char ch : s.toCharArray()) {
            ch = last >= 'a' && last <= '\u017e' || last >= 'A' && last <= '\u017d' ? Character.toLowerCase(ch) : Character.toTitleCase(ch);
            last = ch;
            result = result + ch;
        }
        for (String noc : noCapitalize = new String[]{"Nad", "Pod", "U", "Na", "Z"}) {
            result = result.replaceAll(" " + noc + " ", " " + noc.toLowerCase() + " ");
        }
        return result;
    }

    public static String anglicize(String str) {
        String strNFD = Normalizer.normalize(str, Normalizer.Form.NFD);
        StringBuilder sb = new StringBuilder();
        for (char ch : strNFD.toCharArray()) {
            if (Character.getType(ch) == 6) continue;
            sb.append(ch);
        }
        return sb.toString();
    }
}

