/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.slippymap;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.ImageObserver;
import java.util.Comparator;
import java.util.HashMap;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.slippymap.SlippyMapKey;
import org.openstreetmap.josm.plugins.slippymap.SlippyMapPreferences;
import org.openstreetmap.josm.plugins.slippymap.SlippyMapTile;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class SlippyMapLayer
extends Layer
implements ImageObserver,
Preferences.PreferenceChangedListener {
    public int currentZoomLevel = SlippyMapPreferences.getMinZoomLvl();
    private HashMap<SlippyMapKey, SlippyMapTile> tileStorage = null;
    Point[][] pixelpos = new Point[21][21];
    LatLon lastTopLeft;
    LatLon lastBotRight;
    int z12x0;
    int z12x1;
    int z12y0;
    int z12y1;
    private Image bufferImage;
    private SlippyMapTile clickedTile;
    private boolean needRedraw;
    private JPopupMenu tileOptionMenu;
    long lastCheck = 0L;

    public SlippyMapLayer() {
        super(I18n.tr((String)"Slippy Map"));
        this.background = true;
        this.clearTileStorage();
        this.tileOptionMenu = new JPopupMenu();
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr((String)"Load Tile")){

            public void actionPerformed(ActionEvent ae) {
                if (SlippyMapLayer.this.clickedTile != null) {
                    SlippyMapLayer.this.loadSingleTile(SlippyMapLayer.this.clickedTile);
                    SlippyMapLayer.this.needRedraw = true;
                    Main.map.repaint();
                }
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr((String)"Show Tile Status")){

            public void actionPerformed(ActionEvent ae) {
                if (SlippyMapLayer.this.clickedTile != null) {
                    SlippyMapLayer.this.clickedTile.loadMetadata();
                    SlippyMapLayer.this.needRedraw = true;
                    Main.map.repaint();
                }
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr((String)"Request Update")){

            public void actionPerformed(ActionEvent ae) {
                if (SlippyMapLayer.this.clickedTile != null) {
                    SlippyMapLayer.this.clickedTile.requestUpdate();
                    SlippyMapLayer.this.needRedraw = true;
                    Main.map.repaint();
                }
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr((String)"Load All Tiles")){

            public void actionPerformed(ActionEvent ae) {
                SlippyMapLayer.this.loadAllTiles();
                SlippyMapLayer.this.needRedraw = true;
                Main.map.repaint();
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr((String)"Increase zoom")){

            public void actionPerformed(ActionEvent ae) {
                SlippyMapLayer.this.increaseZoomLevel();
                SlippyMapLayer.this.needRedraw = true;
                Main.map.repaint();
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr((String)"Decrease zoom")){

            public void actionPerformed(ActionEvent ae) {
                SlippyMapLayer.this.decreaseZoomLevel();
                Main.map.repaint();
            }
        }));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Main.map.mapView.addMouseListener((MouseListener)new MouseAdapter(){

                    public void mouseClicked(MouseEvent e) {
                        if (e.getButton() != 3) {
                            return;
                        }
                        SlippyMapLayer.this.clickedTile = SlippyMapLayer.this.getTileForPixelpos(e.getX(), e.getY());
                        SlippyMapLayer.this.tileOptionMenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                });
                Layer.listeners.add(new Layer.LayerChangeListener(){

                    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
                    }

                    public void layerAdded(Layer newLayer) {
                    }

                    public void layerRemoved(Layer oldLayer) {
                        Main.pref.listener.remove(SlippyMapLayer.this);
                    }
                });
            }
        });
        Main.pref.listener.add(this);
    }

    public void increaseZoomLevel() {
        if (this.currentZoomLevel < SlippyMapPreferences.getMaxZoomLvl()) {
            ++this.currentZoomLevel;
            Main.debug((String)("increasing zoom level to: " + this.currentZoomLevel));
            this.needRedraw = true;
        } else {
            System.err.println("current zoom lvl (" + this.currentZoomLevel + ") couldnt be increased. " + "MaxZoomLvl (" + SlippyMapPreferences.getMaxZoomLvl() + ") reached.");
        }
    }

    public void decreaseZoomLevel() {
        if (this.currentZoomLevel > SlippyMapPreferences.getMinZoomLvl()) {
            Main.debug((String)("decreasing zoom level to: " + this.currentZoomLevel));
            --this.currentZoomLevel;
            this.needRedraw = true;
        } else {
            System.err.println("current zoom lvl couldnt be decreased. MinZoomLvl reached.");
        }
    }

    public void clearTileStorage() {
        int maxZoom = 30;
        this.tileStorage = new HashMap();
        this.checkTileStorage();
    }

    public void checkTileStorage() {
        int maxZoom = 30;
        long now = System.currentTimeMillis();
        if (now - this.lastCheck < 1000L) {
            return;
        }
        this.lastCheck = now;
        TreeSet<SlippyMapTile> tiles = new TreeSet<SlippyMapTile>(new TileTimeComp());
        tiles.addAll(this.tileStorage.values());
        int max_nr_tiles = 100;
        if (tiles.size() < max_nr_tiles) {
            Main.debug((String)("total of " + tiles.size() + " loaded tiles, size OK " + now));
            return;
        }
        int nr_to_drop = tiles.size() - max_nr_tiles;
        Main.debug((String)("total of " + tiles.size() + " tiles, need to flush " + nr_to_drop + " tiles"));
        for (SlippyMapTile t : tiles) {
            if (nr_to_drop <= 0) break;
            t.dropImage();
            --nr_to_drop;
        }
    }

    void loadSingleTile(SlippyMapTile tile) {
        tile.loadImage();
        this.checkTileStorage();
    }

    void loadAllTiles() {
        int tmp;
        MapView mv = Main.map.mapView;
        LatLon topLeft = mv.getLatLon(0, 0);
        LatLon botRight = mv.getLatLon(mv.getWidth(), mv.getHeight());
        this.z12x0 = this.lonToTileX(topLeft.lon());
        this.z12x1 = this.lonToTileX(botRight.lon());
        this.z12y0 = this.latToTileY(topLeft.lat());
        this.z12y1 = this.latToTileY(botRight.lat());
        if (this.z12x0 > this.z12x1) {
            tmp = this.z12x0;
            this.z12x0 = this.z12x1;
            this.z12x1 = tmp;
        }
        if (this.z12y0 > this.z12y1) {
            tmp = this.z12y0;
            this.z12y0 = this.z12y1;
            this.z12y1 = tmp;
        }
        if (this.z12x1 - this.z12x0 > 18) {
            System.out.println("Not downloading all tiles because there is more than 18 tiles on X axis!");
            return;
        }
        if (this.z12y1 - this.z12y0 > 18) {
            System.out.println("Not downloading all tiles because there is more than 18 tiles on Y axis!");
            return;
        }
        for (int x = this.z12x0 - 1; x <= this.z12x1; ++x) {
            for (int y = this.z12y0 - 1; y <= this.z12y1; ++y) {
                SlippyMapKey key = new SlippyMapKey(this.currentZoomLevel, x, y);
                SlippyMapTile tile = this.tileStorage.get(key);
                if (!key.valid) {
                    System.out.println("paint-1() made invalid key");
                    continue;
                }
                if (tile == null) {
                    tile = new SlippyMapTile(x, y, this.currentZoomLevel);
                    this.tileStorage.put(key, tile);
                }
                if (tile.getImage() != null) continue;
                this.loadSingleTile(tile);
            }
        }
    }

    double getImageScaling(Image img, Point p0, Point p1) {
        int realWidth = img.getWidth(this);
        int realHeight = img.getHeight(this);
        if (realWidth == -1 || realHeight == -1) {
            return 1.0;
        }
        int drawWidth = p1.x - p0.x;
        int drawHeight = p1.x - p0.x;
        double drawArea = drawWidth * drawHeight;
        double realArea = realWidth * realHeight;
        return drawArea / realArea;
    }

    public void paint(Graphics g, MapView mv) {
        int x;
        int tmp;
        long start = System.currentTimeMillis();
        LatLon topLeft = mv.getLatLon(0, 0);
        LatLon botRight = mv.getLatLon(mv.getWidth(), mv.getHeight());
        Graphics oldg = g;
        if (botRight.lon() == 0.0 || botRight.lat() == 0.0) {
            return;
        }
        if (this.lastTopLeft != null && this.lastBotRight != null && topLeft.equalsEpsilon(this.lastTopLeft) && botRight.equalsEpsilon(this.lastBotRight) && this.bufferImage != null && mv.getWidth() == this.bufferImage.getWidth(null) && mv.getHeight() == this.bufferImage.getHeight(null) && !this.needRedraw) {
            g.drawImage(this.bufferImage, 0, 0, null);
            return;
        }
        this.needRedraw = false;
        this.lastTopLeft = topLeft;
        this.lastBotRight = botRight;
        this.bufferImage = mv.createImage(mv.getWidth(), mv.getHeight());
        g = this.bufferImage.getGraphics();
        this.z12x0 = this.lonToTileX(topLeft.lon());
        this.z12x1 = this.lonToTileX(botRight.lon());
        this.z12y0 = this.latToTileY(topLeft.lat());
        this.z12y1 = this.latToTileY(botRight.lat());
        if (this.z12x0 > this.z12x1) {
            tmp = this.z12x0;
            this.z12x0 = this.z12x1;
            this.z12x1 = tmp;
        }
        if (this.z12y0 > this.z12y1) {
            tmp = this.z12y0;
            this.z12y0 = this.z12y1;
            this.z12y1 = tmp;
        }
        if (this.z12x1 - this.z12x0 > 18) {
            return;
        }
        if (this.z12y1 - this.z12y0 > 18) {
            return;
        }
        for (int x2 = this.z12x0 - 1; x2 <= this.z12x1 + 1; ++x2) {
            double lon = this.tileXToLon(x2);
            for (int y = this.z12y0 - 1; y <= this.z12y1 + 1; ++y) {
                LatLon tmpLL = new LatLon(this.tileYToLat(y), lon);
                this.pixelpos[x2 - this.z12x0 + 1][y - this.z12y0 + 1] = mv.getPoint(Main.proj.latlon2eastNorth(tmpLL));
            }
        }
        int fontHeight = g.getFontMetrics().getHeight();
        g.setColor(Color.DARK_GRAY);
        float fadeBackground = SlippyMapPreferences.getFadeBackground();
        Double imageScale = null;
        int count = 0;
        for (x = this.z12x0 - 1; x <= this.z12x1; ++x) {
            for (int y = this.z12y0 - 1; y <= this.z12y1; ++y) {
                Image img;
                SlippyMapKey key = new SlippyMapKey(this.currentZoomLevel, x, y);
                SlippyMapTile tile = this.tileStorage.get(key);
                if (!key.valid) {
                    System.out.println("loadAllTiles() made invalid key");
                    continue;
                }
                if (tile == null) {
                    tile = new SlippyMapTile(x, y, this.currentZoomLevel);
                    this.tileStorage.put(key, tile);
                    if (SlippyMapPreferences.getAutoloadTiles()) {
                        this.loadSingleTile(tile);
                    }
                    this.checkTileStorage();
                }
                if ((img = tile.getImage()) == null) continue;
                Point p = this.pixelpos[x - this.z12x0 + 1][y - this.z12y0 + 1];
                Point p2 = this.pixelpos[x - this.z12x0 + 2][y - this.z12y0 + 2];
                g.drawImage(img, p.x, p.y, p2.x - p.x, p2.y - p.y, this);
                if (imageScale == null) {
                    imageScale = new Double(this.getImageScaling(img, p, p2));
                }
                ++count;
                if (fadeBackground == 0.0f) continue;
                g.setColor(new Color(1.0f, 1.0f, 1.0f, fadeBackground));
                g.fillRect(p.x, p.y, p2.x - p.x, p2.y - p.y);
            }
        }
        g.setColor(Color.red);
        for (x = this.z12x0 - 1; x <= this.z12x1; ++x) {
            Point p = this.pixelpos[x - this.z12x0 + 1][0];
            if (SlippyMapPreferences.getDrawDebug()) {
                if (x % 32 == 0) {
                    g.fillRect(p.x - 1, 0, 3, mv.getHeight());
                } else {
                    g.drawLine(p.x, 0, p.x, mv.getHeight());
                }
            }
            for (int y = this.z12y0 - 1; y <= this.z12y1; ++y) {
                String md;
                SlippyMapKey key = new SlippyMapKey(this.currentZoomLevel, x, y);
                int texty = p.y + 2 + fontHeight;
                SlippyMapTile tile = this.tileStorage.get(key);
                if (tile == null) continue;
                if (!key.valid) {
                    System.out.println("paint-0() made invalid key");
                    continue;
                }
                if (tile.getImage() == null) {
                    this.loadSingleTile(tile);
                }
                p = this.pixelpos[x - this.z12x0 + 1][y - this.z12y0 + 2];
                if (SlippyMapPreferences.getDrawDebug()) {
                    g.drawString("x=" + x + " y=" + y + " z=" + this.currentZoomLevel + "", p.x + 2, texty);
                    texty += 1 + fontHeight;
                    if (x % 32 == 0 && y % 32 == 0) {
                        g.drawString("x=" + x / 32 + " y=" + y / 32 + " z=7", p.x + 2, texty);
                        texty += 1 + fontHeight;
                    }
                }
                if ((md = tile.getMetadata()) != null) {
                    g.drawString(md, p.x + 2, texty);
                    texty += 1 + fontHeight;
                }
                if (tile.getImage() == null) {
                    g.drawString(I18n.tr((String)"image not loaded"), p.x + 2, texty);
                    texty += 1 + fontHeight;
                }
                if (!SlippyMapPreferences.getDrawDebug() || x != this.z12x0 - 1) continue;
                if (y % 32 == 31) {
                    g.fillRect(0, p.y - 1, mv.getWidth(), 3);
                    continue;
                }
                g.drawLine(0, p.y, mv.getWidth(), p.y);
            }
        }
        oldg.drawImage(this.bufferImage, 0, 0, null);
        if (imageScale != null) {
            if (imageScale > 3.0) {
                if (SlippyMapPreferences.getAutozoom()) {
                    Main.debug((String)("autozoom increase: " + this.z12x1 + " " + this.z12x0 + " " + this.z12y1 + " " + this.z12y0 + topLeft + " " + botRight + " scale: " + imageScale));
                    this.increaseZoomLevel();
                }
                this.paint(oldg, mv);
            }
            if (imageScale < 0.32) {
                if (SlippyMapPreferences.getAutozoom()) {
                    Main.debug((String)("autozoom decrease: " + this.z12x1 + " " + this.z12x0 + " " + this.z12y1 + " " + this.z12y0 + topLeft + " " + botRight + " scale: " + imageScale));
                    this.decreaseZoomLevel();
                }
                this.paint(oldg, mv);
            }
        }
        g.setColor(Color.black);
        g.drawString("currentZoomLevel=" + this.currentZoomLevel, 120, 120);
    }

    SlippyMapTile getTileForPixelpos(int px, int py) {
        int tilex = this.z12x1;
        int tiley = this.z12y1;
        for (int x = this.z12x0; x <= this.z12x1; ++x) {
            if (this.pixelpos[x - this.z12x0 + 1][0].x <= px) continue;
            tilex = x - 1;
            break;
        }
        if (tilex == -1) {
            return null;
        }
        for (int y = this.z12y0; y <= this.z12y1; ++y) {
            if (this.pixelpos[0][y - this.z12y0 + 1].y <= py) continue;
            tiley = y - 1;
            break;
        }
        if (tiley == -1) {
            return null;
        }
        SlippyMapKey key = new SlippyMapKey(this.currentZoomLevel, tilex, tiley);
        if (!key.valid) {
            System.err.println("getTileForPixelpos(" + px + "," + py + ") made invalid key");
            return null;
        }
        SlippyMapTile tile = this.tileStorage.get(key);
        if (tile == null) {
            tile = new SlippyMapTile(tilex, tiley, this.currentZoomLevel);
            this.tileStorage.put(key, tile);
        }
        this.checkTileStorage();
        return tile;
    }

    public Icon getIcon() {
        return ImageProvider.get((String)"slippymap");
    }

    public Object getInfoComponent() {
        return null;
    }

    public Component[] getMenuEntries() {
        return new Component[]{new JMenuItem((Action)new LayerListDialog.ShowHideLayerAction((Layer)this)), new JMenuItem((Action)new LayerListDialog.DeleteLayerAction((Layer)this)), new JSeparator(), new JMenuItem((Action)new RenameLayerAction(this.getAssociatedFile(), (Layer)this)), new JSeparator(), new JMenuItem((Action)new LayerListPopup.InfoAction((Layer)this))};
    }

    public String getToolTipText() {
        return null;
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void mergeFrom(Layer from) {
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
    }

    private int latToTileY(double lat) {
        double l = lat / 180.0 * Math.PI;
        double pf = Math.log(Math.tan(l) + 1.0 / Math.cos(l));
        return (int)(Math.pow(2.0, this.currentZoomLevel - 1) * (Math.PI - pf) / Math.PI);
    }

    private int lonToTileX(double lon) {
        return (int)(Math.pow(2.0, this.currentZoomLevel - 3) * (lon + 180.0) / 45.0);
    }

    private double tileYToLat(int y) {
        return Math.atan(Math.sinh(Math.PI - Math.PI * (double)y / Math.pow(2.0, this.currentZoomLevel - 1))) * 180.0 / Math.PI;
    }

    private double tileXToLon(int x) {
        return (double)x * 45.0 / Math.pow(2.0, this.currentZoomLevel - 3) - 180.0;
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        boolean done;
        boolean bl = done = (infoflags & 0x70) != 0;
        if ((infoflags & 0x40) != 0) {
            String url = "unknown";
            for (SlippyMapTile tile : this.tileStorage.values()) {
                if (tile.getImage() != img) continue;
                url = tile.getImageURL().toString();
            }
            System.err.println("imageUpdate(" + img + ") error " + url + ")");
        }
        if ((infoflags & 8) != 0) {
            // empty if block
        }
        this.needRedraw = true;
        Main.map.repaint(done ? 0L : 100L);
        return !done;
    }

    public void preferenceChanged(String key, String newValue) {
        if (key.startsWith("slippymap") && !key.equals("slippymap.fade_background")) {
            this.clearTileStorage();
        }
    }

    public void destroy() {
        Main.pref.listener.remove(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TileTimeComp
    implements Comparator<SlippyMapTile> {
        TileTimeComp() {
        }

        @Override
        public int compare(SlippyMapTile s1, SlippyMapTile s2) {
            long t1 = s1.access_time();
            long t2 = s2.access_time();
            if (s1 == s2) {
                return 0;
            }
            if (t1 == t2) {
                t1 = s1.hashCode();
                t2 = s2.hashCode();
            }
            if (t1 < t2) {
                return -1;
            }
            return 1;
        }
    }
}

