/*
 * Decompiled with CFR 0.152.
 */
package wmsplugin;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.io.CacheFiles;
import wmsplugin.GeorefImage;
import wmsplugin.WMSGrabber;
import wmsplugin.WMSLayer;
import wmsplugin.WMSPlugin;

public class YAHOOGrabber
extends WMSGrabber {
    protected String browserCmd;

    YAHOOGrabber(String baseURL, Bounds b, Projection proj, double pixelPerDegree, GeorefImage image, MapView mv, WMSLayer layer, CacheFiles cache) {
        super("file:///" + WMSPlugin.getPrefsPath() + "ymap.html?", b, proj, pixelPerDegree, image, mv, layer, cache);
        this.browserCmd = baseURL.replaceFirst("yahoo://", "");
    }

    protected BufferedImage grab(URL url) throws IOException {
        Process browser;
        BufferedImage cached;
        String urlstring = url.toExternalForm();
        if (!urlstring.startsWith("file:///")) {
            urlstring = urlstring.replaceFirst("file:", "file://");
        }
        if ((cached = this.cache.getImg(urlstring)) != null) {
            return cached;
        }
        ArrayList<String> cmdParams = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(MessageFormat.format(this.browserCmd, urlstring));
        while (st.hasMoreTokens()) {
            cmdParams.add(st.nextToken());
        }
        System.out.println("WMS::Browsing YAHOO: " + cmdParams);
        ProcessBuilder builder = new ProcessBuilder(cmdParams);
        try {
            browser = builder.start();
        }
        catch (IOException ioe) {
            throw new IOException("Could not start browser. Please check that the executable path is correct.\n" + ioe.getMessage());
        }
        BufferedImage img = ImageIO.read(browser.getInputStream());
        this.cache.saveImg(urlstring, img);
        return img;
    }
}

