package org.openstreetmap.josm.plugins.czechaddress.gui;

import java.util.List;
import java.util.logging.Logger;
import org.openstreetmap.josm.plugins.czechaddress.*;
import javax.swing.Icon;
import javax.swing.tree.TreePath;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.AddressElement;
import org.openstreetmap.josm.plugins.czechaddress.intelligence.Match;
import org.openstreetmap.josm.plugins.czechaddress.intelligence.Reasoner;
import org.openstreetmap.josm.tools.ImageProvider;

/**
 * Dialog for displaying and handling conflicts.
 *
 * @author Radomír Černoch, radomir.cernoch@gmail.com
 */
public class ConflictResolver extends ExtendedDialog
        implements StatusListener {

    private Object selMainObj = null;
    private Object selBestFit = null;
    private Object selCandObj = null;

    /**
     * Creates new dialog, but does not display it, nor hook to messages.
     */
    public ConflictResolver() {

        super(Main.parent, "Řešení konfliktů",
                       new String[] { }, true);

        initComponents();

        elemConflictTree.setModel(new ElemTreeModel());
        primConflictTree.setModel(new PrimTreeModel());

        elemConflictTree.setCellRenderer(new UniversalTreeRenderer());
        primConflictTree.setCellRenderer(new UniversalTreeRenderer());

        // Create those lovely 'zoom' icons for professional look.
        Icon zoomIcon = ImageProvider.get("zoom.png");
        mainZoomButton.setIcon(zoomIcon); mainZoomButton.setText("");
        bestZoomButton.setIcon(zoomIcon); bestZoomButton.setText("");
        candZoomButton.setIcon(zoomIcon); candZoomButton.setText("");

        // And finalize initializing the form.
        setupDialog(mainPanel, new String[] { });
        setAlwaysOnTop(false);

        // TODO: Why does it always crash if the modality is set in constructor?
        setModal(false);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        mainPanel = new javax.swing.JPanel();
        candZoomButton = new javax.swing.JButton();
        bestZoomButton = new javax.swing.JButton();
        jTabbedPane1 = new javax.swing.JTabbedPane();
        jScrollPane1 = new javax.swing.JScrollPane();
        elemConflictTree = new javax.swing.JTree();
        jScrollPane2 = new javax.swing.JScrollPane();
        primConflictTree = new javax.swing.JTree();
        jLabel4 = new javax.swing.JLabel();
        mainTextField = new javax.swing.JTextField();
        bestTextField = new javax.swing.JTextField();
        jLabel5 = new javax.swing.JLabel();
        candTextField = new javax.swing.JTextField();
        candReassignButton = new javax.swing.JButton();
        jLabel6 = new javax.swing.JLabel();
        mainZoomButton = new javax.swing.JButton();

        getContentPane().setLayout(new java.awt.GridLayout(1, 0));

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        candZoomButton.setText("     ");
        candZoomButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                candZoomButtonActionPerformed(evt);
            }
        });

        bestZoomButton.setText("     ");
        bestZoomButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bestZoomButtonActionPerformed(evt);
            }
        });

        elemConflictTree.addTreeSelectionListener(new javax.swing.event.TreeSelectionListener() {
            public void valueChanged(javax.swing.event.TreeSelectionEvent evt) {
                treeValueChanged(evt);
            }
        });

        jScrollPane1.setViewportView(elemConflictTree);

        jTabbedPane1.addTab("Dle datab\u00e1ze", jScrollPane1);

        primConflictTree.addTreeSelectionListener(new javax.swing.event.TreeSelectionListener() {
            public void valueChanged(javax.swing.event.TreeSelectionEvent evt) {
                treeValueChanged(evt);
            }
        });

        jScrollPane2.setViewportView(primConflictTree);

        jTabbedPane1.addTab("Dle mapy", jScrollPane2);

        jLabel4.setText("Objekt v konfliktu:");

        mainTextField.setEditable(false);

        bestTextField.setEditable(false);

        jLabel5.setText("Nejlep\u0161\u00ed p\u0159i\u0159azen\u00ed:");

        candTextField.setEditable(false);

        candReassignButton.setText("P\u0159i\u0159adit");
        candReassignButton.setEnabled(false);
        candReassignButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                candReassignButtonActionPerformed(evt);
            }
        });

        jLabel6.setText("Probl\u00e9mov\u00fd element:");

        mainZoomButton.setText("     ");
        mainZoomButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mainZoomButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout mainPanelLayout = new javax.swing.GroupLayout(mainPanel);
        mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(
            mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup()
                .addGroup(mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel4)
                    .addComponent(jLabel5)
                    .addComponent(jLabel6))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup()
                        .addComponent(candTextField, javax.swing.GroupLayout.DEFAULT_SIZE, 232, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(candReassignButton))
                    .addComponent(bestTextField, javax.swing.GroupLayout.DEFAULT_SIZE, 319, Short.MAX_VALUE)
                    .addComponent(mainTextField, javax.swing.GroupLayout.DEFAULT_SIZE, 319, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(mainZoomButton)
                    .addComponent(bestZoomButton)
                    .addComponent(candZoomButton)))
            .addComponent(jTabbedPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 525, Short.MAX_VALUE)
        );
        mainPanelLayout.setVerticalGroup(
            mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup()
                .addComponent(jTabbedPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 199, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(mainTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(mainZoomButton)
                    .addComponent(jLabel4))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(bestTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(bestZoomButton)
                    .addComponent(jLabel5))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(candReassignButton)
                    .addComponent(candTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(candZoomButton)
                    .addComponent(jLabel6)))
        );
        getContentPane().add(mainPanel);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void treeValueChanged(javax.swing.event.TreeSelectionEvent evt) {//GEN-FIRST:event_treeValueChanged
        selMainObj = null;
        selBestFit = null;
        selCandObj = null;

        Reasoner r = CzechAddressPlugin.getReasoner();
        TreePath tp = evt.getPath();

        if (tp.getPathCount() >= 2)
            selMainObj = tp.getPathComponent(1);

        if (selMainObj instanceof AddressElement)
            selBestFit = r.translate((AddressElement) selMainObj);
        else if (selMainObj instanceof OsmPrimitive)
            selBestFit = r.translate((OsmPrimitive) selMainObj);

        mainTextField.setText(AddressElement.getName(selMainObj));
        bestTextField.setText(AddressElement.getName(selBestFit));

        if (tp.getPathCount() >= 3)
            selCandObj = tp.getPathComponent(2);

        candTextField.setText(AddressElement.getName(selCandObj));

        if (selCandObj != null) {
            if (selBestFit == null)
                bestTextField.setText(
                       "žádný neexistuje, objekty v konfliktu jsou rovnocenné");

            candReassignButton.setEnabled(true);
        } else
            candReassignButton.setEnabled(false);

        mainZoomButton.setEnabled(selMainObj instanceof OsmPrimitive);
        bestZoomButton.setEnabled(selBestFit instanceof OsmPrimitive);
        candZoomButton.setEnabled(selCandObj instanceof OsmPrimitive);

    }//GEN-LAST:event_treeValueChanged

    private void mainZoomButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mainZoomButtonActionPerformed
        assert selMainObj instanceof OsmPrimitive;
        MapUtils.zoomTo((OsmPrimitive) selMainObj);
    }//GEN-LAST:event_mainZoomButtonActionPerformed

    private void bestZoomButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bestZoomButtonActionPerformed
        assert selBestFit instanceof OsmPrimitive;
        MapUtils.zoomTo((OsmPrimitive) selBestFit);
    }//GEN-LAST:event_bestZoomButtonActionPerformed

    private void candZoomButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_candZoomButtonActionPerformed
        assert selCandObj instanceof OsmPrimitive;
        MapUtils.zoomTo((OsmPrimitive) selCandObj);
    }//GEN-LAST:event_candZoomButtonActionPerformed

    private void candReassignButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_candReassignButtonActionPerformed
        Reasoner r = CzechAddressPlugin.getReasoner();

        if (    (selMainObj instanceof OsmPrimitive)
             && (selCandObj instanceof AddressElement)) {
             
             Match best = r.findMatch((AddressElement) selBestFit);
             if (best != null) best.qualityChanged();

             List<Match> competitors = r.conflicts((OsmPrimitive) selMainObj);
             if (competitors != null) for (Match competitor : competitors)
                 competitor.qualityChanged();

             r.overwriteMatch((AddressElement) selCandObj, (OsmPrimitive) selMainObj);
        }

        else if ((selMainObj instanceof AddressElement)
              && (selCandObj instanceof OsmPrimitive)) {

            Match best = r.findMatch((OsmPrimitive) selBestFit);
            if (best != null) best.qualityChanged();

            List<Match> competitors = r.conflicts((AddressElement) selMainObj);
            if (competitors != null) for (Match competitor : competitors)
                 competitor.qualityChanged();

            r.overwriteMatch((AddressElement) selMainObj, (OsmPrimitive) selCandObj);
        }

        else
            assert false;
    }//GEN-LAST:event_candReassignButtonActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField bestTextField;
    private javax.swing.JButton bestZoomButton;
    private javax.swing.JButton candReassignButton;
    private javax.swing.JTextField candTextField;
    private javax.swing.JButton candZoomButton;
    private javax.swing.JTree elemConflictTree;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JTabbedPane jTabbedPane1;
    private javax.swing.JPanel mainPanel;
    private javax.swing.JTextField mainTextField;
    private javax.swing.JButton mainZoomButton;
    private javax.swing.JTree primConflictTree;
    // End of variables declaration//GEN-END:variables

    public void pluginStatusChanged(int message) {
        
        if (message == MESSAGE_CONFLICT_CHANGED) {
            setVisible(true);

            ((HalfCookedTreeModel) elemConflictTree.getModel()).notifyAllListeners();
            ((HalfCookedTreeModel) primConflictTree.getModel()).notifyAllListeners();

            /* TODO: For some reason the previous call does not repaint.
             *       Lines below fix it for now.*/
            elemConflictTree.setModel(new ElemTreeModel());
            primConflictTree.setModel(new PrimTreeModel());
        }
    }


//==============================================================================

    private class ElemTreeModel extends HalfCookedTreeModel {

        public ElemTreeModel() {
            root = "Konflikty podle objektů v databázi";
        }

        public Object getChild(Object parent, int index) {
            try {
                Reasoner r = CzechAddressPlugin.getReasoner();

                if (parent == root)
                    return r.getElementsInConflict().get(index);

                if (parent instanceof AddressElement)
                    return r.conflicts((AddressElement) parent).get(index).prim;

            } catch (Exception e) {  }
            return null;
        }

        public int getChildCount(Object parent) {
            try {
                Reasoner r = CzechAddressPlugin.getReasoner();

                if (parent == root)
                    return r.getElementsInConflict().size();

                if (parent instanceof AddressElement)
                    return r.conflicts((AddressElement) parent).size();
                
            } catch (Exception exp) { }
            return 0;
        }

        public int getIndexOfChild(Object parent, Object child) {
            try{
                Reasoner r = CzechAddressPlugin.getReasoner();

                if (parent == root)
                    return r.getElementsInConflict().indexOf(child);

                if (parent instanceof AddressElement)
                    return r.conflicts((AddressElement) parent).indexOf(child);
                
            } catch (Exception exp) { }
            return -1;
        }
    }


    private class PrimTreeModel extends HalfCookedTreeModel {

        public PrimTreeModel() {
            root = "Podle objeků databáze";
        }

        public Object getChild(Object parent, int index) {
            try {
                Reasoner r = CzechAddressPlugin.getReasoner();

                if (parent == root)
                    return r.getPrimitivesInConflict().get(index);

                if (parent instanceof OsmPrimitive)
                    return r.getConflictsconflictsve) parent).get(index).elem;
                
            } catch (Exception exp) { }
            return null;
        }

        public int getChildCount(Object parent) {

            try {
                Reasoner r = CzechAddressPlugin.getReasoner();

                if (parent == root)
                    return r.getPrimitivesInConflict().size();
                if (parent instanceof OsmPrimitive)
                    return r.getConflictsconflictsve) parent).size();

            } catch (Exception exp) { }
            return 0;
        }

        public int getIndexOfChild(Object parent, Object child) {
            
            try {
                Reasoner r = CzechAddressPlugin.getReasoner();

                if (parent == root) {
                    return r.getPrimitivesInConflict().indexOf(child);

                } else if (parent instanceof OsmPrimitive)
                    return r.getConflictsconflictsve) parent).indexOf(child);
                
            } catch (Exception exp) { }
            return -1;
        }
    }
}
