// License: GPL. Copyright 2007 by Immanuel Scholz and others
package org.openstreetmap.josm.data.osm.visitor;

import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;

/**
 * Visitor that adds the visited object to the dataset given at constructor.
 *
 * Is not capable of adding keys.
 *
 * @author imi
 */
public class AddVisitor extends AbstractVisitor {

    protected final DataSet ds;

    public AddVisitor(DataSet ds) {
        this.ds = ds;
    }

    public void visit(Node n) {
        ds.nodes.add(n);
    }
    public void visit(Way w) {
        ds.ways.add(w);
    }
    public void visit(Relation e) {
        ds.relations.add(e);
    }
}