/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.czechaddress.intelligence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.plugins.czechaddress.CzechAddressPlugin;
import org.openstreetmap.josm.plugins.czechaddress.NotNullList;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.AddressElement;
import org.openstreetmap.josm.plugins.czechaddress.intelligence.Match;
import org.openstreetmap.josm.plugins.czechaddress.proposal.ProposalContainer;
import org.openstreetmap.josm.plugins.czechaddress.proposal.ProposalDatabase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reasoner {
    private NotNullList<Match> matches = new NotNullList();
    private NotNullList<Match> conflicts = new NotNullList();
    private ArrayList<AddressElement> elemPool = new ArrayList();
    private List<OsmPrimitive> notMatchable = new ArrayList<OsmPrimitive>();
    private HashMap<OsmPrimitive, Match> primMatchHashIndex = new HashMap();
    private HashMap<AddressElement, Match> elemMatchHashIndex = new HashMap();
    private List<OsmPrimitive> primConflictListIndex = new ArrayList<OsmPrimitive>();
    private List<AddressElement> elemConflictListIndex = new ArrayList<AddressElement>();
    private HashMap<OsmPrimitive, List<Match>> primConflictHashIndex = new HashMap();
    private HashMap<AddressElement, List<Match>> elemConflictHashIndex = new HashMap();
    protected boolean matchesDirty = false;
    protected boolean conflictsDirty = false;

    public Reasoner(ArrayList<AddressElement> elementPool) {
        this.elemPool = elementPool;
    }

    public synchronized void addPrimitive(OsmPrimitive newPrimitive) {
        int firstNewIndex = this.matches.size();
        this.matchPrimitive(newPrimitive);
        this.ensureConsistency(firstNewIndex);
    }

    public synchronized void addPrimitives(Collection<OsmPrimitive> newPrimitives) {
        int firstNewIndex = this.matches.size();
        for (OsmPrimitive primitive : newPrimitives) {
            this.matchPrimitive(primitive);
        }
        this.ensureConsistency(firstNewIndex);
    }

    public synchronized void removePrimitive(OsmPrimitive primitive) {
    }

    public synchronized void overwriteMatch(AddressElement elem, OsmPrimitive prim) {
        int firstNewIndex = this.matches.size();
        this.matches.add(new Match(elem, prim, 4));
        this.matchesDirty = true;
        this.reconsider(elem);
        this.reconsider(prim);
        this.ensureConsistency(firstNewIndex);
    }

    public List<AddressElement> getElementPool() {
        return this.elemPool;
    }

    public List<OsmPrimitive> getNotMatchable() {
        return this.notMatchable;
    }

    public List<Match> getAllMatches() {
        return this.matches;
    }

    public Match findMatch(OsmPrimitive prim) {
        return this.primMatchHashIndex.get(prim);
    }

    public Match findMatch(AddressElement elem) {
        return this.primMatchHashIndex.get(elem);
    }

    public AddressElement translate(OsmPrimitive prim) {
        Match m = this.primMatchHashIndex.get(prim);
        if (m == null) {
            return null;
        }
        return m.elem;
    }

    public OsmPrimitive translate(AddressElement elem) {
        Match m = this.elemMatchHashIndex.get(elem);
        if (m == null) {
            return null;
        }
        return m.prim;
    }

    public List<Match> getConflicts(AddressElement elem) {
        return this.elemConflictHashIndex.get(elem);
    }

    public List<Match> getConflicts(OsmPrimitive prim) {
        return this.primConflictHashIndex.get(prim);
    }

    public List<AddressElement> getElementsInConflict() {
        return this.elemConflictListIndex;
    }

    public List<OsmPrimitive> getPrimitivesInConflict() {
        return this.primConflictListIndex;
    }

    public List<Match> getAllConflicts() {
        return this.conflicts;
    }

    public ProposalDatabase getProposals() {
        ProposalDatabase proposals = new ProposalDatabase();
        for (Match match : this.matches) {
            ProposalContainer proposalContainer = new ProposalContainer(match.prim);
            proposalContainer.addProposals(match.getDiff());
            if (proposalContainer.getProposals().size() <= 0) continue;
            proposals.addContainer(proposalContainer);
        }
        return proposals;
    }

    public NotNullList<Match> getMatchesForPrimitive(OsmPrimitive primitive) {
        NotNullList<Match> result = new NotNullList<Match>();
        for (AddressElement elem : this.elemPool) {
            result.add(Match.createMatch(elem, primitive));
        }
        return result;
    }

    protected void matchPrimitive(OsmPrimitive prim) {
        boolean assertions = false;
        if (!$assertionsDisabled) {
            assertions = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (prim.deleted) {
            return;
        }
        NotNullList<Match> suitable = this.getMatchesForPrimitive(prim);
        NotNullList<Match> toDelete = new NotNullList<Match>(suitable.size());
        for (Match match1 : suitable) {
            for (Match match2 : suitable) {
                if (match1 == match2 || match1.quality <= match2.quality) continue;
                toDelete.add(match2);
                if (!assertions) continue;
                System.out.println("Reasoner: Dominated match: " + match2.toString());
            }
        }
        suitable.removeAll(toDelete);
        for (Match match : this.matches) {
            this.reconsider(match.elem);
            this.reconsider(match.prim);
        }
        if (suitable.size() > 0) {
            this.matches.addAll(suitable);
            this.matchesDirty = true;
        } else {
            this.notMatchable.add(prim);
        }
    }

    protected void handleDirt() {
        if (this.matchesDirty || this.conflictsDirty) {
            this.regenerateIndexes();
        }
        if (this.matchesDirty) {
            CzechAddressPlugin.broadcastStatusChanged(2);
        }
        if (this.conflictsDirty) {
            CzechAddressPlugin.broadcastStatusChanged(3);
        }
        this.conflictsDirty = false;
        this.matchesDirty = false;
    }

    public void ensureConsistency() {
        this.ensureConsistency(0);
    }

    public void ensureConsistency(int startElementIndex) {
        startElementIndex = 0;
        NotNullList<Match> toDel = new NotNullList<Match>(10);
        for (Match match1 : this.matches) {
            for (Match match2 : this.matches) {
                if (match1 == match2) continue;
                if (match1.prim == match2.prim && match1.quality > match2.quality) {
                    System.out.println("Reasoner: Redundancy clean: " + match2);
                    toDel.add(match2);
                    this.matchesDirty = true;
                }
                if (match1.prim != match2.prim || match1.quality < match2.quality || match1.elem != match2.elem || toDel.contains(match1)) continue;
                System.out.println("Reasoner: Hyper redundancy: " + match2);
                toDel.add(match2);
                this.matchesDirty = true;
            }
        }
        this.matches.removeAll(toDel);
        toDel.clear();
        for (Match conflict1 : this.conflicts) {
            for (Match conflict2 : this.conflicts) {
                if (conflict1 == conflict2 || conflict1.prim != conflict2.prim || conflict1.elem != conflict2.elem || toDel.contains(conflict1)) continue;
                System.out.println("Reasoner: Confl redundancy: " + conflict2);
                toDel.add(conflict2);
                this.conflictsDirty = true;
            }
        }
        this.conflicts.removeAll(toDel);
        for (Match match : this.matches) {
            for (Match conflict : this.conflicts) {
                assert (match != conflict);
                assert (match.prim != conflict.prim);
            }
        }
        if (this.handleDeletedPrimitivesSlowButSafe()) {
            startElementIndex = 0;
        }
        this.handleInconsistentMatches(startElementIndex);
        this.handleDirt();
        CzechAddressPlugin.broadcastStatusChanged(5);
    }

    protected void handleInconsistentMatches(int startElementIndex) {
        boolean assertions = false;
        if (!$assertionsDisabled) {
            assertions = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        block0: for (int pos1 = 0; pos1 < this.matches.size(); ++pos1) {
            for (int pos2 = Math.max(pos1 + 1, startElementIndex); pos2 < this.matches.size(); ++pos2) {
                Match item1 = (Match)this.matches.get(pos1);
                Match item2 = (Match)this.matches.get(pos2);
                if (item1.elem != item2.elem && item1.prim != item2.prim) continue;
                if (assertions) {
                    System.out.println("1. match in conflict: " + item2);
                    System.out.println("2. match in conflict: " + item1);
                }
                if (item1.quality >= item2.quality) {
                    if (assertions) {
                        System.out.println("1. match moved to 'conflicts'.");
                    }
                    this.matches.remove(pos2);
                    this.conflicts.add(item2);
                    this.conflictsDirty = true;
                    this.matchesDirty = true;
                    --pos2;
                }
                if (item1.quality <= item2.quality) {
                    if (assertions) {
                        System.out.println("2. match moved to 'conflicts'.");
                        System.out.println("----------------------------------------------------------------------");
                    }
                    this.matches.remove(pos1);
                    this.conflicts.add(item1);
                    this.conflictsDirty = true;
                    this.matchesDirty = true;
                    --pos1;
                    continue block0;
                }
                if (!assertions) continue;
                System.out.println("----------------------------------------------------------------------");
            }
        }
    }

    protected boolean handleDeletedPrimitives() {
        boolean somethingChanged = false;
        NotNullList<OsmPrimitive> blockers = new NotNullList<OsmPrimitive>();
        for (Match match : this.matches) {
            if (!match.prim.deleted) continue;
            blockers.add(match.prim);
        }
        for (Match conflict : this.conflicts) {
            if (!conflict.prim.deleted) continue;
            blockers.add(conflict.prim);
        }
        for (int i = 0; i < blockers.size(); ++i) {
            OsmPrimitive blocker = (OsmPrimitive)blockers.get(i);
            if (this.primMatchHashIndex.get(blocker) != null) {
                Match toRemove = this.primMatchHashIndex.get(blocker);
                this.matches.remove(toRemove);
                this.primMatchHashIndex.remove(toRemove.prim);
                this.elemMatchHashIndex.remove(toRemove.elem);
                this.matchesDirty = true;
                somethingChanged = true;
            }
            if (this.primConflictHashIndex.get(blocker) == null) continue;
            for (Match match : this.primConflictHashIndex.get(blocker)) {
                if (this.elemConflictHashIndex.get(match.elem) != null) {
                    for (Match novy : this.elemConflictHashIndex.get(match.elem)) {
                        if (!blockers.contains(novy.prim)) {
                            blockers.add(novy.prim);
                        }
                        if (novy.prim.deleted || this.matches.contains(novy)) continue;
                        this.matches.add(novy);
                        this.matchesDirty = true;
                        somethingChanged = true;
                    }
                    this.conflicts.removeAll((Collection)this.elemConflictHashIndex.get(match.elem));
                    this.elemConflictHashIndex.remove(match.elem);
                    this.elemConflictListIndex.remove(match.elem);
                    this.conflictsDirty = true;
                    somethingChanged = true;
                }
                if (match.prim.deleted || this.matches.contains(match)) continue;
                this.matches.add(match);
                this.matchesDirty = true;
                somethingChanged = true;
            }
            this.conflicts.removeAll((Collection)this.primConflictHashIndex.get(blocker));
            this.primConflictHashIndex.remove(blocker);
            this.primConflictListIndex.remove(blocker);
            this.conflictsDirty = true;
            somethingChanged = true;
        }
        return somethingChanged;
    }

    protected boolean handleDeletedPrimitivesSlowButSafe() {
        boolean fire = false;
        for (Match match : this.matches) {
            fire |= match.qualityChanged();
        }
        for (Match conflict : this.conflicts) {
            fire |= conflict.qualityChanged();
        }
        if (fire) {
            this.matches.addAll(this.conflicts);
            this.conflicts.clear();
            this.conflictsDirty = true;
            this.matchesDirty = true;
            int i = 0;
            while (i < this.matches.size()) {
                Match match;
                match = (Match)this.matches.get(i);
                if (match.quality <= 0) {
                    System.out.println("Reasoner: Deleting " + this.matches.get(i));
                    this.matches.remove(i);
                    assert (fire);
                    assert (!this.matches.contains(match));
                    continue;
                }
                ++i;
            }
        }
        return fire;
    }

    protected void reconsider(OsmPrimitive prim) {
        List<Match> reconsider = this.getConflicts(prim);
        if (reconsider != null) {
            this.matches.addAll(reconsider);
            this.conflicts.removeAll(reconsider);
            this.conflictsDirty = true;
            this.matchesDirty = true;
        }
    }

    protected void reconsider(AddressElement elem) {
        List<Match> reconsider = this.getConflicts(elem);
        if (reconsider != null) {
            this.matches.addAll(reconsider);
            this.conflicts.removeAll(reconsider);
            this.conflictsDirty = true;
            this.matchesDirty = true;
        }
    }

    protected void regenerateIndexes() {
        boolean assertions = false;
        if (!$assertionsDisabled) {
            assertions = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        this.elemMatchHashIndex.clear();
        this.primMatchHashIndex.clear();
        this.elemConflictHashIndex.clear();
        this.primConflictHashIndex.clear();
        this.elemConflictListIndex.clear();
        this.primConflictListIndex.clear();
        for (Match match : this.matches) {
            this.elemMatchHashIndex.put(match.elem, match);
            this.primMatchHashIndex.put(match.prim, match);
        }
        for (Match conflict : this.conflicts) {
            List<Match> elemConflicts = this.elemConflictHashIndex.get(conflict.elem);
            if (elemConflicts == null) {
                elemConflicts = new ArrayList<Match>();
                this.elemConflictHashIndex.put(conflict.elem, elemConflicts);
            }
            elemConflicts.add(conflict);
            List<Match> primConflicts = this.primConflictHashIndex.get(conflict.prim);
            if (primConflicts == null) {
                primConflicts = new ArrayList<Match>();
                this.primConflictHashIndex.put(conflict.prim, primConflicts);
            }
            primConflicts.add(conflict);
        }
        for (AddressElement elem : this.elemConflictHashIndex.keySet()) {
            this.elemConflictListIndex.add(elem);
        }
        for (OsmPrimitive prim : this.primConflictHashIndex.keySet()) {
            this.primConflictListIndex.add(prim);
        }
        assert (this.elemConflictHashIndex.size() == this.elemConflictListIndex.size());
        assert (this.primConflictHashIndex.size() == this.primConflictListIndex.size());
        for (AddressElement elem : this.elemConflictListIndex) {
            assert (this.elemConflictHashIndex.get(elem) != null);
        }
        for (OsmPrimitive prim : this.primConflictListIndex) {
            assert (this.primConflictHashIndex.get(prim) != null);
        }
        if (assertions) {
            System.out.println("Sp\u00e1rovan\u00fdch dvojic: " + String.valueOf(this.matches.size()));
            System.out.println("Konflikt\u016f (celkem): " + String.valueOf(this.conflicts.size()) + "; " + String.valueOf(this.elemConflictListIndex.size()) + "+" + String.valueOf(this.primConflictListIndex.size()) + " element\u016f+primitiv");
        }
    }
}

