/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.czechaddress.intelligence;

import java.util.List;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.AddressElement;
import org.openstreetmap.josm.plugins.czechaddress.proposal.Proposal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Match {
    public static final int MATCH_OVERWRITE = 4;
    public static final int MATCH_ROCKSOLID = 3;
    public static final int MATCH_PARTIAL = 2;
    public static final int MATCH_CONFLICT = 1;
    public static final int MATCH_NOMATCH = 0;
    public int quality;
    public OsmPrimitive prim;
    public AddressElement elem;
    public String checkSum;

    public Match(AddressElement element, OsmPrimitive primitive, int qualityFactor) {
        assert (primitive != null);
        assert (element != null);
        assert (qualityFactor <= 4);
        assert (qualityFactor > 0) : "MATCH_NOMATCH represents no relation.It's pointless to waste memory for it.";
        assert (!primitive.deleted);
        this.prim = primitive;
        this.elem = element;
        this.quality = qualityFactor;
        this.checkSum = this.toString();
    }

    public List<Proposal> getDiff() {
        return this.elem.getDiff(this.prim);
    }

    public static Match createMatch(AddressElement element, OsmPrimitive primitive) {
        int quality = element.getMatchQuality(primitive);
        if (quality > 0) {
            return new Match(element, primitive, quality);
        }
        return null;
    }

    public boolean qualityChanged() {
        int newQuality;
        int n = this.prim.deleted ? 0 : (newQuality = this.quality == 4 ? 4 : this.elem.getMatchQuality(this.prim));
        if (this.prim instanceof Node) {
            Node node = (Node)this.prim;
            if (node.coor == null || node.eastNorth == null) {
                newQuality = 0;
                System.out.println("Suspicious node, ignoring it: " + AddressElement.getName((OsmPrimitive)node));
            }
        }
        boolean difference = newQuality != this.quality;
        this.quality = newQuality;
        return difference;
    }

    public String toString() {
        return "{Match: q=" + String.valueOf(this.quality) + "; elem='" + this.elem.toString() + "'; prim='" + AddressElement.getName(this.prim) + "'}";
    }
}

