/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.czechaddress.gui;

import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.czechaddress.CzechAddressPlugin;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.AddressElement;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.House;
import org.openstreetmap.josm.plugins.czechaddress.intelligence.Reasoner;
import org.openstreetmap.josm.plugins.czechaddress.proposal.AddKeyValueProposal;
import org.openstreetmap.josm.plugins.czechaddress.proposal.KeyValueChangeProposal;
import org.openstreetmap.josm.plugins.czechaddress.proposal.ProposalContainer;
import org.openstreetmap.josm.plugins.czechaddress.proposal.RemoveKeyProposal;
import org.openstreetmap.josm.tools.ImageProvider;

public class UniversalTreeRenderer
extends DefaultTreeCellRenderer {
    static ImageIcon iconAdd = ImageProvider.get((String)"actions", (String)"add.png");
    static ImageIcon iconEdit = ImageProvider.get((String)"actions", (String)"edit.png");
    static ImageIcon iconRemove = ImageProvider.get((String)"actions", (String)"remove.png");
    static ImageIcon nodeIcon = ImageProvider.get((String)"Mf_node.png");
    static ImageIcon wayIcon = ImageProvider.get((String)"Mf_way.png");
    static ImageIcon closedWayIcon = ImageProvider.get((String)"Mf_closedway.png");
    static ImageIcon relationIcon = ImageProvider.get((String)"Mf_relation.png");
    static ImageIcon envelopeNormIcon = ImageProvider.get((String)"envelope-closed-small.png");
    static ImageIcon envelopeStarIcon = ImageProvider.get((String)"envelope-closed-star-small.png");
    static ImageIcon envelopeExclIcon = ImageProvider.get((String)"envelope-closed-exclamation-small.png");

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component c = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        Reasoner r = CzechAddressPlugin.getReasoner();
        if (value instanceof ProposalContainer) {
            value = ((ProposalContainer)value).getTarget();
        }
        if (value instanceof AddressElement || value instanceof OsmPrimitive) {
            this.setText(AddressElement.getName(value));
        }
        if (value instanceof AddKeyValueProposal) {
            this.setIcon(iconAdd);
        } else if (value instanceof KeyValueChangeProposal) {
            this.setIcon(iconEdit);
        } else if (value instanceof RemoveKeyProposal) {
            this.setIcon(iconRemove);
        }
        if (value instanceof House) {
            House house = (House)value;
            this.setIcon(envelopeNormIcon);
            if (r.getConflicts(house) != null) {
                this.setIcon(envelopeExclIcon);
            } else if (r.translate(house) == null) {
                this.setIcon(envelopeStarIcon);
            }
        } else if (value instanceof Node) {
            this.setIcon(nodeIcon);
        } else if (value instanceof Relation) {
            this.setIcon(relationIcon);
        } else if (value instanceof Way) {
            if (((Way)value).isClosed()) {
                this.setIcon(closedWayIcon);
            } else {
                this.setIcon(wayIcon);
            }
        }
        return c;
    }
}

