/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.czechaddress.gui;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.plugins.czechaddress.CzechAddressPlugin;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.AddressElement;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.ElementWithStreets;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.Region;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.Suburb;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.ViToCi;

public class LocationSelector
extends ExtendedDialog {
    protected ElementWithStreets selectedElement;
    protected ArrayList<ItemListener> listeners = new ArrayList();
    private JComboBox castObceComboBox;
    private JLabel castObceLabel;
    private JPanel mainPanel;
    private JComboBox obecComboBox;
    private JLabel obecLabel;
    private JComboBox oblastComboBox;
    private JLabel oblastLabel;

    public static ElementWithStreets selectLocation() {
        LocationSelector ls = new LocationSelector();
        ls.setVisible(true);
        if (ls.getValue() == 1) {
            return ls.selectedElement;
        }
        return null;
    }

    private LocationSelector() {
        super(Main.parent, "V\u00fdb\u011br um\u00edst\u011bn\u00ed", new String[]{"OK", "Zru\u0161it"}, true);
        this.initComponents();
        this.setupDialog(this.mainPanel, new String[]{"ok.png", "cancel.png"});
        this.oblastComboBox.setRenderer(new AddressElementRenderer());
        this.obecComboBox.setRenderer(new AddressElementRenderer());
        this.castObceComboBox.setRenderer(new AddressElementRenderer());
        this.oblastComboBox.setModel(new DefaultComboBoxModel<Object>(CzechAddressPlugin.getDatabase().regions.toArray()));
        this.autodetectLocation();
        this.oblastComboBoxItemStateChanged(null);
    }

    private void autodetectLocation() {
        LatLon center;
        boolean assertions = false;
        if (!$assertionsDisabled) {
            assertions = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        OsmPrimitive bestFit = null;
        double bestLen = 0.0;
        BoundingXYVisitor visitor = new BoundingXYVisitor();
        for (OsmPrimitive op : Main.ds.allPrimitives()) {
            if (op instanceof Node) {
                ((Node)op).visit((Visitor)visitor);
                continue;
            }
            if (!(op instanceof Way)) continue;
            ((Way)op).visit((Visitor)visitor);
        }
        try {
            Bounds bounds = visitor.getBounds();
            LatLon max = bounds.max;
            LatLon min = bounds.min;
            center = new LatLon((max.getX() + min.getX()) / 2.0, (max.getY() + min.getY()) / 2.0);
        }
        catch (Exception e) {
            System.err.println("AUTO: No bounds to determine autolocation.");
            return;
        }
        if (assertions) {
            System.out.println("AUTO: Center is " + center);
        }
        for (OsmPrimitive op : Main.ds.allPrimitives()) {
            if (!(op instanceof Node)) continue;
            Node node = (Node)op;
            double multiplicator = 5.0;
            if (new String("city").equals(op.get("place"))) {
                multiplicator = 2.8;
            } else if (new String("town").equals(op.get("place"))) {
                multiplicator = 2.3;
            } else if (new String("village").equals(op.get("place"))) {
                multiplicator = 2.0;
            } else {
                if (!new String("suburb").equals(op.get("place"))) continue;
                multiplicator = 1.0;
            }
            double currLen = multiplicator * node.coor.distance((Point2D)center);
            if (bestFit != null && !(currLen < bestLen)) continue;
            bestFit = op;
            bestLen = currLen;
        }
        if (bestFit != null) {
            if (assertions) {
                System.out.println("AUTO: Best fit " + bestFit.getName() + "\t " + bestFit.get("name"));
            }
            block4: for (Region oblast : CzechAddressPlugin.getDatabase().regions) {
                block5: for (ViToCi obec : oblast.getViToCis()) {
                    if (!bestFit.get("place").equals("suburb")) {
                        if (!obec.getName().toUpperCase().equals(bestFit.get("name").toUpperCase())) continue;
                        this.oblastComboBox.setSelectedItem(oblast);
                        this.obecComboBox.setSelectedItem(obec);
                        for (Suburb castObce : obec.getSuburbs()) {
                            if (!castObce.getName().toUpperCase().equals(bestFit.get("name").toUpperCase())) continue;
                            this.castObceComboBox.setSelectedItem(castObce);
                            continue block4;
                        }
                        continue block4;
                    }
                    for (Suburb castObce : obec.getSuburbs()) {
                        if (!castObce.getName().toUpperCase().equals(bestFit.get("name").toUpperCase())) continue;
                        this.oblastComboBox.setSelectedItem(oblast);
                        this.obecComboBox.setSelectedItem(obec);
                        this.castObceComboBox.setSelectedItem(castObce);
                        continue block5;
                    }
                }
            }
        }
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.oblastComboBox = new JComboBox();
        this.castObceComboBox = new JComboBox();
        this.obecComboBox = new JComboBox();
        this.obecLabel = new JLabel();
        this.castObceLabel = new JLabel();
        this.oblastLabel = new JLabel();
        this.getContentPane().setLayout(new GridLayout(1, 0));
        this.setTitle("V\u00fdb\u011br um\u00edst\u011bn\u00ed");
        this.setModal(true);
        this.setName("locationSelector");
        this.oblastComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                LocationSelector.this.oblastComboBoxItemStateChanged(evt);
            }
        });
        this.castObceComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                LocationSelector.this.castObceComboBoxItemStateChanged(evt);
            }
        });
        this.obecComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                LocationSelector.this.obecComboBoxItemStateChanged(evt);
            }
        });
        this.obecLabel.setText("Obec:");
        this.castObceLabel.setText("\u010c\u00e1st obce:");
        this.oblastLabel.setText("Oblast:");
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.oblastLabel).addComponent(this.obecLabel).addComponent(this.castObceLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.castObceComboBox, 0, 340, Short.MAX_VALUE).addComponent(this.obecComboBox, 0, 340, Short.MAX_VALUE).addComponent(this.oblastComboBox, 0, 340, Short.MAX_VALUE))));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.oblastLabel).addComponent(this.oblastComboBox, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.obecLabel).addComponent(this.obecComboBox, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.castObceLabel).addComponent(this.castObceComboBox, -2, 25, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.getContentPane().add(this.mainPanel);
    }

    private void oblastComboBoxItemStateChanged(ItemEvent evt) {
        Region oblast = (Region)this.oblastComboBox.getSelectedItem();
        if (oblast == null) {
            return;
        }
        this.obecComboBox.setModel(new DefaultComboBoxModel<Object>(oblast.getViToCis().toArray()));
        this.obecComboBox.setEnabled(this.obecComboBox.getModel().getSize() > 1);
        this.obecComboBoxItemStateChanged(null);
    }

    private void obecComboBoxItemStateChanged(ItemEvent evt) {
        ViToCi obec = (ViToCi)this.obecComboBox.getSelectedItem();
        if (obec == null) {
            return;
        }
        this.castObceComboBox.setModel(new DefaultComboBoxModel<Object>(obec.getSuburbs().toArray()));
        this.castObceComboBox.setEnabled(this.castObceComboBox.getModel().getSize() > 1);
        this.castObceComboBoxItemStateChanged(null);
    }

    private void castObceComboBoxItemStateChanged(ItemEvent evt) {
        if (this.castObceComboBox.getSelectedItem() != null) {
            this.selectedElement = (ElementWithStreets)this.castObceComboBox.getSelectedItem();
        } else if (this.obecComboBox.getSelectedItem() != null) {
            this.selectedElement = (ElementWithStreets)this.obecComboBox.getSelectedItem();
        } else if (this.oblastComboBox.getSelectedItem() != null) {
            this.selectedElement = (ElementWithStreets)this.oblastComboBox.getSelectedItem();
        }
    }

    private class AddressElementRenderer
    extends DefaultListCellRenderer {
        private AddressElementRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof AddressElement && !(value instanceof Region)) {
                this.setText(((AddressElement)value).getName());
            }
            return c;
        }
    }
}

