/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.czechaddress.gui;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.plugins.czechaddress.CzechAddressPlugin;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.AddressElement;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.Street;
import org.openstreetmap.josm.plugins.czechaddress.intelligence.Capitalizator;

public class DatabaseModifier
extends ExtendedDialog {
    StreetModel<Street> streetModel = new StreetModel();
    private JPanel mainPanel;
    private JScrollPane streetScrollPane;
    private JTable streetTable;
    private JTabbedPane tabbedPane;

    public DatabaseModifier() {
        super(Main.parent, "Upravit datab\u00e1zi", new String[]{"OK", "Zru\u0161it"}, true);
        this.initComponents();
        Capitalizator cap = new Capitalizator(Main.ds.allPrimitives(), CzechAddressPlugin.getLocation().getStreets());
        for (Street capStreet : cap.getCapitalised()) {
            String primName;
            assert (cap.translate(capStreet).get("name") != null) : capStreet;
            String elemName = capStreet.getName();
            if (elemName.equals(primName = cap.translate(capStreet).get("name"))) continue;
            this.streetModel.elems.add(capStreet);
            this.streetModel.names.add(primName);
        }
        this.streetTable.setModel(this.streetModel);
        this.streetTable.setDefaultRenderer(AddressElement.class, new AddressElementRenderer());
        this.setupDialog(this.mainPanel, new String[]{"ok.png", "cancel.png"});
    }

    protected void buttonAction(ActionEvent evt) {
        super.buttonAction(evt);
        if (this.getValue() == 1) {
            assert (this.streetModel.elems.size() == this.streetModel.names.size());
            for (int i = 0; i < this.streetModel.elems.size(); ++i) {
                ((Street)this.streetModel.elems.get(i)).setName(this.streetModel.names.get(i));
            }
        }
        this.setVisible(false);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.tabbedPane = new JTabbedPane();
        this.streetScrollPane = new JScrollPane();
        this.streetTable = new JTable();
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridLayout(1, 0));
        this.streetTable.setModel(new DefaultTableModel(new Object[][]{{null, null}, {null, null}, {null, null}, {null, null}}, new String[]{"P\u016fvodn\u00ed n\u00e1zev", "N\u00e1vrh z mapy"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Object.class, String.class};
                this.canEdit = new boolean[]{false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.streetTable.setColumnSelectionAllowed(true);
        this.streetScrollPane.setViewportView(this.streetTable);
        this.streetTable.getColumnModel().getSelectionModel().setSelectionMode(1);
        this.streetTable.getColumnModel().getColumn(1).setResizable(false);
        this.tabbedPane.addTab("Ulice", this.streetScrollPane);
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tabbedPane, -1, 476, Short.MAX_VALUE));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.tabbedPane, -2, 289, -2).addContainerGap(25, Short.MAX_VALUE)));
        this.getContentPane().add(this.mainPanel);
        this.pack();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StreetModel<Element>
    implements TableModel {
        List<Element> elems = new ArrayList<Element>();
        List<String> names = new ArrayList<String>();

        private StreetModel() {
        }

        @Override
        public int getRowCount() {
            assert (this.elems.size() == this.names.size());
            return this.elems.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "P\u016fvodn\u00ed n\u00e1zev";
            }
            if (columnIndex == 1) {
                return "Navr\u017een\u00fd n\u00e1zev";
            }
            assert (false) : columnIndex;
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return AddressElement.class;
            }
            if (columnIndex == 1) {
                return String.class;
            }
            assert (false) : columnIndex;
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return this.elems.get(rowIndex);
            }
            if (columnIndex == 1) {
                return this.names.get(rowIndex);
            }
            assert (false) : columnIndex;
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            assert (columnIndex == 1);
            this.names.set(rowIndex, (String)aValue);
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
        }
    }

    private class AddressElementRenderer
    extends DefaultTableCellRenderer {
        protected void setValue(Object value) {
            super.setValue(value);
            if (value instanceof AddressElement) {
                this.setText(((AddressElement)value).getName());
            }
        }
    }
}

